/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.IInformaDadoPin;
import com.csi.ctfclient.operacoes.entrada.IRemoveCard;
import com.csi.ctfclient.operacoes.model.Cartao;
import com.csi.ctfclient.operacoes.model.CartaoChip;
import com.csi.ctfclient.operacoes.model.CartaoMagnetico;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.operacoes.model.ControladorEstatistica;
import com.csi.ctfclient.operacoes.model.DadosEstatistica;
import com.csi.ctfclient.operacoes.model.PinInfo;
import com.csi.ctfclient.tools.devices.EventoDispositivoEntrada;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.devices.emv.EventoPinEMV;
import com.csi.ctfclient.tools.devices.emvfull.BibliotecaPinpad;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class MicLeituraPin {
    public static final String USERCANCEL = "USERCANCEL";
    public static final String USERCANCEL_RETRY = "USERCANCEL_RETRY";
    public static final String SUCESS = "SUCESS";
    public static final String ERRO = "ERRO";
    private Logger logger = CTFClientLogger.getPeriferico();

    public String execute(IInformaDadoPin dados) throws ExcecaoApiAc {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ControladorPerifericos perifericos = dados.getPerifericos();
        String titulo = dados.getTituloAguardaPin() != null && !dados.getTituloAguardaPin().equals("") ? dados.getTituloAguardaPin() : inter.getMessage("LEIPIN_TITLE");
        LayoutDisplay displayModel = null;
        if (titulo.indexOf("#") != 0) {
            String[] mensagens = titulo.split("#");
            displayModel = new LayoutDisplay();
            for (int i = 0; i < mensagens.length; ++i) {
                displayModel.addLinha(new Linha(mensagens[i]));
            }
        } else {
            displayModel = new LayoutDisplay();
            displayModel.addLinha(new Linha(titulo));
        }
        EventoDispositivoEntrada evento = null;
        String msgDisplay = "";
        do {
            if (msgDisplay.equals("")) continue;
            displayModel = new LayoutDisplay(msgDisplay);
            perifericos.imprimeDisplay(displayModel);
        } while ((evento = perifericos.capturaDado(displayModel, ConstantesApiAc.CAP_LEITURA_PIN, false, new long[]{1L, 4L})) instanceof EventoTeclado && ("VOLTA".equals(((EventoTeclado)evento).getTeclaFinalizadora()) && perifericos.exibeMenuCancelamento() == 2 || "ENTRA".equals(((EventoTeclado)evento).getTeclaFinalizadora())));
        if (evento instanceof EventoPinEMV) {
            EventoPinEMV eventoPinEMV = (EventoPinEMV)evento;
            if (eventoPinEMV.getErro()) {
                dados.setErrorCode(eventoPinEMV.getErroCodigo());
                if (dados.getEntradaIntegracao() != null) {
                    dados.setErroIntegracao(new CodigoErroIntegracao(5328, "ERRO NA CAPTURA DO PIN"));
                } else {
                    dados.getSaidaApiTef().setRetorno(20);
                }
                if (dados.isPossuiChaveContingencia() && eventoPinEMV.getErroCodigo() == 42) {
                    this.logger.log((Priority)Level.INFO, (Object)"Erro ao utilizar a criptografia principal de senha, a conting\u00eancia ser\u00e1 utilizada");
                    return ERRO;
                }
                displayModel = new LayoutDisplay(inter.getMessage("LEIPIN_ERRO") + eventoPinEMV.getErroCodigo(), 1500L);
                perifericos.imprimeDisplay(displayModel);
                return ERRO;
            }
            if (perifericos.getPin().isBibliotecaEMV() && dados.getCartao() instanceof CartaoChip) {
                dados.setRemoveCardMessage(IRemoveCard.MSG_TRANS_APROVADA);
                dados.setErrorCode(0);
            }
            if (eventoPinEMV.getDigitacaoCancelada()) {
                return USERCANCEL;
            }
            switch (eventoPinEMV.getErroCodigo()) {
                case 1: 
                case 2: {
                    this.logger.debug((Object)"");
                    dados.setErrorCode(eventoPinEMV.getErroCodigo());
                    if (dados.getEntradaIntegracao() != null) {
                        dados.setErroIntegracao(new CodigoErroIntegracao(5328, "ERRO NA CAPTURA DO PIN"));
                    } else if (dados.getSaidaApiTef() != null) {
                        dados.getSaidaApiTef().setRetorno(20);
                    }
                    displayModel = new LayoutDisplay(inter.getMessage("LEIPIN_ERRO") + eventoPinEMV.getErroCodigo(), 1500L);
                    perifericos.imprimeDisplay(displayModel);
                    return ERRO;
                }
            }
            dados.setTeclaFuncaoPressionada(eventoPinEMV.getErroCodigo());
            PinInfo pinInfo = new PinInfo();
            pinInfo.setPinCriptografado(eventoPinEMV.getCodigo());
            pinInfo.setNumeroSerieChaveDUKPT(eventoPinEMV.getNumeroSerieChaveDUKPT());
            pinInfo.setStatusAprovacaoTransacao(eventoPinEMV.getStatusAprovacaoTransacao());
            pinInfo.setCapturadoVerificacaoOnline(true);
            dados.setPinInfo(pinInfo);
            if (dados.isCapturaSenha()) {
                try {
                    boolean persistirDados = false;
                    Cartao cartao = dados.getCartao();
                    ControladorEstatistica controladorEstatistica = ControladorEstatistica.getInstance();
                    DadosEstatistica dadosEstatistica = controladorEstatistica.getDadosEstatistica();
                    if (cartao instanceof CartaoMagnetico) {
                        dadosEstatistica.addSenhaPinMagnetico();
                        persistirDados = true;
                    }
                    if (persistirDados) {
                        controladorEstatistica.persistirDados(dadosEstatistica);
                    }
                }
                catch (ExcecaoApiAc e) {
                    this.logger.error((Object)"Erro ao contabilizar estat\u00edstica em MicLeituraPin: ", (Throwable)e);
                }
            }
            return SUCESS;
        }
        if (evento instanceof EventoTeclado) {
            if (perifericos.getPin() != null) {
                BibliotecaPinpad pin = (BibliotecaPinpad)perifericos.getPin();
                pin.abort();
            }
            return USERCANCEL;
        }
        return ERRO;
    }
}

