/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.ITaxaEmbarque;
import com.csi.ctfclient.operacoes.model.Embarque;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import java.math.BigDecimal;

public class MicLeituraTaxaEmbarque {
    public static final String SUCESS = "SUCESS";
    public static final String FILLED = "FILLED";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String TAX_EXCEED = "TAX_EXCEED";
    public static final String TAX_EXCEED_AC = "TAX_EXCEED_AC";
    private InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();

    public String execute(ITaxaEmbarque dados) throws ExcecaoApiAc {
        ControladorPerifericos periferico = dados.getPerifericos();
        boolean habilitada = dados.getSaidaApiTef().isPedeTaxaEmbarque();
        if (dados.getTaxaEmbarque() != null) {
            if (habilitada) {
                return FILLED;
            }
            this.exibeMensagemExcedeTaxa(periferico);
            return TAX_EXCEED;
        }
        if (habilitada && dados.getEntradaIntegracao() != null && dados.getEntradaIntegracao().isValorTaxaEmbarqueCtrl()) {
            Embarque embarque = new Embarque(dados.getEntradaIntegracao().getValorTaxaEmbarque());
            dados.setTaxaEmbarque(embarque);
        } else if (habilitada) {
            LayoutDisplay displayModel = new LayoutDisplay();
            displayModel.addLinha(new Linha(this.inter.getMessage("TAXA DE EMBARQUE?")));
            displayModel.addLinha(new Linha(this.inter.getMessage("LEITAXEMB_TAXA_EMBARQUE_VALOR")));
            EventoTeclado eventoTeclado = (EventoTeclado)periferico.capturaDado(displayModel, ConstantesApiAc.CAP_TAXA_EMBARQUE, false, 8, false);
            if (eventoTeclado.getTeclaFinalizadora().equals("VOLTA")) {
                return USER_CANCEL;
            }
            if (eventoTeclado.getTeclaFinalizadora().equals("ENTRA")) {
                int totalDigitos = eventoTeclado.getStringLida().length() - eventoTeclado.getNumCaracteresDigitados();
                String valor = eventoTeclado.getStringLida().substring(totalDigitos);
                if (valor.equals("")) {
                    valor = "000";
                }
                BigDecimal valorEmbarque = new BigDecimal(valor);
                valorEmbarque = valorEmbarque.movePointLeft(2);
                Embarque embarque = new Embarque(valorEmbarque);
                dados.setTaxaEmbarque(embarque);
            }
        }
        return SUCESS;
    }

    private String exibeMensagemExcedeTaxa(ControladorPerifericos perifericos) throws ExcecaoNaoLocal {
        LayoutDisplay displayModel = new LayoutDisplay(this.inter.getMessage("LEITAXEMB_TAXA_EXCEDIDA"));
        EventoTeclado eventoTeclado = (EventoTeclado)perifericos.confirmaDado(displayModel);
        return eventoTeclado.getTeclaFinalizadora();
    }
}

