/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.ITaxaServico;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.operacoes.model.Servico;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import java.math.BigDecimal;

public class MicLeituraTaxaServico {
    public static final String SUCESS = "SUCESS";
    public static final String FILLED = "FILLED";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String TAX_EXCEED = "TAX_EXCEED";
    public static final String TAX_EXCEED_AC = "TAX_EXCEED_AC";
    private InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();

    public String execute(ITaxaServico dados) throws ExcecaoNaoLocal {
        boolean habilitado = dados.getSaidaApiTef().isPedeTaxaServico();
        if (dados.getServico() != null) {
            return FILLED;
        }
        if (habilitado) {
            BigDecimal taxaServico = dados.getSaidaApiTef().getTaxaServico();
            if (dados.getEntradaIntegracao() != null && dados.getEntradaIntegracao().isValorTaxaServicoCtrl()) {
                if (Servico.isValorValido(dados.getValorTransacao(), taxaServico, dados.getEntradaIntegracao().getValorTaxaServico())) {
                    Servico servico = new Servico(dados.getEntradaIntegracao().getValorTaxaServico());
                    servico.setTaxa(taxaServico);
                    dados.setServico(servico);
                } else {
                    dados.setErroIntegracao(new CodigoErroIntegracao(5305, this.inter.getMessage("LEITAXSER_EXCEDE_TAXA_SERVICO")));
                }
            } else {
                ControladorPerifericos periferico = dados.getPerifericos();
                LayoutDisplay displayModel = new LayoutDisplay();
                displayModel.addLinha(new Linha(this.inter.getMessage("LEITAXSER_TAXA_SERVICO")));
                displayModel.addLinha(new Linha(this.inter.getMessage("LEITAXSER_TAXA_SERVICO_VALOR")));
                EventoTeclado eventoTeclado = (EventoTeclado)periferico.capturaDado(displayModel, ConstantesApiAc.CAP_TAXA_SERVICO, false, 8, false);
                if (eventoTeclado.getTeclaFinalizadora().equals("VOLTA")) {
                    return USER_CANCEL;
                }
                if (eventoTeclado.getTeclaFinalizadora().equals("ENTRA")) {
                    int totalDigitos = eventoTeclado.getStringLida().length() - eventoTeclado.getNumCaracteresDigitados();
                    String valor = eventoTeclado.getStringLida().substring(totalDigitos);
                    if (valor.equals("")) {
                        valor = "000";
                    }
                    BigDecimal valorServico = new BigDecimal(valor);
                    valorServico = valorServico.movePointLeft(2);
                    Servico servico = new Servico(valorServico);
                    servico.setTaxa(taxaServico);
                    if (!servico.isValorValido(dados.getValorTransacao())) {
                        this.exibeMensagemExcedeTaxa(dados);
                        return TAX_EXCEED;
                    }
                    dados.setServico(servico);
                    return SUCESS;
                }
            }
        }
        return SUCESS;
    }

    private void exibeMensagemExcedeTaxa(ITaxaServico dado) throws ExcecaoNaoLocal {
        ControladorPerifericos perifericos = dado.getPerifericos();
        LayoutDisplay displayModel = new LayoutDisplay();
        displayModel.addLinha(new Linha(this.inter.getMessage("LEITAXSER_EXCEDE_TAXA1")));
        displayModel.addLinha(new Linha(this.inter.getMessage("LEITAXSER_EXCEDE_TAXA2")));
        perifericos.confirmaDado(displayModel);
    }
}

