/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.IDadoConta;
import com.csi.ctfclient.operacoes.model.ContaConvenio;
import com.csi.ctfclient.operacoes.model.ContaTitulo;
import com.csi.ctfclient.tools.devices.display.ItemMenu;
import com.csi.ctfclient.tools.devices.display.LayoutMenu;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;

public class MicLeituraTipoConta {
    public static final String SUCESS_TITULO = "SUCESS_TITULO";
    public static final String SUCESS_CONVENIO = "SUCESS_CONVENIO";
    public static final String FILLED = "FILLED";
    public static final String USERCANCEL = "USERCANCEL";
    public static final String ERROR = "ERROR";

    public String execute(IDadoConta dados) throws ExcecaoNaoLocal {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        if (dados.getConta() != null) {
            return FILLED;
        }
        LayoutMenu layoutMenu = new LayoutMenu(inter.getMessage("LEITIPCON_TITLE"), true);
        layoutMenu.addItem(new ItemMenu(inter.getMessage("LEITIPCON_MENU_CONVENIO"), "1"));
        layoutMenu.addItem(new ItemMenu(inter.getMessage("LEITIPCON_MENU_TITULO"), "2"));
        ControladorPerifericos perifericos = dados.getPerifericos();
        if (layoutMenu.getItens().size() == 0) {
            dados.setConta(null);
            return ERROR;
        }
        int opcao = perifericos.imprimeMenu(layoutMenu);
        if (opcao == -1) {
            return USERCANCEL;
        }
        ItemMenu itemSelecionado = (ItemMenu)layoutMenu.getItens().get(opcao - 1);
        if (itemSelecionado.getTexto().equals(inter.getMessage("LEITIPCON_MENU_CONVENIO"))) {
            dados.setConta(new ContaConvenio());
            return SUCESS_CONVENIO;
        }
        if (itemSelecionado.getTexto().equals(inter.getMessage("LEITIPCON_MENU_TITULO"))) {
            dados.setConta(new ContaTitulo());
            return SUCESS_TITULO;
        }
        return ERROR;
    }
}

