/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.IDadoPlano;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.operacoes.model.PlanoAVista;
import com.csi.ctfclient.operacoes.model.PlanoAdministradora;
import com.csi.ctfclient.operacoes.model.PlanoFinanciadoLojista;
import com.csi.ctfclient.tools.devices.display.ItemMenu;
import com.csi.ctfclient.tools.devices.display.LayoutMenu;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import java.util.Vector;

public class MicLeituraTipoFinanciamentoCredito {
    public static final String SUCESS_AVISTA = "SUCESS_AVISTA";
    public static final String SUCESS_APRAZOLOJISTA = "SUCESS_APRAZOLOJISTA";
    public static final String SUCESS_APRAZOADMINISTRADO = "SUCESS_APRAZOADMINISTRADO";
    public static final String FILLED = "FILLED";
    public static final String USERCANCEL = "USERCANCEL";
    public static final String ERROR = "ERROR";

    public String execute(IDadoPlano dados) throws ExcecaoNaoLocal {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        boolean habilitadoAVista = dados.getSaidaApiTef().isPedePlanoAVista();
        boolean habilitadoFinanciadoLojista = dados.getSaidaApiTef().isPedePlanoLojista();
        boolean habilitadoAdministradora = dados.getSaidaApiTef().isPedePlanoAdministradora();
        if (dados.getTipoFinanciamento() != null) {
            return FILLED;
        }
        if (dados.getEntradaIntegracao() != null && dados.getEntradaIntegracao().getOperacao() != 223 && dados.getEntradaIntegracao().getOperacao() != 128 && dados.getEntradaIntegracao().getOperacao() != 404) {
            int operacao = dados.getEntradaIntegracao().getOperacao();
            if (operacao == 112 || operacao == 120 || operacao == 132 || operacao == 133) {
                if (habilitadoAVista) {
                    dados.setTipoFinanciamento(new PlanoAVista());
                    return SUCESS_AVISTA;
                }
            } else if (operacao == 113 || operacao == 121 || operacao == 167 || operacao == 169) {
                if (habilitadoFinanciadoLojista) {
                    dados.setTipoFinanciamento(new PlanoFinanciadoLojista());
                    return SUCESS_APRAZOLOJISTA;
                }
            } else if ((operacao == 114 || operacao == 122 || operacao == 168 || operacao == 170) && habilitadoAdministradora) {
                dados.setTipoFinanciamento(new PlanoAdministradora());
                return SUCESS_APRAZOADMINISTRADO;
            }
            if (dados.getTipoFinanciamento() == null) {
                dados.setErroIntegracao(new CodigoErroIntegracao(5306, inter.getMessage("LEITIPFIN_OPERATION_NOT_ALLOWED")));
                return ERROR;
            }
        } else {
            Vector<String> vtTitleMenu = new Vector<String>();
            if (habilitadoAVista) {
                vtTitleMenu.add(inter.getMessage("LEITIPFIN_MENU_AVISTA"));
            }
            if (habilitadoAdministradora) {
                vtTitleMenu.add(inter.getMessage("LEITIPFIN_MENU_ADMINISTRADORA"));
            }
            if (habilitadoFinanciadoLojista) {
                vtTitleMenu.add(inter.getMessage("LEITIPFIN_MENU_FINANCIADO_LOJISTA"));
            }
            ControladorPerifericos perifericos = dados.getPerifericos();
            if (vtTitleMenu.size() == 0) {
                dados.setTipoFinanciamento(null);
                return ERROR;
            }
            if (vtTitleMenu.size() == 1) {
                if (habilitadoAVista) {
                    dados.setTipoFinanciamento(new PlanoAVista());
                    return SUCESS_AVISTA;
                }
                if (habilitadoAdministradora) {
                    dados.setTipoFinanciamento(new PlanoAdministradora());
                    return SUCESS_APRAZOADMINISTRADO;
                }
                if (habilitadoFinanciadoLojista) {
                    dados.setTipoFinanciamento(new PlanoFinanciadoLojista());
                    return SUCESS_APRAZOLOJISTA;
                }
            } else {
                LayoutMenu layoutMenu = new LayoutMenu(inter.getMessage("LEITIPFIN_TITLE"), true);
                int iTecla = 1;
                for (int i = 0; i < vtTitleMenu.size(); ++i) {
                    layoutMenu.addItem(new ItemMenu((String)vtTitleMenu.get(i), String.valueOf(iTecla)));
                    ++iTecla;
                }
                int opcao = perifericos.imprimeMenu(layoutMenu);
                if (opcao == -1) {
                    return USERCANCEL;
                }
                ItemMenu itemSelecionado = (ItemMenu)layoutMenu.getItens().get(opcao - 1);
                if (itemSelecionado.getTexto().equals(inter.getMessage("LEITIPFIN_MENU_AVISTA"))) {
                    dados.setTipoFinanciamento(new PlanoAVista());
                    return SUCESS_AVISTA;
                }
                if (itemSelecionado.getTexto().equals(inter.getMessage("LEITIPFIN_MENU_FINANCIADO_LOJISTA"))) {
                    dados.setTipoFinanciamento(new PlanoFinanciadoLojista());
                    return SUCESS_APRAZOLOJISTA;
                }
                if (itemSelecionado.getTexto().equals(inter.getMessage("LEITIPFIN_MENU_ADMINISTRADORA"))) {
                    dados.setTipoFinanciamento(new PlanoAdministradora());
                    return SUCESS_APRAZOADMINISTRADO;
                }
            }
        }
        return ERROR;
    }
}

