/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.IDadoPlano;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.operacoes.model.PlanoPrivateLabelAVista;
import com.csi.ctfclient.operacoes.model.PlanoPrivateLabelPrazo;
import com.csi.ctfclient.tools.devices.display.ItemMenu;
import com.csi.ctfclient.tools.devices.display.LayoutMenu;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import java.util.Vector;

public class MicLeituraTipoFinanciamentoCreditoPrivateLabel {
    public static final String SUCESS_AVISTA = "SUCESS_AVISTA";
    public static final String SUCESS_APRAZOLOJISTA = "SUCESS_APRAZOLOJISTA";
    public static final String SUCESS_APRAZOADMINISTRADO = "SUCESS_APRAZOADMINISTRADO";
    public static final String FILLED_AVISTA = "FILLED_AVISTA";
    public static final String FILLED_APRAZOADMINISTRADO = "FILLED_APRAZOADMINISTRADO";
    public static final String TIPO_INVALIDO_AC = "TIPO_INVALIDO_AC";
    public static final String USERCANCEL = "USERCANCEL";
    public static final String ERROR = "ERROR";

    public String execute(IDadoPlano dados) throws ExcecaoNaoLocal {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        boolean habilitadoAVista = dados.getSaidaApiTef().isPedePlanoAVista();
        boolean habilitadoAdministradora = dados.getSaidaApiTef().isPedePlanoAdministradora();
        if (dados.getEntradaIntegracao() != null && dados.getEntradaIntegracao().isNumeroParcelasCtrl()) {
            int numeroParcelas = dados.getEntradaIntegracao().getNumeroParcelas();
            if (numeroParcelas == 1) {
                if (habilitadoAVista) {
                    dados.setTipoFinanciamento(new PlanoPrivateLabelAVista());
                    return SUCESS_AVISTA;
                }
            } else if (numeroParcelas > 1) {
                if (habilitadoAdministradora) {
                    PlanoPrivateLabelPrazo planoPrivateLabelPrazo = new PlanoPrivateLabelPrazo();
                    planoPrivateLabelPrazo.setNumeroParcela(numeroParcelas);
                    dados.setTipoFinanciamento(planoPrivateLabelPrazo);
                    return SUCESS_APRAZOADMINISTRADO;
                }
            } else {
                dados.setErroIntegracao(new CodigoErroIntegracao(5306, inter.getMessage("LEITIPFINCREPRILAB_OPERATION_NOT_ALLOWED")));
                return TIPO_INVALIDO_AC;
            }
        }
        Vector<String> vtTitleMenu = new Vector<String>();
        if (habilitadoAVista) {
            vtTitleMenu.add(inter.getMessage("LEITIPFINCREPRILAB_MENU_AVISTA"));
        }
        if (habilitadoAdministradora) {
            vtTitleMenu.add(inter.getMessage("LEITIPFINCREPRILAB_MENU_ADMINISTRADORA"));
        }
        ControladorPerifericos perifericos = dados.getPerifericos();
        if (vtTitleMenu.size() == 0) {
            dados.setTipoFinanciamento(null);
            return ERROR;
        }
        if (vtTitleMenu.size() == 1) {
            if (habilitadoAVista) {
                dados.setTipoFinanciamento(new PlanoPrivateLabelAVista());
                return SUCESS_AVISTA;
            }
            if (habilitadoAdministradora) {
                dados.setTipoFinanciamento(new PlanoPrivateLabelPrazo());
                return SUCESS_APRAZOADMINISTRADO;
            }
        } else {
            LayoutMenu layoutMenu = new LayoutMenu(inter.getMessage("LEITIPFINCREPRILAB_TITLE"), true);
            int iTecla = 1;
            for (int i = 0; i < vtTitleMenu.size(); ++i) {
                layoutMenu.addItem(new ItemMenu((String)vtTitleMenu.get(i), String.valueOf(iTecla)));
                ++iTecla;
            }
            int opcao = perifericos.imprimeMenu(layoutMenu);
            if (opcao == -1) {
                return USERCANCEL;
            }
            ItemMenu itemSelecionado = (ItemMenu)layoutMenu.getItens().get(opcao - 1);
            if (itemSelecionado.getTexto().equals(inter.getMessage("LEITIPFINCREPRILAB_MENU_AVISTA"))) {
                dados.setTipoFinanciamento(new PlanoPrivateLabelAVista());
                return SUCESS_AVISTA;
            }
            if (itemSelecionado.getTexto().equals(inter.getMessage("LEITIPFINCREPRILAB_MENU_ADMINISTRADORA"))) {
                dados.setTipoFinanciamento(new PlanoPrivateLabelPrazo());
                return SUCESS_APRAZOADMINISTRADO;
            }
        }
        return ERROR;
    }
}

