/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.IDadoPlano;
import com.csi.ctfclient.operacoes.model.PlanoAVista;
import com.csi.ctfclient.operacoes.model.PlanoCDC;
import com.csi.ctfclient.tools.devices.display.ItemMenu;
import com.csi.ctfclient.tools.devices.display.LayoutMenu;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import java.util.Vector;

public class MicLeituraTipoFinanciamentoPreAutorizacao {
    public static final String SUCESS_AVISTA = "SUCESS_AVISTA";
    public static final String SUCESS_APRAZO = "SUCESS_APRAZO";
    public static final String FILLED_AVISTA = "FILLED_AVISTA";
    public static final String FILLED_APRAZO = "FILLED_APRAZO";
    public static final String ERRO_FINANCIAMENTO_AC = "ERRO_FINANCIAMENTO_AC";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String ERROR = "ERROR";

    public String execute(IDadoPlano dados) throws ExcecaoNaoLocal {
        boolean habilitadoAPrazo;
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        boolean habilitadoAVista = dados.getSaidaApiTef().isPedePlanoAVista();
        boolean bl = habilitadoAPrazo = dados.getSaidaApiTef().getHabilitaCDC_PRE() == 1;
        if (dados.getEntradaIntegracao() != null && dados.getEntradaIntegracao().isMultiTerminal()) {
            if (dados.getEntradaIntegracao().getNumeroParcelas() == 1) {
                dados.setTipoFinanciamento(new PlanoAVista());
                return SUCESS_AVISTA;
            }
            dados.setTipoFinanciamento(new PlanoCDC());
            return SUCESS_APRAZO;
        }
        if (dados.getTipoFinanciamento() != null) {
            if (dados.getTipoFinanciamento() instanceof PlanoAVista) {
                return FILLED_AVISTA;
            }
            if (dados.getTipoFinanciamento() instanceof PlanoCDC) {
                return FILLED_APRAZO;
            }
            return ERRO_FINANCIAMENTO_AC;
        }
        Vector<String> vtTitleMenu = new Vector<String>();
        if (habilitadoAVista) {
            vtTitleMenu.add(inter.getMessage("LEITIPFINPREAUT_MENU_AVISTA"));
        }
        if (habilitadoAPrazo) {
            vtTitleMenu.add(inter.getMessage("LEITIPFINPREAUT_MENU_APRAZO"));
        }
        ControladorPerifericos perifericos = dados.getPerifericos();
        if (vtTitleMenu.size() == 0) {
            dados.setTipoFinanciamento(null);
            return ERROR;
        }
        if (vtTitleMenu.size() == 1) {
            if (habilitadoAVista) {
                dados.setTipoFinanciamento(new PlanoAVista());
                return SUCESS_AVISTA;
            }
            if (habilitadoAPrazo) {
                dados.setTipoFinanciamento(new PlanoCDC());
                return SUCESS_APRAZO;
            }
        } else {
            LayoutMenu layoutMenu = new LayoutMenu(inter.getMessage("LEITIPFINPREAUT_TITLE"), true);
            int iTecla = 1;
            for (int i = 0; i < vtTitleMenu.size(); ++i) {
                layoutMenu.addItem(new ItemMenu((String)vtTitleMenu.get(i), String.valueOf(iTecla)));
                ++iTecla;
            }
            int opcao = perifericos.imprimeMenu(layoutMenu);
            if (opcao == -1) {
                return USER_CANCEL;
            }
            ItemMenu itemSelecionado = (ItemMenu)layoutMenu.getItens().get(opcao - 1);
            if (itemSelecionado.getTexto().equals(inter.getMessage("LEITIPFINPREAUT_MENU_AVISTA"))) {
                dados.setTipoFinanciamento(new PlanoAVista());
                return SUCESS_AVISTA;
            }
            if (itemSelecionado.getTexto().equals(inter.getMessage("LEITIPFINPREAUT_MENU_APRAZO"))) {
                dados.setTipoFinanciamento(new PlanoCDC());
                return SUCESS_APRAZO;
            }
        }
        return ERROR;
    }
}

