/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.IValorTransacaoMutable;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class MicLeituraValor {
    public static final String SUCESS = "SUCESS";
    public static final String FILLED = "FILLED";
    public static final String INVALID_NUMBER = "INVALID_NUMBER";
    public static final String USERCANCEL = "USERCANCEL";
    public static final String ERROR_AC = "ERROR_AC";
    private static Logger logger = CTFClientLogger.getCTFClient();

    public String execute(IValorTransacaoMutable dados) throws ExcecaoNaoLocal {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        if (dados.getValorTransacao() != null) {
            return FILLED;
        }
        if (dados.getEntradaIntegracao() != null) {
            if (!dados.getEntradaIntegracao().isValorTransacaoCtrl() && this.valorObrigatorio(dados.getEntradaIntegracao().getOperacao())) {
                dados.setErroIntegracao(new CodigoErroIntegracao(5300, "VALOR NAO INFORMADO"));
                return ERROR_AC;
            }
            if (dados.getEntradaIntegracao().isValorTransacaoCtrl()) {
                dados.setValorTransacao(dados.getEntradaIntegracao().getValorTransacao());
                return SUCESS;
            }
        }
        ControladorPerifericos perifericos = dados.getPerifericos();
        LayoutDisplay displayModel = new LayoutDisplay();
        displayModel.addLinha(new Linha(inter.getMessage("LEIVAL_TITLE")));
        EventoTeclado eventoTeclado = (EventoTeclado)perifericos.capturaDado(displayModel, ConstantesApiAc.CAP_VALOR_TRANSACAO, true, 3, false);
        if ("VOLTA".equals(eventoTeclado.getTeclaFinalizadora())) {
            return USERCANCEL;
        }
        int num = eventoTeclado.getStringLida().length() - eventoTeclado.getNumCaracteresDigitados();
        String digitos = eventoTeclado.getStringLida().substring(num);
        if (digitos.equals("")) {
            return INVALID_NUMBER;
        }
        BigDecimal valor = new BigDecimal(digitos);
        if (valor.equals(new BigDecimal(0))) {
            return INVALID_NUMBER;
        }
        valor = valor.movePointLeft(2);
        dados.setValorTransacao(valor);
        return SUCESS;
    }

    private boolean valorObrigatorio(int operacao) {
        switch (operacao) {
            case 128: {
                return false;
            }
            case 156: {
                return false;
            }
            case 174: {
                return false;
            }
            case 236: {
                return false;
            }
            case 900: {
                return false;
            }
            case 265: {
                return false;
            }
            case 264: {
                return false;
            }
            case 266: {
                return false;
            }
            case 183: {
                return false;
            }
            case 286: {
                return false;
            }
            case 260: {
                return false;
            }
            case 289: {
                return false;
            }
            case 290: {
                return false;
            }
        }
        return true;
    }
}

