/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.IConvenioCombustivelShell;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.operacoes.model.controller.ProdutoConvenioCombustivel;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.devices.fusion.ControladorFusion;
import com.csi.ctfclient.tools.devices.fusion.ProdutoBombaCombustivel;
import com.csi.ctfclient.tools.devices.fusion.StatusFusion;
import com.csi.ctfclient.tools.util.CriptografiaUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class MicLiberaBombaCombustivel {
    public static String SUCCESS = "SUCCESS";
    public static String ERROR = "ERROR";

    public String execute(IConvenioCombustivelShell dados) throws ExcecaoNaoLocal {
        int quantidadeMaximaAbastecimentoFusion;
        Logger logger = CTFClientLogger.getCTFClient();
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ControladorPerifericos perifericos = dados.getPerifericos();
        LayoutDisplay displayModel = new LayoutDisplay(inter.getMessage("ENVIO1F_TITLE"));
        perifericos.imprimeDisplay(displayModel);
        SaidaApiTefC saida = dados.getSaidaApiTef();
        ControladorFusion fusion = ControladorFusion.getInstancia();
        if (saida.getTipoAbastecimento() == 2) {
            BigDecimal quantidadeMaximaAbastecimento = saida.getMaxLitrosAbastecimento();
            quantidadeMaximaAbastecimentoFusion = Integer.parseInt(quantidadeMaximaAbastecimento.movePointRight(2).intValue() + "0");
        } else if (saida.getTipoAbastecimento() == 1) {
            BigDecimal quantidadeMaximaAbastecimento = dados.getValorTransacao().movePointRight(dados.getBombaCombustivel().getCasasDecimais());
            quantidadeMaximaAbastecimentoFusion = dados.getValorTransacao().movePointRight(dados.getBombaCombustivel().getCasasDecimais()).intValue();
        } else {
            logger.log((Priority)Level.ERROR, (Object)("Tipo de abastecimento n\u00e3o suportado: " + saida.getTipoAbastecimento()));
            throw new IllegalArgumentException();
        }
        String hashCartao = CriptografiaUtil.gerarHash(dados.getCartao().getPAN(), "SHA-256");
        ProdutoConvenioCombustivel produtoConvenioCombustivel = null;
        StatusFusion statusFusion = null;
        try {
            ProdutoBombaCombustivel produtoFusion = new ProdutoBombaCombustivel(null);
            produtoConvenioCombustivel = (ProdutoConvenioCombustivel)dados.getListProdutoConvenioCombustivel().get(0);
            produtoFusion.setId(ControladorFusion.converteCodigoProdutoFusion(produtoConvenioCombustivel.getCodigo()));
            statusFusion = fusion.preset(produtoFusion, dados.getBombaCombustivel(), saida.getTipoAbastecimento(), quantidadeMaximaAbastecimentoFusion, hashCartao);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (statusFusion == null || statusFusion.getResultado() != 0) {
            if (statusFusion != null) {
                logger.log((Priority)Level.ERROR, (Object)("Erro ao tentar efetuar o preset, c\u00f3digo: " + statusFusion.getResultado()));
            }
            dados.setErroIntegracao(new CodigoErroIntegracao(5393, "ERRO CONEXAO FUSION"));
            return ERROR;
        }
        DecimalFormat formatValor = new DecimalFormat("#,##0.00");
        DecimalFormat formatLitros = new DecimalFormat("#,##0.00");
        displayModel = new LayoutDisplay();
        displayModel.addLinha(new Linha("BOMBA LIBERADA"));
        String displayQuantidade = "";
        if (saida.getTipoAbastecimento() == 2) {
            displayQuantidade = formatLitros.format(saida.getMaxLitrosAbastecimento()) + " L";
        } else if (saida.getTipoAbastecimento() == 1) {
            displayQuantidade = "R$ " + formatValor.format(saida.getValorTransacao().doubleValue());
        }
        displayModel.addLinha(new Linha("BOMBA " + dados.getBombaCombustivel().getId() + " - " + displayQuantidade));
        displayModel.addLinha(new Linha("PRODUTO " + produtoConvenioCombustivel.getCodigo() + " - " + produtoConvenioCombustivel.getDescricao()));
        perifericos.confirmaDado(displayModel);
        return SUCCESS;
    }

    public static void main(String[] args) {
        System.out.println(CriptografiaUtil.gerarHash("4", "SHA-256"));
        System.out.println(CriptografiaUtil.gerarHash("Z", "SHA-256"));
        System.out.println(CriptografiaUtil.gerarHash("4551820000009486", "SHA-256"));
        System.out.println(CriptografiaUtil.gerarHash("4551820000009486", "SHA-256"));
        System.out.println(CriptografiaUtil.gerarHash("1234567890123456789", "SHA-256"));
        System.out.println(CriptografiaUtil.gerarHash("1234567890123456789", "SHA-256"));
    }
}

