/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.IEntradaApiTef;
import com.csi.ctfclient.operacoes.entrada.IPOSTef;
import com.csi.ctfclient.operacoes.entrada.ISaidaApiTef;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.servicos.IdentTerminal;
import com.csi.ctfclient.tools.devices.EventoDispositivoEntrada;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.PerifericoEntradaDadosListener;
import com.csi.ctfclient.tools.devices.display.ItemMenu;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.LayoutMenu;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.devices.postef.EventoPOSTef;
import com.csi.ctfclient.tools.devices.postef.PosTEF;
import com.csi.ctfclient.tools.devices.postef.Protocolo;
import com.csi.ctfclient.tools.devices.postef.ProtocoloBuilder;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import java.io.File;
import java.io.FileWriter;
import java.text.SimpleDateFormat;
import org.apache.log4j.Logger;

public class MicPOSTef {
    public static final String SUCCESS = "SUCCESS";
    public static final String ERROR = "ERROR";
    public static final String POSTEF_LOCAL = "POSTEF_LOCAL";
    public static final String POSTEF_REMOTO = "POSTEF_REMOTO";
    public static final String USER_CANCEL = "USER_CANCEL";
    private Logger logger = CTFClientLogger.getCTFClient();

    public String execute(IPOSTef dados) throws Exception {
        ConfCTFClient conf = ControladorConfCTFClient.getInstance().getConfig();
        boolean posTEF = conf.getConfPOSTef() != null && conf.getConfPOSTef().isHabilitado();
        EntradaCTFClientCtrl entrada = dados.getEntradaIntegracao();
        if (posTEF && entrada != null && entrada.getOperacao() == 902) {
            InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
            ControladorPerifericos perifericos = dados.getPerifericos();
            LayoutMenu layoutMenu = new LayoutMenu(inter.getMessage("CAPPOSTES_TITLE"), true);
            layoutMenu.addItem(new ItemMenu(inter.getMessage("CAPPOSTES_REMOTO"), "1"));
            layoutMenu.addItem(new ItemMenu(inter.getMessage("CAPPOSTES_LOCAL"), "2"));
            int opcao = perifericos.imprimeMenu(layoutMenu);
            if (opcao == -1) {
                return USER_CANCEL;
            }
            switch (opcao) {
                case 1: {
                    dados.setModoVendaRemota(true);
                    return this.processaTrasacaoRemota(dados);
                }
                case 2: {
                    return POSTEF_LOCAL;
                }
            }
        }
        return SUCCESS;
    }

    private String processaTrasacaoRemota(IPOSTef dados) throws ExcecaoApiAc {
        ControladorPerifericos perifericos = dados.getPerifericos();
        LayoutDisplay layoutDisplay = new LayoutDisplay();
        layoutDisplay.addLinha(new Linha("AGUARDE..."));
        perifericos.imprimeDisplay(layoutDisplay);
        EntradaCTFClientCtrl entradaCTFClient = dados.getEntradaIntegracao();
        SimpleDateFormat formatoData = new SimpleDateFormat("yyyyMMdd");
        String dataAbertura = formatoData.format(entradaCTFClient.getDataAbertura());
        ProtocoloBuilder protocoloBuilder = new ProtocoloBuilder("0100", entradaCTFClient.getOperacao()).setSubCampo("7000", "00").setSubCampo("7802", dataAbertura);
        if (entradaCTFClient.isValorTransacaoCtrl()) {
            protocoloBuilder.setSubCampo("7005", StringUtil.sprintf("%012d", new Object[]{entradaCTFClient.getValorTransacao().movePointRight(2)}));
        }
        if (entradaCTFClient.isNumeroParcelasCtrl()) {
            protocoloBuilder.setSubCampo("7008", StringUtil.sprintf("%02d", new Object[]{new Integer(entradaCTFClient.getNumeroParcelas())}));
        }
        if (entradaCTFClient.isDocumentoCtrl()) {
            protocoloBuilder.setSubCampo("7020", entradaCTFClient.getDocumento());
        }
        PerifericoEntradaDadosListener listener = new PerifericoEntradaDadosListener(){

            public void eventoOcorrido(EventoDispositivoEntrada evt) {
                System.out.println("evento: " + evt);
            }
        };
        perifericos.getEntradaDeDados().addEventoGenericoListener(listener);
        PosTEF.getInstance().executa(protocoloBuilder, dados.getPerifericos().getEntradaDeDados());
        try {
            EventoDispositivoEntrada evt = dados.getPerifericos().leDadosPOSTef();
            if (evt instanceof EventoTeclado) {
                EventoTeclado eventoTeclado = (EventoTeclado)evt;
                if (eventoTeclado.getTeclaFinalizadora().equals("VOLTA")) {
                    PosTEF.getInstance().reset();
                    return USER_CANCEL;
                }
            } else if (evt instanceof EventoPOSTef) {
                EventoPOSTef eventoPOSTef = (EventoPOSTef)evt;
                this.preparaRepostaPOSTefRemoto((Protocolo)eventoPOSTef.getInfo(), dados);
            }
        }
        catch (ExcecaoNaoLocal e) {
            this.logger.error((Object)"erro no processamento do evento", (Throwable)e);
            return ERROR;
        }
        perifericos.getEntradaDeDados().removeEventoGenericoListener(listener);
        return POSTEF_REMOTO;
    }

    private void preparaRepostaPOSTefRemoto(Protocolo protocolo, IPOSTef dados) {
        EntradaApiTefC entradaApiTefC = new EntradaApiTefC();
        entradaApiTefC.setNumeroTransacao(1);
        entradaApiTefC.setTimeoutCtf(15);
        SaidaApiTefC saidaApiTefC = new SaidaApiTefC();
        String dataAutorizadora = null;
        String horaAutorizadora = null;
        saidaApiTefC.setRetorno(protocolo.getCodigoRetorno());
        if (protocolo.getCodigoTransacaoCTF() != null) {
            entradaApiTefC.setOperacao(protocolo.getCodigoTransacaoCTF());
        }
        if (protocolo.getValorTransacao() != null) {
            entradaApiTefC.setValorTransacao(protocolo.getValorTransacao());
            saidaApiTefC.setValorTransacao(protocolo.getValorTransacao());
        }
        protocolo.getNumeroParcelas();
        dados.setCodigoAutorizadora(protocolo.getCodigoAutorizadora());
        if (protocolo.getCodigoRespAutorizadora() != null) {
            saidaApiTefC.setCodigoRespostaAutorizadora(protocolo.getCodigoRespAutorizadora());
        }
        protocolo.getDocumento();
        saidaApiTefC.setNsuCTF(protocolo.getNsuCTF());
        saidaApiTefC.setTaxaServico(protocolo.getTaxaServico());
        saidaApiTefC.setNsuAutorizacao(protocolo.getNsuAutorizadora());
        saidaApiTefC.setCodigoAprovacao(protocolo.getCodigoAprovacao());
        if (protocolo.getMac() != null) {
            saidaApiTefC.setMac(Integer.parseInt(protocolo.getMac()));
        }
        entradaApiTefC.setCnpj(protocolo.getCnpj());
        if (protocolo.getCodigoErro() != null) {
            saidaApiTefC.setCodigoErro(Integer.parseInt(protocolo.getCodigoErro()));
        }
        protocolo.getDescricaoTransacao();
        if (protocolo.getCupomCliente() != null) {
            this.preparaCupom(protocolo.getCupomCliente(), "CUPOMCTF.1", entradaApiTefC.getNumeroTransacao());
        }
        if (protocolo.getCupomEstabelecimento() != null) {
            this.preparaCupom(protocolo.getCupomEstabelecimento(), "CUPOMCTF.2", entradaApiTefC.getNumeroTransacao());
        }
        if (protocolo.getCupomClienteReimpressao() != null) {
            this.preparaCupom(protocolo.getCupomClienteReimpressao(), "CUPOMCTF.5", entradaApiTefC.getNumeroTransacao());
        }
        if (protocolo.getCupomEstabelecimentoReimpressao() != null) {
            this.preparaCupom(protocolo.getCupomEstabelecimentoReimpressao(), "CUPOMCTF.6", entradaApiTefC.getNumeroTransacao());
        }
        dados.setNomeAutorizadora(protocolo.getNomeAutorizadora());
        if (protocolo.getCodigoVan() != null) {
            dados.setCodigoVan(Integer.parseInt(protocolo.getCodigoVan()));
        }
        dados.setNomeVan(protocolo.getNomeVan());
        if (protocolo.getCodigoInstFinanceira() != null && protocolo.getCodigoInstFinanceira().trim().length() > 0) {
            dados.setCodigoInstituicaoFinanceira(Integer.parseInt(protocolo.getCodigoInstFinanceira()));
        }
        if (protocolo.getNomeInstFinanceira() != null) {
            saidaApiTefC.setNomeInstituicaoFinanceira(protocolo.getNomeInstFinanceira());
            dados.setNomeInstituicaoFinanceira(protocolo.getNomeInstFinanceira());
        }
        dataAutorizadora = protocolo.getDataTransacao();
        horaAutorizadora = protocolo.getHoraTransacao();
        if (protocolo.getLogomarca() != null) {
            saidaApiTefC.setLogomarca(protocolo.getLogomarca());
        }
        if (protocolo.getCpf() != null) {
            entradaApiTefC.setCpf(protocolo.getCpf());
        }
        if (protocolo.getCupomReduzido() != null) {
            this.preparaCupom(protocolo.getCupomReduzido(), "REDUZIDO.1", entradaApiTefC.getNumeroTransacao());
        }
        saidaApiTefC.setDisplayCTF(protocolo.getDisplay());
        saidaApiTefC.setNomeBandeiraProduto(protocolo.getNomeBandeira());
        saidaApiTefC.setNomeRedeAdquirente(protocolo.getNomeRedeAdquirente());
        if (dataAutorizadora != null && horaAutorizadora != null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("ddMMYYYY");
            try {
                saidaApiTefC.setDataAutorizadora(dateFormat.parse(dataAutorizadora + horaAutorizadora));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (dados.getProcessMenu() != null) {
            if (dados.getProcessMenu() instanceof ISaidaApiTef) {
                ((ISaidaApiTef)((Object)dados.getProcessMenu())).setSaidaApiTef(saidaApiTefC);
            }
            if (dados.getProcessMenu() instanceof IEntradaApiTef) {
                ((IEntradaApiTef)((Object)dados.getProcessMenu())).setEntradaApiTef(entradaApiTefC);
            }
        }
        dados.setTerminalOriginal(protocolo.getCodigoTerminal());
        dados.setModoIntegracaoPOSTef(protocolo.getModeloIntegracao());
        dados.setEntradaApiTef(entradaApiTefC);
        dados.setSaidaApiTef(saidaApiTefC);
    }

    private void preparaCupom(String cupom, String nome, int numTrans) {
        if (cupom == null) {
            return;
        }
        try {
            ControladorConfCTFClient controladorConf = ControladorConfCTFClient.getInstance();
            ConfCTFClient confCTFClient = controladorConf.getConfig();
            IdentTerminal identTerminal = new IdentTerminal(confCTFClient.getEstabelecimento(), confCTFClient.getLoja(), confCTFClient.getTerminal());
            int idxEmpresa = confCTFClient.getVersaoPathTerminal() == 1 ? 0 : 1;
            String path = identTerminal.getEstabelecimento().substring(idxEmpresa) + identTerminal.getLoja() + "." + identTerminal.getTerminal() + "/";
            if (ControladorConfCTFClient.getDiretorioTrabalho() != null) {
                path = ControladorConfCTFClient.getDiretorioTrabalho() + path;
            }
            cupom = cupom.replace('\\', '&');
            String[] linhas = cupom.split("&");
            cupom = path + nome + StringUtil.completaString(numTrans + "", 2, '0', 3);
            File fileCupom = new File(cupom);
            FileWriter fileWriter = new FileWriter(fileCupom);
            for (int i = 0; i < linhas.length; ++i) {
                fileWriter.write(linhas[i] + "\n");
            }
            fileWriter.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

