/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.IConvenioCombustivelShell;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.operacoes.model.controller.ProdutoConvenioCombustivel;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.fusion.ControladorFusion;
import com.csi.ctfclient.tools.devices.fusion.StatusPresetFusion;
import com.csi.ctfclient.tools.util.CriptografiaUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import java.util.ArrayList;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class MicRecuperarInformacoesAbastecimento {
    public static final String SUCCESS = "SUCCESS";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String ERROR = "ERROR";
    private Logger logger = CTFClientLogger.getCTFClient();

    public String execute(IConvenioCombustivelShell dados) throws ExcecaoNaoLocal {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ControladorPerifericos perifericos = dados.getPerifericos();
        LayoutDisplay displayModel = new LayoutDisplay(inter.getMessage("ENVIO1F_TITLE"));
        perifericos.imprimeDisplay(displayModel);
        ControladorFusion fusion = ControladorFusion.getInstancia();
        String hashCartao = CriptografiaUtil.gerarHash(dados.getCartao().getPAN(), "SHA-256");
        StatusPresetFusion statusPreset = null;
        try {
            statusPreset = fusion.statusPreset(hashCartao);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (statusPreset == null || statusPreset.getResultado() != 0) {
            if (statusPreset != null) {
                this.logger.log((Priority)Level.ERROR, (Object)("Erro ao tentar recuperar as informa\u00e7\u00f5es do abastecimento, c\u00f3digo: " + statusPreset.getResultado()));
            }
            dados.setErroIntegracao(new CodigoErroIntegracao(5393, "ERRO CONEXAO FUSION"));
            return ERROR;
        }
        String mensagemErro = inter.getMessage("RECINFABA_ERROR_DEFAULT");
        switch (statusPreset.getStatusPreset()) {
            case 1: {
                this.logger.log((Priority)Level.ERROR, (Object)"Abastecimento ainda n\u00e3o realizado");
                mensagemErro = inter.getMessage("RECINFABA_ERROR_AUTORIZADO");
                break;
            }
            case 2: {
                this.logger.log((Priority)Level.ERROR, (Object)"Autoriza\u00e7\u00e3o em abastecimento");
                mensagemErro = inter.getMessage("RECINFABA_ERROR_ABASTECENDO");
                break;
            }
            case 3: {
                this.logger.log((Priority)Level.ERROR, (Object)"Bomba bloqueada");
                mensagemErro = inter.getMessage("RECINFABA_ERROR_BLOQUEADO");
                break;
            }
            case 4: {
                ProdutoConvenioCombustivel produto = new ProdutoConvenioCombustivel();
                produto.setCodigo(statusPreset.getCodigoProduto());
                ArrayList listProdutoConvenioCombustivel = new ArrayList();
                dados.setListProdutoConvenioCombustivel(listProdutoConvenioCombustivel);
                dados.setLitros(statusPreset.getVolumeFinal());
                dados.setPrecoUnitarioLitroCombustivel(statusPreset.getPrecoUnitario());
                dados.setHashCartao(hashCartao);
                dados.setCodigoAutorizacaoFusion(statusPreset.getCodigoAutorizacaoFusion());
                return SUCCESS;
            }
            default: {
                this.logger.log((Priority)Level.ERROR, (Object)("Retorno do status do preset n\u00e3o esperado: [" + statusPreset.getStatusPreset() + "]"));
            }
        }
        displayModel = new LayoutDisplay(mensagemErro);
        perifericos.confirmaDado(displayModel);
        return USER_CANCEL;
    }
}

