/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.IdentApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.IDadosBypass;
import com.csi.ctfclient.operacoes.model.AbstractCartao;
import com.csi.ctfclient.operacoes.model.Cartao;
import com.csi.ctfclient.operacoes.model.CartaoChip;
import com.csi.ctfclient.operacoes.model.CartaoDigitado;
import com.csi.ctfclient.operacoes.model.CartaoMagnetico;
import com.csi.ctfclient.operacoes.model.PlanoAPrazo;
import com.csi.ctfclient.operacoes.model.PlanoAVista;
import com.csi.ctfclient.operacoes.model.PlanoCDC;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.devices.emv.SaidaGetInfoEMV;
import com.csi.ctfclient.tools.util.VerifyContentUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import java.util.Date;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class MicSolicitacaoBypass {
    public static final String SUCESS = "SUCESS";
    public static final String ERROR = "ERROR";
    private Logger logger = CTFClientLogger.getCTFClient();

    public String execute(IDadosBypass dados) throws ExcecaoApiAc {
        Cartao cartao;
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ControladorPerifericos periferico = dados.getPerifericos();
        boolean connectedPin = false;
        EntradaApiTefC entrada = new EntradaApiTefC();
        ConfCTFClient conf = ControladorConfCTFClient.getInstance().getConfig();
        IdentApiTefC ident = new IdentApiTefC();
        ident.setNumeroEstabelecimento(conf.getEstabelecimento());
        ident.setNumeroLoja(conf.getLoja());
        ident.setNumeroPdv(conf.getTerminal());
        ident.setNumeroSites(String.valueOf(conf.getNumeroSites()));
        ident.setListaIP(conf.getIps());
        ident.setQuantidadeVias(conf.getQuantidadeVias());
        entrada.setOperacao(this.getCodigoTransacao(dados));
        entrada.setNumeroTransacao(dados.getNumeroTransacao());
        connectedPin = periferico.getPin() != null;
        LayoutDisplay displayModel = new LayoutDisplay();
        displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO1")));
        displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO2")));
        displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO3")));
        periferico.imprimeDisplay(displayModel);
        if (dados.getEntradaIntegracao() != null) {
            entrada.setDataCliente(dados.getEntradaIntegracao().getDataAbertura());
            if (dados.getEntradaIntegracao().isInfoAdicionaisCtrl()) {
                entrada.setAdicionais(dados.getEntradaIntegracao().getInfoAdicionais());
            }
            if (dados.getEntradaIntegracao().isTipoGarantiaCtrl()) {
                entrada.setTipoGarantia(dados.getEntradaIntegracao().getTipoGarantia());
            }
        } else {
            entrada.setDataCliente(dados.getStartProcess());
        }
        if (connectedPin) {
            if (periferico.getPin().isBibliotecaEMV()) {
                SaidaGetInfoEMV getInfo = periferico.getPin().getInfo();
                if (getInfo != null) {
                    entrada.setNumeroSeriePin(getInfo.getNumSeriePinpad());
                    entrada.setRetornoGetInfo(getInfo.getRetorno());
                }
                entrada.setTipoPin("16");
            } else {
                entrada.setTipoPin("14");
            }
        } else {
            entrada.setTipoPin("**");
        }
        int timeout = dados.getSaidaApiTefConsultaCartao() != null ? dados.getSaidaApiTefConsultaCartao().getTimeOutCTF() : 28;
        if (dados.getInfo() != null) {
            entrada.setInfo(dados.getInfo());
        }
        entrada.setTimeoutCtf(timeout);
        entrada.setTimestamp(new Date());
        entrada.setValorTransacao(dados.getValorTransacao());
        if (dados.getValorDesconto() != null) {
            entrada.setValorDesconto(dados.getValorDesconto());
        }
        if (dados.getValorAcrescimo() != null) {
            entrada.setValorAcrescimo(dados.getValorAcrescimo());
        }
        if ((cartao = dados.getCartao()) != null) {
            if (!(dados.getCartao() instanceof CartaoDigitado)) {
                AbstractCartao absCartao = (AbstractCartao)cartao;
                if (absCartao.getTrilha1Criptografado() != null) {
                    entrada.setTrilha1Criptografada(absCartao.getTrilha1Criptografado());
                }
                if (absCartao.getTrilha2Criptografado() != null) {
                    entrada.setTrilha2Criptografada(absCartao.getTrilha2Criptografado());
                }
            }
            entrada.setRetornoBibliotecaCompartilhada(dados.getLastErrorCode());
            if (cartao instanceof CartaoChip) {
                CartaoChip cartaoChip = (CartaoChip)cartao;
                entrada.setModoEntrada(5);
                entrada.setCodigoRedeAdquirenteChip(cartaoChip.getTipoRedeAdquirente());
                entrada.setIndiceAid(cartaoChip.getIndiceRegistroAID());
                entrada.setNumeroAplicacao(cartaoChip.getNumero());
                entrada.setTipoCartao(cartaoChip.getTipoCartao());
                entrada.setIssuerCountryCode(cartaoChip.getIssuerCountry());
                entrada.setInfo(cartaoChip.getTrilha2().trim());
                entrada.setNomeCliente(cartaoChip.getNomePortador());
                entrada.setTipoAplicacaoChip(cartaoChip.getTipoAplicacao());
                entrada.setStatusChip(cartaoChip.getStatusUltimaLeitura());
                entrada.setCardSequenceNumber(cartaoChip.getPanSequenceNumber());
                entrada.setWFlags(cartaoChip.getFlags());
                entrada.setApplicationExpirationDate(cartaoChip.getApplicationExpirationDate());
            } else if (cartao instanceof CartaoMagnetico) {
                CartaoMagnetico cartaoMagnetico = (CartaoMagnetico)dados.getCartao();
                entrada.setModoEntrada(2);
                entrada.setTipoAplicacaoChip(cartaoMagnetico.getTipoAplicacao());
                entrada.setTipoCartao(cartaoMagnetico.getTipoCartao());
                entrada.setInfo(cartaoMagnetico.getTrilha2().trim());
                entrada.setTrilha1(cartaoMagnetico.getTrilha1().trim());
                entrada.setStatusChip(cartaoMagnetico.getStatusUltimaLeitura());
                entrada.setIssuerCountryCode(cartaoMagnetico.getIssuerCountry());
                entrada.setNomeCliente(cartaoMagnetico.getNomePortador());
                entrada.setWFlags(cartaoMagnetico.getFlags());
            } else if (cartao instanceof CartaoDigitado) {
                CartaoDigitado cartaoDigitado = (CartaoDigitado)cartao;
                entrada.setModoEntrada(1);
                entrada.setInfo(cartaoDigitado.getNumero());
                entrada.setFallbackDigitado(cartaoDigitado.isFallback());
                if (cartaoDigitado.getVencimento() != null) {
                    entrada.setDataVencimento(cartaoDigitado.getDateVencimento());
                }
                if (cartaoDigitado.getNumeroCriptografado() != null) {
                    entrada.setCartaoCriptografado(cartaoDigitado.getNumeroCriptografado());
                }
            }
        } else if (dados.getEntradaIntegracao().isModoEntradaCartaoCtrl()) {
            entrada.setModoEntrada(dados.getEntradaIntegracao().getModoEntradaCartao());
        }
        if (dados.getTipoFinanciamento() instanceof PlanoCDC) {
            PlanoCDC planoCDC = (PlanoCDC)dados.getTipoFinanciamento();
            entrada.setNumeroParcelas(planoCDC.getNumeroParcela());
            if (planoCDC.getValorEntrada() != null) {
                entrada.setValorEntrada(planoCDC.getValorEntrada());
            }
        } else if (dados.getTipoFinanciamento() instanceof PlanoAPrazo) {
            PlanoAPrazo prazo = (PlanoAPrazo)dados.getTipoFinanciamento();
            entrada.setNumeroParcelas(prazo.getNumeroParcela());
        } else if (dados.getTipoFinanciamento() instanceof PlanoAVista) {
            entrada.setNumeroParcelas(1);
            entrada.setValorCashBack(((PlanoAVista)dados.getTipoFinanciamento()).getValorSaque());
        } else {
            entrada.setNumeroParcelas(0);
        }
        if (dados.getCodigoSeguranca() != null) {
            if (dados.getCodigoSeguranca().getCodigo().length() == 0) {
                if (dados.getCodigoSeguranca().getMotivo() == 0) {
                    entrada.setMotivoCVV2('2');
                } else {
                    entrada.setMotivoCVV2('9');
                }
            } else {
                entrada.setCvv2(dados.getCodigoSeguranca().getCodigo());
            }
        }
        if (dados.getTaxaEmbarque() != null) {
            entrada.setValorTaxaEmbarque(dados.getTaxaEmbarque().getValorEmbarque());
        }
        if (dados.getSaidaApiTefConsultaCartao() != null) {
            entrada.setIndiceMasterKey(dados.getSaidaApiTefConsultaCartao().getIndiceMasterKey());
        }
        if (dados.getNsuTransacao() != 0) {
            entrada.setNsuCtfTransacaoOriginal(dados.getNsuTransacao());
        }
        if (dados.getEntradaIntegracao().isCodigoAutorizadoraCtrl()) {
            entrada.setCodigoAutorizadora(dados.getEntradaIntegracao().getCodigoAutorizadora());
            entrada.setInfo(this.trataCodigoOperadoraInfo(entrada.getInfo(), dados.getEntradaIntegracao().getCodigoAutorizadora()));
        }
        entrada.setNumeroCupom(dados.getNumeroCupom());
        SaidaApiTefC saidaApiTefC = dados.getApitef().solicitacao(ident, entrada);
        dados.setEntradaApiTef(entrada);
        dados.setSaidaApiTef(saidaApiTefC);
        if (dados.getSaidaApiTef().getRetorno() == 0) {
            VerifyContentUtil.preencheDadosSaida(dados, saidaApiTefC);
            return SUCESS;
        }
        this.logger.log((Priority)Level.INFO, (Object)("Resposta autorizadora: " + saidaApiTefC.getCodigoRespostaAutorizadora()));
        return ERROR;
    }

    protected String getCodigoTransacao(IDadosBypass dados) {
        EntradaCTFClientCtrl entradaIntegracao = dados.getEntradaIntegracao();
        if (entradaIntegracao != null && entradaIntegracao.isCodigoTransacaoCtrl()) {
            return entradaIntegracao.getCodigoTransacao();
        }
        throw new IllegalStateException("Codigo transa\u00e7\u00e3o n\u00e3o encontrada!");
    }

    private String trataCodigoOperadoraInfo(String info, String codigoAutorizadora) {
        if (info == null) {
            info = "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = info.length(); i < 68; ++i) {
            sb.append("0");
        }
        if (codigoAutorizadora.length() == 1) {
            codigoAutorizadora = codigoAutorizadora + " ";
        }
        return info + sb.toString() + codigoAutorizadora;
    }
}

