/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.IdentApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorBaixaTecnica;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.IDadosCancelamento;
import com.csi.ctfclient.operacoes.entrada.ITipoOperacao;
import com.csi.ctfclient.operacoes.model.AbstractCartao;
import com.csi.ctfclient.operacoes.model.Cartao;
import com.csi.ctfclient.operacoes.model.CartaoChip;
import com.csi.ctfclient.operacoes.model.CartaoDigitado;
import com.csi.ctfclient.operacoes.model.CartaoMagnetico;
import com.csi.ctfclient.operacoes.model.DadosSolicitacaoCreditoDigital;
import com.csi.ctfclient.operacoes.model.GetInfo;
import com.csi.ctfclient.operacoes.model.PinInfo;
import com.csi.ctfclient.operacoes.model.PlanoAPrazo;
import com.csi.ctfclient.operacoes.model.PlanoAVista;
import com.csi.ctfclient.operacoes.model.PlanoAdministradora;
import com.csi.ctfclient.operacoes.model.PlanoCDC;
import com.csi.ctfclient.operacoes.model.PlanoFinanciadoLojista;
import com.csi.ctfclient.operacoes.model.PlanoParcelado;
import com.csi.ctfclient.operacoes.model.PlanoPreDatado;
import com.csi.ctfclient.operacoes.model.Produto;
import com.csi.ctfclient.operacoes.model.TabelaCriptografia;
import com.csi.ctfclient.servicos.IdentTerminal;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.devices.emvfull.ProtocoloBibliotecaCompartilhada;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.TransacoesGenericas;
import com.csi.ctfclient.tools.util.VerifyContentUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import java.text.SimpleDateFormat;
import java.util.Date;

public class MicSolicitacaoCancelamento {
    public static final String SUCESS = "SUCESS";
    public static final String ERROR = "ERROR";
    public static final String TRANSACAO_NAO_LOCALIZADA = "TRANSACAO_NAO_LOCALIZADA";
    private static final String MSG_OPERATION_NOT_ALLOWED = "OPERACAO NAO PERMITIDA";
    public static final String OPERACAO = "31";
    public static final String OPERACAO_SEM_LOG = "2W";

    public String execute(IDadosCancelamento dados) throws ExcecaoNaoLocal, ExcecaoApiAc {
        boolean delivery;
        EntradaApiTefC entrada = dados.getEntradaApiTef();
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ConfCTFClient conf = ControladorConfCTFClient.getInstance().getConfig();
        if (dados.isTransacaoSemLog()) {
            entrada.setOperacao(OPERACAO_SEM_LOG);
            entrada.setCodigoAutorizacao(dados.getNsuAutorizacao());
            String c = this.getCodigoTransacaoSemLog(dados);
            entrada.setCodigoTransacao(c);
            if (dados.getTipoFinanciamento() != null) {
                PlanoPreDatado planoPreDatado;
                String bit62Formatado;
                String valorFormatado;
                String dataFormatada;
                if (dados.getTipoFinanciamento() instanceof PlanoAPrazo) {
                    PlanoAPrazo planoAPrazo = (PlanoAPrazo)dados.getTipoFinanciamento();
                    entrada.setNumeroParcelas(planoAPrazo.getNumeroParcela());
                }
                if (dados.getTipoFinanciamento() instanceof PlanoCDC) {
                    PlanoCDC planoCDC = (PlanoCDC)dados.getTipoFinanciamento();
                    if (planoCDC.getData1parcela() != null) {
                        entrada.setDataVencimento(planoCDC.getData1parcela());
                    }
                } else if (dados.getTipoFinanciamento() instanceof PlanoParcelado) {
                    PlanoParcelado planoParcelado = (PlanoParcelado)dados.getTipoFinanciamento();
                    if (planoParcelado.getData1parcela() != null) {
                        entrada.setDataVencimento(planoParcelado.getData1parcela());
                        dataFormatada = new SimpleDateFormat("yyyyMMdd").format(planoParcelado.getData1parcela());
                        valorFormatado = dados.getValorTransacao().movePointRight(2).toString();
                        bit62Formatado = StringUtil.completaString(valorFormatado + dataFormatada, 20, '0', 3);
                        entrada.setAdicionais(bit62Formatado);
                    }
                } else if (dados.getTipoFinanciamento() instanceof PlanoPreDatado && (planoPreDatado = (PlanoPreDatado)dados.getTipoFinanciamento()).getDataAgendamento() != null) {
                    dataFormatada = new SimpleDateFormat("yyyyMMdd").format(planoPreDatado.getDataAgendamento());
                    valorFormatado = dados.getValorTransacao().movePointRight(2).toString();
                    bit62Formatado = StringUtil.completaString(valorFormatado + dataFormatada, 20, '0', 3);
                    entrada.setAdicionais(bit62Formatado);
                }
            }
        } else {
            String codigoOperacao = this.getCodigoOperacao(dados);
            entrada.setOperacao(codigoOperacao);
        }
        if (dados.getValorCancelamento() != null) {
            entrada.setValorCancelamento(dados.getValorCancelamento());
        }
        int modoEntrada = 1;
        if (dados.getProdutoDinamico() != null) {
            Produto produto = dados.getProdutoDinamico();
            entrada.setCodigoProduto(produto.getCodigo());
            entrada.setCodigoBandeira(produto.getCodigoBandeira());
            entrada.setFluxoTef(produto.getKeyFluxo());
        } else {
            entrada.setCodigoProduto(0);
        }
        entrada.setValorTransacao(dados.getValorTransacao());
        Cartao cartao = dados.getCartao();
        if (cartao != null) {
            if (dados.getSaidaApiTef().isCriptografiaCartao() && dados.getCartao() instanceof AbstractCartao) {
                AbstractCartao cartaoGenerico = (AbstractCartao)dados.getCartao();
                if (cartaoGenerico.getTrilha1Criptografado() != null) {
                    entrada.setTrilha1Criptografada(cartaoGenerico.getTrilha1Criptografado());
                }
                if (cartaoGenerico.getTrilha2Criptografado() != null) {
                    entrada.setTrilha2Criptografada(cartaoGenerico.getTrilha2Criptografado());
                }
            }
            entrada.setRetornoBibliotecaCompartilhada(dados.getLastErrorCode());
            if (cartao instanceof CartaoMagnetico) {
                modoEntrada = 2;
                CartaoMagnetico cartaoMagnetico = (CartaoMagnetico)cartao;
                if (cartaoMagnetico.getTrilha2() != null) {
                    entrada.setInfo(cartaoMagnetico.getTrilha2());
                }
                if (cartaoMagnetico.getTrilha1() != null) {
                    entrada.setTrilha1(cartaoMagnetico.getTrilha1());
                }
                entrada.setNomeCliente(cartaoMagnetico.getNomePortador());
                entrada.setStatusChip(cartaoMagnetico.getStatusUltimaLeitura());
                entrada.setTipoCartao(cartaoMagnetico.getTipoCartao());
                entrada.setIssuerCountryCode(cartaoMagnetico.getIssuerCountry());
                entrada.setPAN(cartaoMagnetico.getNumero());
                if (cartaoMagnetico.getNumeroCriptografado() != null) {
                    entrada.setCartaoCriptografado(cartaoMagnetico.getNumeroCriptografado());
                }
            } else if (cartao instanceof CartaoChip) {
                modoEntrada = 5;
                CartaoChip cartaoChip = (CartaoChip)cartao;
                entrada.setInfo(cartaoChip.getTrilha2());
                entrada.setNumeroAplicacao(cartaoChip.getNumero());
                entrada.setNomeCliente(cartaoChip.getNomePortador());
                entrada.setCodigoRedeAdquirenteChip(cartaoChip.getTipoRedeAdquirente());
                entrada.setStatusChip(cartaoChip.getStatusUltimaLeitura());
                entrada.setCardSequenceNumber(cartaoChip.getPanSequenceNumber());
                entrada.setIndiceAid(cartaoChip.getIndiceRegistroAID());
                entrada.setTipoAplicacaoChip(cartaoChip.getTipoAplicacao());
                entrada.setTipoCartao(cartaoChip.getTipoCartao());
                entrada.setIssuerCountryCode(cartaoChip.getIssuerCountry());
                entrada.setPAN(cartaoChip.getNumero());
                if (cartaoChip.getNumeroCriptografado() != null) {
                    entrada.setCartaoCriptografado(cartaoChip.getNumeroCriptografado());
                }
                entrada.setApplicationExpirationDate(cartaoChip.getApplicationExpirationDate());
                entrada.setApplicationLabel(cartaoChip.getApplicationLabel());
            } else if (dados.getCartao() instanceof CartaoDigitado) {
                CartaoDigitado cartaoDigitado = (CartaoDigitado)dados.getCartao();
                modoEntrada = 1;
                if (cartaoDigitado.getVencimento() != null) {
                    entrada.setDataVencimento(cartaoDigitado.getDateVencimento());
                }
                if (cartaoDigitado.getNumeroCriptografado() != null) {
                    entrada.setCartaoCriptografado(cartaoDigitado.getNumeroCriptografado());
                }
                entrada.setPAN(cartaoDigitado.getNumero());
                if (cartaoDigitado.getNumeroCriptografado() != null) {
                    entrada.setCartaoCriptografado(cartaoDigitado.getNumeroCriptografado());
                }
                if (dados.getEntradaIntegracao() != null) {
                    entrada.setIdentificacaoTransacao(dados.getEntradaIntegracao().getCodigoOrigemTransacao());
                } else {
                    entrada.setIdentificacaoTransacao(dados.getCodigoOrigemTransacao());
                }
                if (conf.isIntegracaoWeb()) {
                    entrada.setIdentificacaoTransacao(2);
                    if (dados.getEntradaIntegracao() != null) {
                        entrada.setCodigoAdquirenteWeb(dados.getEntradaIntegracao().getRedeAdquirente());
                    }
                }
            }
        }
        if (dados.getDDD() != null && dados.getTelefone() != null) {
            DadosSolicitacaoCreditoDigital creditoDigital = new DadosSolicitacaoCreditoDigital();
            creditoDigital.setDdd(dados.getDDD());
            creditoDigital.setTelefone(dados.getTelefone());
            creditoDigital.setVersaoLayout(conf.getVersaoLayoutCD());
            entrada.setDadosCreditoDigital(creditoDigital);
        }
        if (dados.getMatriculaSupervisor() != null) {
            entrada.setMatriculaSupervisor(dados.getMatriculaSupervisor());
        }
        entrada.setNsuCtfTransacaoOriginal(dados.getNsuTransacao());
        entrada.setDataCliente(dados.getStartProcess());
        if (dados.getCodigoSeguranca() != null && dados.getCodigoSeguranca().getCodigo() != null) {
            entrada.setCvv2(dados.getCodigoSeguranca().getCodigo());
        }
        entrada.setModoEntrada(modoEntrada);
        entrada.setTimeoutCtf(dados.getSaidaApiTef().getTimeOutCTF());
        entrada.setTimestamp(new Date());
        entrada.setDataTransacao(dados.getDataTransacao());
        boolean multiTerminal = dados.getEntradaIntegracao() != null && dados.getEntradaIntegracao().isMultiTerminal();
        boolean bl = delivery = dados.getEntradaIntegracao() != null && dados.getEntradaIntegracao().getCodigoOrigemTransacao() == 1;
        if (!multiTerminal) {
            PinInfo pinInfo;
            boolean connectedPin;
            ControladorPerifericos periferico = dados.getPerifericos();
            ControladorBaixaTecnica conBaixaTecnica = ControladorBaixaTecnica.getInstance();
            boolean bl2 = connectedPin = periferico.getPin() != null;
            if (connectedPin && conBaixaTecnica.isBaixaTecnicaSolicitada()) {
                entrada.setFlagBaixaTecnicaVisanet('1');
                entrada.setDadosGeraisPin(conBaixaTecnica.montaDadosGeraisPin());
                entrada.setVersaoAc(ControladorConfCTFClient.getInstance().getConfig().getVersaoAC());
                conBaixaTecnica.persisteBaixaTecnica();
            }
            if (connectedPin) {
                if (periferico.getPin().isBibliotecaEMV()) {
                    if (dados.getDadosGetInfo() != null) {
                        GetInfo dadoGetInfo = dados.getDadosGetInfo();
                        entrada.setNumeroSeriePin(dadoGetInfo.getNumeroSerie());
                        entrada.setRetornoGetInfo(dadoGetInfo.getCodigoRetorno());
                        entrada.setVersaoBibliotecaCompartilhada(dadoGetInfo.getVersaoBibliotecaCompartilhada());
                        entrada.setVersaoEspecificacao(dadoGetInfo.getVersaoEspecificao());
                        entrada.setVersaoAplicacaoBasica(dadoGetInfo.getVersaoAplicacao());
                        entrada.setVersaoBibliotecaRedeEMV(dadoGetInfo.getVersaoBibRede4());
                        entrada.setFabricantePinpad(dadoGetInfo.getFabricante());
                        entrada.setModeloHardware(dadoGetInfo.getModeloHardware());
                        entrada.setVersaoRedeAdquirente(dadoGetInfo.getVersaoRedeAdquirente());
                        entrada.setVersaoKernelEMV(dadoGetInfo.getVersaoKernelEMV());
                    }
                    entrada.setDadosVisanetPin(conBaixaTecnica.montaDadosVisaNetPin());
                    entrada.setTipoPin("16");
                } else {
                    entrada.setTipoPin("14");
                }
            } else {
                entrada.setTipoPin("**");
            }
            TabelaCriptografia tabelaCriptografia = dados.getTabelaCriptografia();
            if (tabelaCriptografia != null) {
                entrada.setMetodoCriptografiaSenha(tabelaCriptografia.getCriptografiaSenhaPrincipal().getAlgoritmo());
                entrada.setMetodoCriptografiaDados(tabelaCriptografia.getCriptografiaDadosPrincipal().getAlgoritmo());
            }
            if ((pinInfo = dados.getPinInfo()) != null) {
                entrada.setSenhaOfflineChip(pinInfo.isVerificadoOffline());
                entrada.setAssinaturaChip(pinInfo.isRequerAssinatura());
                entrada.setChipBloqueadoOffline(pinInfo.isOfflineBloqueado());
                if (dados.getStatusComunicacaoHost() != null && dados.getStatusComunicacaoHost() == 1) {
                    entrada.setDecisaoChip(StringUtil.completaString(pinInfo.getDecisaoFinishChip() + "", 1, ' ', 3).toCharArray()[0]);
                    entrada.setStatusComunicacaoHost(dados.getStatusComunicacaoHost());
                } else {
                    entrada.setDecisaoChip(pinInfo.getDecisaoTomada());
                }
                if (!(dados.getCartao() instanceof CartaoChip) || dados.getCartao() instanceof CartaoChip && pinInfo.isCapturadoVerificacaoOnline() || !ProtocoloBibliotecaCompartilhada.isBibliotecaEMV()) {
                    entrada.setSenha(pinInfo.getPinCriptografado());
                    if (dados.getNumeroSerieChaveDUKPTSenha() != null) {
                        entrada.setNumeroSerieChaveSenha(dados.getNumeroSerieChaveDUKPTSenha());
                    }
                }
                if (dados.getStatusComunicacaoHost() != null && dados.getStatusComunicacaoHost() == 1) {
                    EntradaApiTefC entradaFinishChip = dados.getEntradaApiTef();
                    entrada.setDadosFinaisChip(entradaFinishChip.getDadosFinaisChip());
                } else if (pinInfo.getDadosCampo55() != null) {
                    entrada.setDadosChip(pinInfo.getDadosCampo55());
                }
            }
            LayoutDisplay displayModel = new LayoutDisplay();
            displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO1")));
            displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO2")));
            displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO3")));
            periferico.imprimeDisplay(displayModel);
        } else {
            entrada.setTipoPin("**");
        }
        IdentApiTefC ident = new IdentApiTefC();
        IdentTerminal identTerminal = null;
        identTerminal = multiTerminal || delivery ? (dados.getEntradaIntegracao() != null ? dados.getEntradaIntegracao().getIdentTerminal() : dados.getIdentTerminal()) : new IdentTerminal(conf.getEstabelecimento(), conf.getLoja(), conf.getTerminal());
        if (dados.getEntradaIntegracao() != null && dados.getEntradaIntegracao().getDadosComplementaresTef() != null) {
            entrada.setDadosComplementaresTef(dados.getEntradaIntegracao().getDadosComplementaresTef());
        }
        ident.setNumeroEstabelecimento(identTerminal.getEstabelecimento());
        ident.setNumeroLoja(identTerminal.getLoja());
        ident.setNumeroPdv(identTerminal.getTerminal());
        ident.setNumeroSites(String.valueOf(conf.getNumeroSites()));
        ident.setListaIP(conf.getIps());
        ident.setQuantidadeVias(conf.getQuantidadeVias());
        entrada.setNumeroCupom(dados.getNumeroCupom());
        SaidaApiTefC saidaApiTefC = dados.getApitef().solicitacao(ident, entrada);
        dados.setSaidaApiTef(saidaApiTefC);
        if (saidaApiTefC.getRetorno() != 0) {
            return ERROR;
        }
        VerifyContentUtil.preencheDadosSaida(dados, saidaApiTefC);
        return SUCESS;
    }

    protected String getCodigoOperacao(ITipoOperacao dados) {
        if ("OPERACAO CANCELAMENTO".equals(dados.getTipoOperacao())) {
            return OPERACAO;
        }
        if ("OPERACAO CANCELAMENTO PRE-AUTORIZACAO".equals(dados.getTipoOperacao())) {
            return "3G";
        }
        throw new IllegalArgumentException("C\u00f3digo da transa\u00e7\u00e3o n\u00e3o encotrado");
    }

    protected String getCodigoTransacaoSemLog(IDadosCancelamento dados) throws IllegalStateException {
        SaidaApiTefC saida = dados.getSaidaApiTef();
        TransacoesGenericas transacoesGenericas = TransacoesGenericas.getInstance(saida.getRedeMenuDinamico());
        if (dados.getProdutoSeleciondo().getKeyFluxo() == transacoesGenericas.KEY_FLUXO_DEBITO) {
            if (dados.getTipoFinanciamento() instanceof PlanoAVista) {
                return "10";
            }
            if (dados.getTipoFinanciamento() instanceof PlanoCDC) {
                PlanoCDC planoCDC = (PlanoCDC)dados.getTipoFinanciamento();
                Date now = dados.getStartProcess();
                if (planoCDC.getData1parcela() != null && planoCDC.getData1parcela().compareTo(now) == 0) {
                    return "5B";
                }
                return "5A";
            }
            if (dados.getTipoFinanciamento() instanceof PlanoParcelado) {
                PlanoParcelado planoParcelado = (PlanoParcelado)dados.getTipoFinanciamento();
                Date now = dados.getStartProcess();
                if (planoParcelado.getData1parcela() != null && planoParcelado.getData1parcela().compareTo(now) == 0) {
                    return "28";
                }
                return "23";
            }
            if (dados.getTipoFinanciamento() instanceof PlanoPreDatado) {
                return "20";
            }
        } else if (dados.getProdutoSeleciondo().getKeyFluxo() == transacoesGenericas.KEY_FLUXO_CREDITO) {
            if (dados.getCartao() instanceof CartaoDigitado) {
                if (dados.getTipoFinanciamento() instanceof PlanoAVista) {
                    return "24";
                }
                if (dados.getTipoFinanciamento() instanceof PlanoAdministradora && ((PlanoAdministradora)dados.getTipoFinanciamento()).getNumeroParcela() > 1) {
                    return "25";
                }
                if (dados.getTipoFinanciamento() instanceof PlanoFinanciadoLojista && ((PlanoFinanciadoLojista)dados.getTipoFinanciamento()).getNumeroParcela() > 1) {
                    return "1E";
                }
                if (saida.isRotativoHabilitado()) {
                    return "24";
                }
            } else if (dados.getCartao() instanceof CartaoChip || dados.getCartao() instanceof CartaoMagnetico) {
                if (dados.getTipoFinanciamento() instanceof PlanoAVista) {
                    return "12";
                }
                if (dados.getTipoFinanciamento() instanceof PlanoAdministradora && ((PlanoAdministradora)dados.getTipoFinanciamento()).getNumeroParcela() > 1) {
                    return "22";
                }
                if (dados.getTipoFinanciamento() instanceof PlanoFinanciadoLojista && ((PlanoFinanciadoLojista)dados.getTipoFinanciamento()).getNumeroParcela() > 1) {
                    return "21";
                }
                if (saida.isRotativoHabilitado()) {
                    return "12";
                }
            }
        } else if (dados.getProdutoSeleciondo().getKeyFluxo() == transacoesGenericas.KEY_FLUXO_PRE_AUTORIZACAO) {
            if (dados.getCartao() instanceof CartaoDigitado) {
                return "7D";
            }
            if (dados.getCartao() instanceof CartaoChip || dados.getCartao() instanceof CartaoMagnetico) {
                return "5F";
            }
        } else {
            if (dados.getProdutoSeleciondo().getKeyFluxo() == transacoesGenericas.KEY_FLUXO_PGTO_CONTAS) {
                return "2P";
            }
            if (dados.getProdutoSeleciondo().getKeyFluxo() == transacoesGenericas.KEY_FLUXO_VOUCHER) {
                return "6A";
            }
        }
        throw new IllegalStateException(MSG_OPERATION_NOT_ALLOWED);
    }
}

