/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.IdentApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.IProcessCapturaCredito;
import com.csi.ctfclient.operacoes.model.PlanoAPrazo;
import com.csi.ctfclient.operacoes.model.PlanoAVista;
import com.csi.ctfclient.operacoes.model.PlanoAdministradora;
import com.csi.ctfclient.operacoes.model.PlanoFinanciadoLojista;
import com.csi.ctfclient.operacoes.model.Produto;
import com.csi.ctfclient.servicos.IdentTerminal;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.util.VerifyContentUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import java.util.Date;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class MicSolicitacaoCapturaCredito {
    public static final String SUCCESS = "SUCCESS";
    public static final String ERROR = "ERROR";
    private Logger logger = CTFClientLogger.getCTFClient();

    public String execute(IProcessCapturaCredito dados) throws ExcecaoApiAc {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ControladorPerifericos periferico = dados.getPerifericos();
        EntradaApiTefC entrada = new EntradaApiTefC();
        ConfCTFClient conf = ControladorConfCTFClient.getInstance().getConfig();
        LayoutDisplay displayModel = new LayoutDisplay();
        displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO1")));
        displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO2")));
        displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO3")));
        periferico.imprimeDisplay(displayModel);
        entrada.setOperacao(this.getCodigoTransacao(dados));
        entrada.setNumeroTransacao(dados.getNumeroTransacao());
        if (dados.getEntradaIntegracao() != null) {
            entrada.setDataCliente(dados.getEntradaIntegracao().getDataAbertura());
        } else {
            entrada.setDataCliente(dados.getStartProcess());
        }
        entrada.setTimeoutCtf(dados.getSaidaApiTef().getTimeOutCTF());
        entrada.setTimestamp(new Date());
        entrada.setValorTransacao(dados.getValorTransacao());
        if (dados.getProdutoDinamico() != null) {
            Produto produto = dados.getProdutoDinamico();
            entrada.setCodigoProduto(produto.getCodigo());
            entrada.setCodigoBandeira(produto.getCodigoBandeira());
            entrada.setFluxoTef(produto.getKeyFluxo());
        } else {
            entrada.setCodigoProduto(0);
        }
        if (dados.getPlano() instanceof PlanoAPrazo) {
            PlanoAPrazo prazo = (PlanoAPrazo)((Object)dados.getPlano());
            entrada.setNumeroParcelas(prazo.getNumeroParcela());
        } else {
            entrada.setNumeroParcelas(0);
        }
        entrada.setNsuCtfTransacaoOriginal(dados.getNsuTransacao());
        IdentTerminal identTerminal = null;
        if (conf.isIntegracaoWeb()) {
            identTerminal = dados.getEntradaIntegracao().getIdentTerminal();
            if (dados.getEntradaIntegracao() != null) {
                entrada.setCodigoAdquirenteWeb(dados.getEntradaIntegracao().getRedeAdquirente());
            }
        } else {
            identTerminal = new IdentTerminal(conf.getEstabelecimento(), conf.getLoja(), conf.getTerminal());
        }
        IdentApiTefC ident = new IdentApiTefC();
        ident.setNumeroEstabelecimento(identTerminal.getEstabelecimento());
        ident.setNumeroLoja(identTerminal.getLoja());
        ident.setNumeroPdv(identTerminal.getTerminal());
        ident.setNumeroSites(String.valueOf(conf.getNumeroSites()));
        ident.setListaIP(conf.getIps());
        ident.setQuantidadeVias(conf.getQuantidadeVias());
        entrada.setNumeroCupom(dados.getNumeroCupom());
        entrada.setIndiceMasterKey(dados.getSaidaApiTef().getIndiceMasterKey());
        SaidaApiTefC saidaApiTefC = dados.getApitef().solicitacao(ident, entrada);
        dados.setEntradaApiTef(entrada);
        dados.setSaidaApiTef(saidaApiTefC);
        if (dados.getSaidaApiTef().getRetorno() == 0) {
            VerifyContentUtil.preencheDadosSaida(dados, saidaApiTefC);
            return SUCCESS;
        }
        this.logger.log((Priority)Level.INFO, (Object)("Resposta autorizadora: " + saidaApiTefC.getCodigoRespostaAutorizadora()));
        return ERROR;
    }

    protected String getCodigoTransacao(IProcessCapturaCredito dados) throws IllegalStateException {
        String CODIGO_TRANSACAO = "GD";
        if ("OPE_CAPTURA_CREDITO".equals(dados.getTipoOperacao())) {
            if (dados.getPlano() instanceof PlanoAVista) {
                return CODIGO_TRANSACAO;
            }
            if (dados.getPlano() instanceof PlanoAdministradora) {
                return CODIGO_TRANSACAO;
            }
            if (dados.getPlano() instanceof PlanoFinanciadoLojista) {
                return CODIGO_TRANSACAO;
            }
        }
        throw new IllegalStateException("C\u00f3digo da transa\u00e7\u00e3o n\u00e3o encotrada");
    }
}

