/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.IdentApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.ISolicitacaoCargaProdutosPromocionais;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import java.util.ArrayList;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class MicSolicitacaoCargaProdutosPromocionais {
    public static final String SUCCESS = "SUCCESS";
    public static final String ERROR = "ERROR";
    private Logger logger = CTFClientLogger.getCTFClient();

    public String execute(ISolicitacaoCargaProdutosPromocionais dados) throws ExcecaoApiAc {
        SaidaApiTefC saida;
        boolean flagCarga;
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ControladorPerifericos periferico = dados.getPerifericos();
        EntradaApiTefC entrada = new EntradaApiTefC();
        entrada.setNumeroTransacao(dados.getNumeroTransacao());
        entrada.setOperacao(this.getCodigoTransacao(dados));
        entrada.setCodigoProduto(0);
        if (dados.getEntradaIntegracao() != null) {
            EntradaCTFClientCtrl entradaIntegracao = dados.getEntradaIntegracao();
            entrada.setDataCliente(entradaIntegracao.getDataAbertura());
            if (entradaIntegracao.isTimestampProdutosPromocionaisCtrl()) {
                entrada.setTimestampProdutosPromocionais(entradaIntegracao.getTimestampProdutosPromocionais());
            } else {
                entrada.setTimestampProdutosPromocionais("00000000000000");
            }
        } else {
            entrada.setDataCliente(dados.getStartProcess());
        }
        ConfCTFClient conf = ControladorConfCTFClient.getInstance().getConfig();
        if (conf.getTimeOutDefault() > 0) {
            entrada.setTimeoutCtf(conf.getTimeOutDefault());
        } else {
            entrada.setTimeoutCtf(15);
        }
        LayoutDisplay displayModel = new LayoutDisplay();
        displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO1")));
        displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO2")));
        displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO3")));
        periferico.imprimeDisplay(displayModel);
        IdentApiTefC ident = new IdentApiTefC();
        ident.setNumeroEstabelecimento(conf.getEstabelecimento());
        ident.setNumeroLoja(conf.getLoja());
        ident.setNumeroPdv(conf.getTerminal());
        ident.setNumeroSites(String.valueOf(conf.getNumeroSites()));
        ident.setListaIP(conf.getIps());
        ident.setQuantidadeVias(conf.getQuantidadeVias());
        entrada.setNumeroCupom(dados.getNumeroCupom());
        int retries = 0;
        int maxRetries = 3;
        int indiceCargaProdutos = 0;
        ArrayList listProdutos = new ArrayList();
        do {
            entrada.setIndiceCargaTabelaPin(indiceCargaProdutos);
            this.logger.info((Object)("Solicitando carga de produtos sequencial: " + indiceCargaProdutos + "."));
            saida = dados.getApitef().solicitacao(ident, entrada);
            dados.setEntradaApiTef(entrada);
            dados.setSaidaApiTef(saida);
            flagCarga = saida.isCargaProdutosPromocionais();
            if (saida.getRetorno() == 0) {
                retries = 0;
                indiceCargaProdutos = saida.getIndiceTabelaPin();
                listProdutos.addAll(saida.getProdutosPromocionais());
                continue;
            }
            flagCarga = true;
            this.logger.warn((Object)("Erro na tentativa de carga de produtos. Efetuando tentativa " + ++retries + " de " + maxRetries + "."));
        } while (flagCarga && retries < maxRetries);
        if (saida.getRetorno() != 0) {
            this.logger.log((Priority)Level.INFO, (Object)("Resposta autorizadora: " + saida.getCodigoRespostaAutorizadora()));
            return ERROR;
        }
        saida.setProdutosPromocionais(listProdutos);
        return SUCCESS;
    }

    protected String getCodigoTransacao(ISolicitacaoCargaProdutosPromocionais dados) throws IllegalStateException {
        return "AF";
    }
}

