/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.IdentApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.ISolicitacaoCartaoPrepago;
import com.csi.ctfclient.operacoes.entrada.ISubProcessCartaoPrePago;
import com.csi.ctfclient.operacoes.model.CartaoMagnetico;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.util.VerifyContentUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class MicSolicitacaoCartaoPrepago {
    private Logger logger = CTFClientLogger.getCTFClient();
    public static final String SUCCESS = "SUCCESS";
    public static final String ERROR = "ERROR";

    public String execute(ISolicitacaoCartaoPrepago dados) throws ExcecaoApiAc {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ControladorPerifericos periferico = dados.getPerifericos();
        EntradaApiTefC entrada = new EntradaApiTefC();
        SaidaApiTefC saida = dados.getSaidaApiTef();
        entrada.setNumeroTransacao(dados.getNumeroTransacao());
        entrada.setOperacao(this.getCodigoTransacao(dados));
        if (dados.getEntradaIntegracao() != null) {
            entrada.setDataCliente(dados.getEntradaIntegracao().getDataAbertura());
        } else {
            entrada.setDataCliente(dados.getStartProcess());
        }
        entrada.setTipoPin("**");
        entrada.setTimeoutCtf(saida.getTimeOutCTF());
        ConfCTFClient conf = ControladorConfCTFClient.getInstance().getConfig();
        LayoutDisplay displayModel = new LayoutDisplay();
        displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO1")));
        displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO2")));
        displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO3")));
        periferico.imprimeDisplay(displayModel);
        IdentApiTefC ident = new IdentApiTefC();
        ident.setNumeroEstabelecimento(conf.getEstabelecimento());
        ident.setNumeroLoja(conf.getLoja());
        ident.setNumeroPdv(conf.getTerminal());
        ident.setNumeroSites(String.valueOf(conf.getNumeroSites()));
        ident.setListaIP(conf.getIps());
        ident.setQuantidadeVias(conf.getQuantidadeVias());
        entrada.setNumeroCupom(dados.getNumeroCupom());
        entrada.setIndiceMasterKey(saida.getIndiceMasterKey());
        if (dados.getCartao() != null) {
            if (dados.getCartao() instanceof CartaoMagnetico) {
                CartaoMagnetico cartaoMagnetico = (CartaoMagnetico)dados.getCartao();
                if (cartaoMagnetico.getTrilha1() != null) {
                    entrada.setTrilha1(cartaoMagnetico.getTrilha1());
                }
                if (cartaoMagnetico.getTrilha2() != null) {
                    entrada.setInfo(cartaoMagnetico.getTrilha2());
                }
                entrada.setModoEntrada(2);
            }
        } else {
            entrada.setCodigoBarrasCartaoPrepago(dados.getCodigoBarrasCartaoPrepago());
            entrada.setModoEntrada(dados.getModoEntradaCodigoBarrasCartaoPrepago());
        }
        saida = dados.getApitef().solicitacao(ident, entrada);
        dados.setEntradaApiTef(entrada);
        dados.setSaidaApiTef(saida);
        if (saida.getRetorno() != 0) {
            this.logger.log((Priority)Level.INFO, (Object)("Resposta autorizadora: " + saida.getCodigoRespostaAutorizadora()));
            return ERROR;
        }
        VerifyContentUtil.preencheDadosSaida(dados, saida);
        return SUCCESS;
    }

    protected String getCodigoTransacao(ISolicitacaoCartaoPrepago dado) throws IllegalStateException {
        if (dado.getEntradaIntegracao().getOperacao() == 260) {
            return "FG";
        }
        if (dado.getEntradaIntegracao().getOperacao() == 272) {
            return "FM";
        }
        if (dado.getEntradaIntegracao().getOperacao() == 274) {
            return "E9";
        }
        if (dado.getEntradaIntegracao().getOperacao() == 273) {
            if (dado instanceof ISubProcessCartaoPrePago) {
                ISubProcessCartaoPrePago subProcess = (ISubProcessCartaoPrePago)((Object)dado);
                if (subProcess.isSubFluxoConsulta()) {
                    return "FM";
                }
                return "FG";
            }
        } else {
            if (dado.getEntradaIntegracao().getOperacao() == 275) {
                return "FJ";
            }
            if (dado.getEntradaIntegracao().getOperacao() == 276) {
                return "FL";
            }
        }
        throw new IllegalStateException("Codigo da transa\u00e7\u00e3o n\u00e3o encotrada");
    }
}

