/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.IdentApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.ISolicitacaoCartaoPresente;
import com.csi.ctfclient.operacoes.model.AbstractCartao;
import com.csi.ctfclient.operacoes.model.CartaoChip;
import com.csi.ctfclient.operacoes.model.CartaoDigitado;
import com.csi.ctfclient.operacoes.model.CartaoMagnetico;
import com.csi.ctfclient.operacoes.model.GetInfo;
import com.csi.ctfclient.operacoes.model.PinInfo;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.util.VerifyContentUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class MicSolicitacaoCartaoPresente {
    public static final String SUCCESS = "SUCCESS";
    public static final String ERROR = "ERROR";
    private static final String CONSULTA_CARTAO_PRESENTE = "6B";
    private static final String RECARGA_CARTAO_PRESENTE = "E8";
    private static final String ATIVACAO_CARTAO_PRESENTE = "GC";
    private Logger logger = CTFClientLogger.getCTFClient();

    public String execute(ISolicitacaoCartaoPresente dados) throws ExcecaoApiAc {
        boolean connectedPin;
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ControladorPerifericos periferico = dados.getPerifericos();
        EntradaApiTefC entrada = new EntradaApiTefC();
        SaidaApiTefC saida = dados.getSaidaApiTef();
        entrada.setNumeroTransacao(dados.getNumeroTransacao());
        entrada.setOperacao(this.getCodigoTransacao(dados));
        if (dados.getValorTransacao() == null) {
            if (dados.getSaidaApiTef() != null && dados.getSaidaApiTef().getValorTransacao() != null) {
                entrada.setValorTransacao(dados.getSaidaApiTef().getValorTransacao());
            }
        } else {
            entrada.setValorTransacao(dados.getValorTransacao());
        }
        if (dados.getEntradaIntegracao() != null) {
            entrada.setDataCliente(dados.getEntradaIntegracao().getDataAbertura());
        } else {
            entrada.setDataCliente(dados.getStartProcess());
        }
        boolean bl = connectedPin = periferico.getPin() != null;
        if (connectedPin) {
            if (periferico.getPin().isBibliotecaEMV()) {
                if (dados.getDadosGetInfo() != null) {
                    GetInfo dadoGetInfo = dados.getDadosGetInfo();
                    entrada.setNumeroSeriePin(dadoGetInfo.getNumeroSerie());
                    entrada.setRetornoGetInfo(dadoGetInfo.getCodigoRetorno());
                    entrada.setVersaoBibliotecaCompartilhada(dadoGetInfo.getVersaoBibliotecaCompartilhada());
                    entrada.setVersaoBibliotecaRedeEMV(dadoGetInfo.getVersaoBibRede4());
                }
                entrada.setTipoPin("16");
            } else {
                entrada.setTipoPin("14");
            }
        } else {
            entrada.setTipoPin("**");
        }
        entrada.setTimeoutCtf(saida.getTimeOutCTF());
        entrada.setRetornoBibliotecaCompartilhada(dados.getLastErrorCode());
        if (!(dados.getCartao() instanceof CartaoDigitado)) {
            AbstractCartao cartao = (AbstractCartao)dados.getCartao();
            if (cartao.getNomePortador() != null && !cartao.getNomePortador().equals("")) {
                entrada.setNomeCliente(cartao.getNomePortador());
            }
            entrada.setStatusChip(cartao.getStatusUltimaLeitura());
            entrada.setTipoCartao(cartao.getTipoCartao());
            entrada.setIssuerCountryCode(cartao.getIssuerCountry());
            entrada.setWFlags(cartao.getFlags());
            if (cartao.getTrilha1() != null) {
                entrada.setTrilha1(cartao.getTrilha1());
            }
            if (cartao.getTrilha2() != null) {
                entrada.setInfo(cartao.getTrilha2());
            }
            if (cartao.getTrilha1Criptografado() != null) {
                entrada.setTrilha1Criptografada(cartao.getTrilha1Criptografado());
            }
            if (cartao.getTrilha2Criptografado() != null) {
                entrada.setTrilha2Criptografada(cartao.getTrilha2Criptografado());
            }
        }
        if (dados.getCartao() instanceof CartaoMagnetico) {
            entrada.setModoEntrada(2);
        } else if (dados.getCartao() instanceof CartaoChip) {
            CartaoChip cartaoChip = (CartaoChip)dados.getCartao();
            entrada.setModoEntrada(5);
            entrada.setNumeroAplicacao(cartaoChip.getNumero());
            entrada.setIndiceAid(cartaoChip.getIndiceRegistroAID());
            entrada.setCodigoRedeAdquirenteChip(cartaoChip.getTipoRedeAdquirente());
            entrada.setCardSequenceNumber(cartaoChip.getPanSequenceNumber());
            entrada.setTipoAplicacaoChip(cartaoChip.getTipoAplicacao());
            entrada.setApplicationExpirationDate(cartaoChip.getApplicationExpirationDate());
        } else if (dados.getCartao() instanceof CartaoDigitado) {
            CartaoDigitado cartaoDigitado = (CartaoDigitado)dados.getCartao();
            entrada.setModoEntrada(1);
            entrada.setInfo(cartaoDigitado.getNumero());
            if (cartaoDigitado.getNumeroCriptografado() != null) {
                entrada.setCartaoCriptografado(cartaoDigitado.getNumeroCriptografado());
            }
        }
        PinInfo pinInfo = dados.getPinInfo();
        if (pinInfo != null) {
            entrada.setSenhaOfflineChip(pinInfo.isVerificadoOffline());
            entrada.setAssinaturaChip(pinInfo.isRequerAssinatura());
            entrada.setChipBloqueadoOffline(pinInfo.isOfflineBloqueado());
            entrada.setSenha(pinInfo.getPinCriptografado());
            if (pinInfo.getDadosCampo55() != null) {
                entrada.setDadosChip(pinInfo.getDadosCampo55());
            }
        }
        LayoutDisplay displayModel = new LayoutDisplay();
        displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO1")));
        displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO2")));
        displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO3")));
        periferico.imprimeDisplay(displayModel);
        ConfCTFClient conf = ControladorConfCTFClient.getInstance().getConfig();
        IdentApiTefC ident = new IdentApiTefC();
        ident.setNumeroEstabelecimento(conf.getEstabelecimento());
        ident.setNumeroLoja(conf.getLoja());
        ident.setNumeroPdv(conf.getTerminal());
        ident.setNumeroSites(String.valueOf(conf.getNumeroSites()));
        ident.setListaIP(conf.getIps());
        ident.setQuantidadeVias(conf.getQuantidadeVias());
        entrada.setNumeroCupom(dados.getNumeroCupom());
        entrada.setIndiceMasterKey(saida.getIndiceMasterKey());
        if (connectedPin && !dados.getSaidaApiTef().isReenvioNegadaHost()) {
            periferico.getPin().setMsgDisplay(inter.getMessage("ENVIO_TITLE"));
        }
        saida = dados.getApitef().solicitacao(ident, entrada);
        dados.setEntradaApiTef(entrada);
        dados.setSaidaApiTef(saida);
        if (saida.getRetorno() != 0) {
            this.logger.log((Priority)Level.INFO, (Object)("Resposta autorizadora: " + saida.getCodigoRespostaAutorizadora()));
            return ERROR;
        }
        VerifyContentUtil.preencheDadosSaida(dados, saida);
        return SUCCESS;
    }

    protected String getCodigoTransacao(ISolicitacaoCartaoPresente dados) throws IllegalStateException {
        if ("OPE_CONSULTA_CARTAO_PRESENTE".equals(dados.getTipoOperacao())) {
            return CONSULTA_CARTAO_PRESENTE;
        }
        if ("OPE_RECARGA_CARTAO_PRESENTE".equals(dados.getTipoOperacao())) {
            return RECARGA_CARTAO_PRESENTE;
        }
        if ("OPE_ATIVACAO_CARTAO_PRESENTE".equals(dados.getTipoOperacao())) {
            return ATIVACAO_CARTAO_PRESENTE;
        }
        throw new IllegalStateException("Codigo da transa\u00e7\u00e3o n\u00e3o encotrada");
    }
}

