/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.IdentApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.IConsultaAnaliticaSpc;
import com.csi.ctfclient.operacoes.model.ControladorInicioDia;
import com.csi.ctfclient.operacoes.model.DadosInicioDia;
import com.csi.ctfclient.servicos.IdentTerminal;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class MicSolicitacaoConsultaAnaliticaSpc {
    private static final String CONSULTA_CREDITO = "1M";
    public static final String SUCCESS = "SUCCESS";
    public static final String ERROR = "ERROR";
    private Logger logger = CTFClientLogger.getCTFClient();

    public String execute(IConsultaAnaliticaSpc dados) throws ExcecaoApiAc {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ControladorPerifericos periferico = dados.getPerifericos();
        EntradaApiTefC entrada = new EntradaApiTefC();
        SaidaApiTefC saida = dados.getSaidaApiTef();
        boolean multiTerminal = false;
        boolean delivery = false;
        if (dados.getEntradaIntegracao() != null) {
            multiTerminal = dados.getEntradaIntegracao().isMultiTerminal();
            delivery = dados.getEntradaIntegracao().getCodigoOrigemTransacao() == 1;
        }
        ConfCTFClient conf = ControladorConfCTFClient.getInstance().getConfig();
        IdentTerminal identTerminal = null;
        identTerminal = multiTerminal || delivery ? (dados.getEntradaIntegracao() != null ? dados.getEntradaIntegracao().getIdentTerminal() : dados.getIdentTerminal()) : new IdentTerminal(conf.getEstabelecimento(), conf.getLoja(), conf.getTerminal());
        entrada.setNumeroTransacao(dados.getNumeroTransacao());
        entrada.setOperacao(this.getCodigoTransacao(dados));
        entrada.setValorTransacao(dados.getValorTransacao());
        if (dados.getEntradaIntegracao() != null) {
            entrada.setDataCliente(dados.getEntradaIntegracao().getDataAbertura());
        } else {
            entrada.setDataCliente(dados.getStartProcess());
        }
        ConfCTFClient confCTFClient = ControladorConfCTFClient.getInstance().getConfig();
        if (confCTFClient.getTimeOutDefault() > 0) {
            entrada.setTimeoutCtf(confCTFClient.getTimeOutDefault());
        } else {
            entrada.setTimeoutCtf(15);
        }
        if (dados.getEntradaIntegracao() != null) {
            if (dados.getEntradaIntegracao().isMultiTerminal()) {
                DadosInicioDia dadosInicioDia = ControladorInicioDia.getInstance().getDadosInicioDia(identTerminal, conf.getVersaoPathTerminal());
                entrada.setDataCliente(dadosInicioDia.getDataInicioDia());
            } else {
                entrada.setDataCliente(dados.getEntradaIntegracao().getDataAbertura());
            }
        } else {
            entrada.setDataCliente(dados.getStartProcess());
        }
        entrada.setTipoPin("**");
        String documento = null;
        if (dados.getTipoDocumento() == 2) {
            documento = dados.getCpf();
        } else if (dados.getTipoDocumento() == 1) {
            documento = dados.getCnpj();
        }
        entrada.setInfo(EntradaApiTefC.montaInfoConsultaAnaliticaSpc(dados.getCodigoCliente(), dados.getTipoDocumento(), documento, dados.getTipoConsultaCredito(), dados.getCodigoUsuarioPdv()));
        entrada.setAdicionais(EntradaApiTefC.montaBit62ConsultaAnaliticaSpc(dados.getNomeCliente(), dados.getDataNascimentoCliente()));
        if (!multiTerminal) {
            LayoutDisplay displayModel = new LayoutDisplay();
            displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO1")));
            displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO2")));
            displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO3")));
            periferico.imprimeDisplay(displayModel);
        }
        IdentApiTefC ident = new IdentApiTefC();
        ident.setNumeroEstabelecimento(identTerminal.getEstabelecimento());
        ident.setNumeroLoja(identTerminal.getLoja());
        ident.setNumeroPdv(identTerminal.getTerminal());
        ident.setNumeroSites(String.valueOf(conf.getNumeroSites()));
        ident.setListaIP(conf.getIps());
        ident.setQuantidadeVias(conf.getQuantidadeVias());
        entrada.setNumeroCupom(dados.getNumeroCupom());
        saida = dados.getApitef().solicitacao(ident, entrada);
        dados.setEntradaApiTef(entrada);
        dados.setSaidaApiTef(saida);
        if (saida.getRetorno() != 0) {
            this.logger.log((Priority)Level.INFO, (Object)("Resposta autorizadora: " + saida.getCodigoRespostaAutorizadora()));
            return ERROR;
        }
        return SUCCESS;
    }

    protected String getCodigoTransacao(IConsultaAnaliticaSpc dado) throws IllegalStateException {
        return CONSULTA_CREDITO;
    }
}

