/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.IdentApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorBaixaTecnica;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.IDadosConsultaAvs;
import com.csi.ctfclient.operacoes.model.CartaoDigitado;
import com.csi.ctfclient.operacoes.model.ConsultaAvs;
import com.csi.ctfclient.operacoes.model.GetInfo;
import com.csi.ctfclient.operacoes.model.Produto;
import com.csi.ctfclient.operacoes.model.TabelaCriptografia;
import com.csi.ctfclient.servicos.IdentTerminal;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.util.VerifyContentUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;

public class MicSolicitacaoConsultaAvs {
    public static final String SUCESS = "SUCESS";
    public static final String ERROR = "ERROR";
    private static final String OPERACAO = "D6";

    public String execute(IDadosConsultaAvs dados) throws ExcecaoApiAc {
        boolean connectedPin;
        EntradaApiTefC entrada = new EntradaApiTefC();
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ControladorPerifericos periferico = dados.getPerifericos();
        ControladorBaixaTecnica conBaixaTecnica = ControladorBaixaTecnica.getInstance();
        boolean multiTerminal = false;
        boolean delivery = false;
        if (dados.getEntradaIntegracao() != null) {
            entrada.setDataCliente(dados.getEntradaIntegracao().getDataAbertura());
            multiTerminal = dados.getEntradaIntegracao().isMultiTerminal();
            delivery = dados.getEntradaIntegracao().getCodigoOrigemTransacao() == 1;
        } else {
            entrada.setDataCliente(dados.getStartProcess());
            delivery = dados.getCodigoOrigemTransacao() == 1;
        }
        ConfCTFClient conf = ControladorConfCTFClient.getInstance().getConfig();
        IdentApiTefC ident = new IdentApiTefC();
        IdentTerminal identTerminal = null;
        identTerminal = multiTerminal || delivery ? (dados.getEntradaIntegracao() != null ? dados.getEntradaIntegracao().getIdentTerminal() : dados.getIdentTerminal()) : new IdentTerminal(conf.getEstabelecimento(), conf.getLoja(), conf.getTerminal());
        ident.setNumeroEstabelecimento(identTerminal.getEstabelecimento());
        ident.setNumeroLoja(identTerminal.getLoja());
        ident.setNumeroPdv(identTerminal.getTerminal());
        ident.setNumeroSites(String.valueOf(conf.getNumeroSites()));
        ident.setListaIP(conf.getIps());
        ident.setQuantidadeVias(conf.getQuantidadeVias());
        if (!multiTerminal) {
            try {
                LayoutDisplay displayModel = new LayoutDisplay();
                displayModel.addLinha(new Linha(inter.getMessage("SOLCONAVS_SOLICITACAO1")));
                displayModel.addLinha(new Linha(inter.getMessage("SOLCONAVS_SOLICITACAO2")));
                periferico.imprimeDisplay(displayModel);
            }
            catch (ExcecaoNaoLocal e) {
                return ERROR;
            }
        }
        ConsultaAvs consultaAvs = new ConsultaAvs();
        consultaAvs.setCep(dados.getCep());
        consultaAvs.setEndereco(dados.getEndereco());
        consultaAvs.setNumero(dados.getNumero());
        consultaAvs.setComplemento(dados.getComplemento());
        consultaAvs.setBloco(dados.getBloco());
        consultaAvs.setBairro(dados.getBairro());
        consultaAvs.setCpf(dados.getCpf());
        SaidaApiTefC saida = dados.getSaidaApiTef();
        if (dados.getCartao() instanceof CartaoDigitado) {
            CartaoDigitado cartaoDigitado = (CartaoDigitado)dados.getCartao();
            entrada.setModoEntrada(1);
            entrada.setInfo(cartaoDigitado.getNumero());
            if (cartaoDigitado.getVencimento() != null) {
                entrada.setDataVencimento(cartaoDigitado.getDateVencimento());
            }
            if (cartaoDigitado.getNumeroCriptografado() != null) {
                entrada.setCartaoCriptografado(cartaoDigitado.getNumeroCriptografado());
            }
            entrada.setPAN(cartaoDigitado.getNumero());
            if (cartaoDigitado.getNumeroCriptografado() != null) {
                entrada.setCartaoCriptografado(cartaoDigitado.getNumeroCriptografado());
            }
            if (dados.getEntradaIntegracao() != null) {
                entrada.setIdentificacaoTransacao(dados.getEntradaIntegracao().getCodigoOrigemTransacao());
            } else {
                entrada.setIdentificacaoTransacao(dados.getCodigoOrigemTransacao());
            }
            if (conf.isIntegracaoWeb()) {
                entrada.setIdentificacaoTransacao(2);
            }
        }
        if (dados.getCodigoSeguranca() != null) {
            if (dados.getCodigoSeguranca().getCodigo() == null || dados.getCodigoSeguranca().getCodigo().length() == 0) {
                if (dados.getCodigoSeguranca().getMotivo() == 0) {
                    entrada.setMotivoCVV2('2');
                } else {
                    entrada.setMotivoCVV2('9');
                }
            } else {
                entrada.setCvv2(dados.getCodigoSeguranca().getCodigo());
            }
        }
        entrada.setValorTransacao(dados.getValorTransacao());
        if (dados.getProdutoDinamico() != null) {
            Produto produto = dados.getProdutoDinamico();
            entrada.setCodigoProduto(produto.getCodigo());
            entrada.setCodigoBandeira(produto.getCodigoBandeira());
            entrada.setFluxoTef(produto.getKeyFluxo());
        } else {
            entrada.setCodigoProduto(0);
        }
        boolean bl = connectedPin = periferico.getPin() != null;
        if (connectedPin) {
            if (periferico.getPin().isBibliotecaEMV()) {
                if (dados.getDadosGetInfo() != null) {
                    GetInfo dadoGetInfo = dados.getDadosGetInfo();
                    entrada.setNumeroSeriePin(dadoGetInfo.getNumeroSerie());
                    entrada.setRetornoGetInfo(dadoGetInfo.getCodigoRetorno());
                    entrada.setVersaoBibliotecaCompartilhada(dadoGetInfo.getVersaoBibliotecaCompartilhada());
                    entrada.setVersaoEspecificacao(dadoGetInfo.getVersaoEspecificao());
                    entrada.setVersaoAplicacaoBasica(dadoGetInfo.getVersaoAplicacao());
                    entrada.setFabricantePinpad(dadoGetInfo.getFabricante());
                    entrada.setModeloHardware(dadoGetInfo.getModeloHardware());
                    entrada.setVersaoRedeAdquirente(dadoGetInfo.getVersaoRedeAdquirente());
                    entrada.setVersaoKernelEMV(dadoGetInfo.getVersaoKernelEMV());
                }
                entrada.setDadosVisanetPin(conBaixaTecnica.montaDadosVisaNetPin());
                entrada.setTipoPin("16");
            } else {
                entrada.setTipoPin("14");
            }
        } else {
            entrada.setTipoPin("**");
        }
        entrada.setTimeoutCtf(dados.getSaidaApiTef().getTimeOutCTF());
        TabelaCriptografia tabelaCriptografia = dados.getTabelaCriptografia();
        if (tabelaCriptografia != null) {
            entrada.setMetodoCriptografiaSenha(tabelaCriptografia.getCriptografiaSenhaPrincipal().getAlgoritmo());
            if (tabelaCriptografia.getCriptografiaDadosPrincipal() != null) {
                entrada.setMetodoCriptografiaDados(tabelaCriptografia.getCriptografiaDadosPrincipal().getAlgoritmo());
            }
        }
        entrada.setOperacao(OPERACAO);
        entrada.setDadosConsultaAvs(consultaAvs);
        dados.setEntradaApiTef(entrada);
        saida = dados.getApitef().solicitacao(ident, entrada);
        dados.setSaidaApiTef(saida);
        VerifyContentUtil.preencheDadosSaida(dados, saida);
        if (saida.getRetorno() != 0) {
            return ERROR;
        }
        return SUCESS;
    }
}

