/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.IdentApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.IDadosConsultaCheque;
import com.csi.ctfclient.operacoes.entrada.ITipoOperacao;
import com.csi.ctfclient.operacoes.model.Cheque;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.util.VerifyContentUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import java.text.DecimalFormat;
import java.util.Calendar;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class MicSolicitacaoConsultaCheque {
    public static final String SUCESS = "SUCESS";
    public static final String ERRO_TRANS_JA_EFETUADA = "ERRO_TRANS_JA_EFETUADA";
    public static final String ERROR = "ERROR";
    private Logger logger = CTFClientLogger.getCTFClient();

    public String execute(IDadosConsultaCheque dados) throws ExcecaoApiAc {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        EntradaApiTefC entrada = new EntradaApiTefC();
        SaidaApiTefC saida = dados.getSaidaApiTef();
        ControladorPerifericos periferico = dados.getPerifericos();
        String codigoTransacao = this.getCodigoTransacao(dados);
        entrada.setValorTransacao(dados.getValorTransacao());
        String documento = "";
        if (dados.getTipoDocumento() == 1) {
            documento = dados.getCnpj();
        } else if (dados.getTipoDocumento() == 2) {
            documento = dados.getCpf();
        }
        String entradaConsultaCheque = Cheque.montaEntradaConsultaCheque(dados.getNumeroCheque(), dados.getBanco(), dados.getAgencia(), dados.getTipoDocumento(), documento, dados.getContaCorrente(), dados.getPraca(), dados.getDDD(), dados.getTelefone());
        entrada.setInfo(entradaConsultaCheque);
        entrada.setTimeoutCtf(15);
        DecimalFormat df = new DecimalFormat("00");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(dados.getDataCheque());
        String strDataCheque = String.valueOf(calendar.get(1)) + df.format(calendar.get(2) + 1) + df.format(calendar.get(5));
        entrada.setAdicionais(strDataCheque);
        if (dados.getCmc7() != null) {
            entrada.setAdicionais(dados.getCmc7());
        }
        if (dados.getEntradaIntegracao() != null) {
            entrada.setDataCliente(dados.getEntradaIntegracao().getDataAbertura());
        } else {
            entrada.setDataCliente(dados.getStartProcess());
        }
        entrada.setOperacao(codigoTransacao);
        entrada.setNumeroTransacao(dados.getNumeroTransacao());
        LayoutDisplay displayModel = new LayoutDisplay();
        displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO1")));
        displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO2")));
        displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO3")));
        periferico.imprimeDisplay(displayModel);
        ConfCTFClient conf = ControladorConfCTFClient.getInstance().getConfig();
        IdentApiTefC ident = new IdentApiTefC();
        ident.setNumeroEstabelecimento(conf.getEstabelecimento());
        ident.setNumeroLoja(conf.getLoja());
        ident.setNumeroPdv(conf.getTerminal());
        ident.setNumeroSites(String.valueOf(conf.getNumeroSites()));
        ident.setListaIP(conf.getIps());
        ident.setQuantidadeVias(conf.getQuantidadeVias());
        dados.setEntradaApiTef(entrada);
        saida = dados.getApitef().solicitacao(ident, entrada);
        dados.setSaidaApiTef(saida);
        if (saida.getRetorno() != 0) {
            this.logger.log((Priority)Level.INFO, (Object)("Resposta autorizadora: " + saida.getCodigoRespostaAutorizadora()));
            if (saida.getCodigoRespostaAutorizadora().equals("0ER")) {
                return ERRO_TRANS_JA_EFETUADA;
            }
            return ERROR;
        }
        VerifyContentUtil.preencheDadosSaida(dados, saida);
        return SUCESS;
    }

    private String getCodigoTransacao(ITipoOperacao dados) {
        if (dados.getTipoOperacao().equals("OPERACAO CONSULTA CHEQUE")) {
            return "16";
        }
        if (dados.getTipoOperacao().equals("OPERACAO GARANTIA CHEQUE")) {
            return "17";
        }
        throw new IllegalStateException("Codigo da transa\u00e7\u00e3o n\u00e3o encotrada");
    }
}

