/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.IdentApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.ControladorBaixaTecnica;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.IProcessConsultaFinanciamentoCredito;
import com.csi.ctfclient.operacoes.model.AbstractCartao;
import com.csi.ctfclient.operacoes.model.Cartao;
import com.csi.ctfclient.operacoes.model.CartaoChip;
import com.csi.ctfclient.operacoes.model.CartaoDigitado;
import com.csi.ctfclient.operacoes.model.CartaoMagnetico;
import com.csi.ctfclient.operacoes.model.GetInfo;
import com.csi.ctfclient.operacoes.model.PinInfo;
import com.csi.ctfclient.operacoes.model.Plano;
import com.csi.ctfclient.operacoes.model.PlanoAdministradora;
import com.csi.ctfclient.operacoes.model.TaxaJuroParcela;
import com.csi.ctfclient.servicos.IdentTerminal;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.devices.emvfull.ProtocoloBibliotecaCompartilhada;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.VerifyContentUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class MicSolicitacaoConsultaFinanciamentoCredito {
    public static final String SUCESS = "SUCESS";
    public static final String ERRO = "ERRO";
    private static Logger logger = CTFClientLogger.getCTFClient();

    public String execute(IProcessConsultaFinanciamentoCredito dados) throws ExcecaoApiAc {
        boolean connectedPin;
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ControladorPerifericos periferico = dados.getPerifericos();
        ControladorBaixaTecnica conBaixaTecnica = ControladorBaixaTecnica.getInstance();
        EntradaApiTefC entrada = new EntradaApiTefC();
        SaidaApiTefC saida = dados.getSaidaApiTef();
        entrada.setNumeroTransacao(dados.getNumeroTransacao());
        entrada.setOperacao(this.getCodigoTransacao(dados));
        entrada.setValorTransacao(dados.getValorTransacao());
        if (dados.getEntradaIntegracao() != null) {
            entrada.setDataCliente(dados.getEntradaIntegracao().getDataAbertura());
        } else {
            entrada.setDataCliente(dados.getStartProcess());
        }
        boolean bl = connectedPin = periferico.getPin() != null;
        if (connectedPin && conBaixaTecnica.isBaixaTecnicaSolicitada()) {
            entrada.setFlagBaixaTecnicaVisanet('1');
            entrada.setDadosGeraisPin(conBaixaTecnica.montaDadosGeraisPin());
            entrada.setVersaoAc(ControladorConfCTFClient.getInstance().getConfig().getVersaoAC());
            conBaixaTecnica.persisteBaixaTecnica();
        }
        if (connectedPin) {
            if (periferico.getPin().isBibliotecaEMV()) {
                if (dados.getDadosGetInfo() != null) {
                    GetInfo dadoGetInfo = dados.getDadosGetInfo();
                    entrada.setNumeroSeriePin(dadoGetInfo.getNumeroSerie());
                    entrada.setRetornoGetInfo(dadoGetInfo.getCodigoRetorno());
                    entrada.setVersaoBibliotecaCompartilhada(dadoGetInfo.getVersaoBibliotecaCompartilhada());
                    entrada.setVersaoEspecificacao(dadoGetInfo.getVersaoEspecificao());
                    entrada.setVersaoAplicacaoBasica(dadoGetInfo.getVersaoAplicacao());
                    entrada.setFabricantePinpad(dadoGetInfo.getFabricante());
                    entrada.setModeloHardware(dadoGetInfo.getModeloHardware());
                    entrada.setVersaoRedeAdquirente(dadoGetInfo.getVersaoRedeAdquirente());
                    entrada.setVersaoKernelEMV(dadoGetInfo.getVersaoKernelEMV());
                }
                entrada.setDadosVisanetPin(conBaixaTecnica.montaDadosVisaNetPin());
                entrada.setTipoPin("16");
            } else {
                entrada.setTipoPin("14");
            }
        } else {
            entrada.setTipoPin("**");
        }
        entrada.setTimeoutCtf(saida.getTimeOutCTF());
        if (dados.getCodigoSeguranca() != null) {
            if (dados.getCodigoSeguranca().getCodigo() == null || dados.getCodigoSeguranca().getCodigo().length() == 0) {
                if (dados.getCodigoSeguranca().getMotivo() == 0) {
                    entrada.setMotivoCVV2('2');
                } else {
                    entrada.setMotivoCVV2('9');
                }
            } else {
                entrada.setCvv2(dados.getCodigoSeguranca().getCodigo());
            }
        }
        if (dados.getTipoFinanciamento() instanceof PlanoAdministradora) {
            PlanoAdministradora planoParcelado = (PlanoAdministradora)dados.getTipoFinanciamento();
            int numeroParcelas = planoParcelado.getNumeroParcela();
            entrada.setNumeroParcelas(numeroParcelas);
        }
        if (dados.getCartao() != null) {
            StringBuffer bit62Formatado = new StringBuffer();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
            Cartao cartao = dados.getCartao();
            if (cartao.getEmissao() != null) {
                Date dataEmissaoDate = this.formataData(cartao.getEmissao());
                bit62Formatado.append(simpleDateFormat.format(dataEmissaoDate));
                entrada.setAdicionais(bit62Formatado.toString());
            }
            if (!(dados.getCartao() instanceof CartaoDigitado)) {
                AbstractCartao abstractCartao = (AbstractCartao)dados.getCartao();
                if (abstractCartao.getNomePortador() != null && !abstractCartao.getNomePortador().equals("")) {
                    entrada.setNomeCliente(abstractCartao.getNomePortador());
                }
                entrada.setStatusChip(abstractCartao.getStatusUltimaLeitura());
                entrada.setTipoCartao(abstractCartao.getTipoCartao());
                entrada.setIssuerCountryCode(abstractCartao.getIssuerCountry());
                entrada.setWFlags(abstractCartao.getFlags());
                if (abstractCartao.getTrilha1() != null) {
                    entrada.setTrilha1(abstractCartao.getTrilha1());
                }
                if (abstractCartao.getTrilha2() != null) {
                    entrada.setInfo(abstractCartao.getTrilha2());
                }
                if (abstractCartao.getTrilha1Criptografado() != null) {
                    entrada.setTrilha1Criptografada(abstractCartao.getTrilha1Criptografado());
                }
                if (abstractCartao.getTrilha2Criptografado() != null) {
                    entrada.setTrilha2Criptografada(abstractCartao.getTrilha2Criptografado());
                }
                entrada.setPAN(abstractCartao.getNumero());
                if (abstractCartao.getNumeroCriptografado() != null) {
                    entrada.setCartaoCriptografado(abstractCartao.getNumeroCriptografado());
                }
            }
            if (dados.getCartao() instanceof CartaoMagnetico) {
                entrada.setModoEntrada(2);
            } else if (dados.getCartao() instanceof CartaoChip) {
                CartaoChip cartaoChip = (CartaoChip)dados.getCartao();
                entrada.setModoEntrada(5);
                entrada.setNumeroAplicacao(cartaoChip.getNumero());
                entrada.setIndiceAid(cartaoChip.getIndiceRegistroAID());
                entrada.setCodigoRedeAdquirenteChip(cartaoChip.getTipoRedeAdquirente());
                entrada.setCardSequenceNumber(cartaoChip.getPanSequenceNumber());
                entrada.setTipoAplicacaoChip(cartaoChip.getTipoAplicacao());
                entrada.setApplicationExpirationDate(cartaoChip.getApplicationExpirationDate());
                entrada.setApplicationLabel(cartaoChip.getApplicationLabel());
            } else if (dados.getCartao() instanceof CartaoDigitado) {
                CartaoDigitado cartaoDigitado = (CartaoDigitado)dados.getCartao();
                entrada.setModoEntrada(1);
                entrada.setInfo(cartaoDigitado.getNumero());
                if (cartaoDigitado.getNumeroCriptografado() != null) {
                    entrada.setCartaoCriptografado(cartaoDigitado.getNumeroCriptografado());
                }
                if (cartaoDigitado.getVencimento() != null) {
                    entrada.setDataVencimento(cartaoDigitado.getDateVencimento());
                }
                entrada.setPAN(cartaoDigitado.getNumero());
                if (cartaoDigitado.getNumeroCriptografado() != null) {
                    entrada.setCartaoCriptografado(cartaoDigitado.getNumeroCriptografado());
                }
            }
            PinInfo pinInfo = dados.getPinInfo();
            if (pinInfo != null) {
                entrada.setSenhaOfflineChip(pinInfo.isVerificadoOffline());
                entrada.setAssinaturaChip(pinInfo.isRequerAssinatura());
                entrada.setChipBloqueadoOffline(pinInfo.isOfflineBloqueado());
                logger.log((Priority)Level.DEBUG, (Object)("Status comunica\u00e7\u00e3o host: " + dados.getStatusComunicacaoHost()));
                if (dados.getStatusComunicacaoHost() != null && dados.getStatusComunicacaoHost() == 1) {
                    entrada.setDecisaoChip(StringUtil.completaString(pinInfo.getDecisaoFinishChip() + "", 1, ' ', 3).toCharArray()[0]);
                    entrada.setStatusComunicacaoHost(dados.getStatusComunicacaoHost());
                } else {
                    entrada.setDecisaoChip(pinInfo.getDecisaoTomada());
                }
                if (!(dados.getCartao() instanceof CartaoChip) || dados.getCartao() instanceof CartaoChip && pinInfo.isCapturadoVerificacaoOnline() || !ProtocoloBibliotecaCompartilhada.isBibliotecaEMV()) {
                    entrada.setSenha(pinInfo.getPinCriptografado());
                    if (dados.getNumeroSerieChaveDUKPTSenha() != null) {
                        entrada.setNumeroSerieChaveSenha(dados.getNumeroSerieChaveDUKPTSenha());
                    }
                }
                if (dados.getStatusComunicacaoHost() != null && dados.getStatusComunicacaoHost() == 1) {
                    EntradaApiTefC entradaFinishChip = dados.getEntradaApiTef();
                    entrada.setDadosFinaisChip(entradaFinishChip.getDadosFinaisChip());
                } else if (pinInfo.getDadosCampo55() != null) {
                    entrada.setDadosChip(pinInfo.getDadosCampo55());
                }
            }
        }
        ConfCTFClient conf = ControladorConfCTFClient.getInstance().getConfig();
        if (dados.getEntradaIntegracao() != null && dados.getEntradaIntegracao().isCodigoTabelaCtrl()) {
            entrada.setCodigoTabela(dados.getEntradaIntegracao().getCodigoTabela());
        } else if (conf.getCodigoTabela() > 0) {
            entrada.setCodigoTabela(conf.getCodigoTabela());
        }
        if (dados.getTipoFinanciamento() != null && dados.getTipoFinanciamento() instanceof Plano) {
            Plano plano = dados.getTipoFinanciamento();
            if (plano.getNumeroCiclos() >= 0) {
                String ciclos = StringUtil.completaString(plano.getNumeroCiclos() + "", 2, '0', 3);
                entrada.setNumeroCiclos(plano.getNumeroCiclos());
            } else {
                entrada.setNumeroCiclos(0);
            }
        }
        if (dados.getEntradaIntegracao() != null && dados.getEntradaIntegracao().isCodigoTabelaCtrl()) {
            entrada.setCodigoTabela(dados.getEntradaIntegracao().getCodigoTabela());
        }
        if (!conf.isIntegracaoWeb()) {
            LayoutDisplay displayModel = new LayoutDisplay();
            displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO1")));
            displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO2")));
            displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO3")));
            periferico.imprimeDisplay(displayModel);
        }
        IdentTerminal identTerminal = null;
        identTerminal = conf.isIntegracaoWeb() ? dados.getEntradaIntegracao().getIdentTerminal() : new IdentTerminal(conf.getEstabelecimento(), conf.getLoja(), conf.getTerminal());
        IdentApiTefC ident = new IdentApiTefC();
        ident.setNumeroEstabelecimento(identTerminal.getEstabelecimento());
        ident.setNumeroLoja(identTerminal.getLoja());
        ident.setNumeroPdv(identTerminal.getTerminal());
        ident.setNumeroSites(String.valueOf(conf.getNumeroSites()));
        ident.setListaIP(conf.getIps());
        ident.setQuantidadeVias(conf.getQuantidadeVias());
        entrada.setNumeroCupom(dados.getNumeroCupom());
        entrada.setIndiceMasterKey(saida.getIndiceMasterKey());
        dados.setEntradaApiTef(entrada);
        if (connectedPin && !dados.getSaidaApiTef().isReenvioNegadaHost()) {
            periferico.getPin().setMsgDisplay(inter.getMessage("ENVIO_TITLE"));
        }
        saida = dados.getApitef().solicitacao(ident, entrada);
        dados.setSaidaApiTef(saida);
        if (saida.getRetorno() != 0) {
            logger.log((Priority)Level.INFO, (Object)("Resposta autorizadora: " + saida.getCodigoRespostaAutorizadora()));
            if (saida.getCodigoRespostaAutorizadora().equals("0ER")) {
                return ERRO;
            }
            if (saida.getCodigoRespostaAutorizadora().equals("0F5")) {
                return ERRO;
            }
            return ERRO;
        }
        ArrayList<TaxaJuroParcela> parcelas = new ArrayList<TaxaJuroParcela>();
        String bit62 = saida.getAdicionais();
        logger.info((Object)bit62);
        int numeroParcelaConsultada = 0;
        if (dados.getTipoFinanciamento() instanceof PlanoAdministradora) {
            PlanoAdministradora planoParcelado = (PlanoAdministradora)dados.getTipoFinanciamento();
            numeroParcelaConsultada = planoParcelado.getNumeroParcela();
        }
        if (numeroParcelaConsultada == 0 && bit62 != null && !bit62.trim().equals("")) {
            int qtd = 0;
            try {
                qtd = bit62.length() / 64;
            }
            catch (Exception e) {
                logger.error((Object)("n\u00e3o foi poss\u00edvel desmontar bit62. tamanho = " + bit62.length()));
            }
            int tamanho = 64;
            int x = 0;
            for (int i = 0; i < qtd; ++i) {
                String valor = bit62.substring(tamanho * i, tamanho * i + tamanho);
                x = 0;
                TaxaJuroParcela parcela = new TaxaJuroParcela();
                parcela.setNumero(Integer.parseInt(valor.substring(x, x + 2)));
                parcela.setValor(new BigDecimal(valor.substring(x += 2, x + 12)).movePointLeft(2));
                parcela.setValorTotal(new BigDecimal(valor.substring(x += 12, x + 12)).movePointLeft(2));
                parcela.setTaxaJuros(new BigDecimal(valor.substring(x += 12, x + 7)).movePointLeft(2));
                x += 7;
                try {
                    parcela.setCodigoPlano(Integer.parseInt(valor.substring(x, x + 5)));
                }
                catch (Exception e) {
                    logger.log((Priority)Level.DEBUG, (Object)"C\u00f3digo do plano n\u00e3o retornado");
                    e.printStackTrace();
                }
                x += 5;
                parcelas.add(parcela);
            }
        } else {
            TaxaJuroParcela parcela = new TaxaJuroParcela();
            parcela.setNumero(numeroParcelaConsultada);
            parcela.setValor(saida.getValorParcela());
            parcela.setValorTotal(saida.getValorTotal());
            parcela.setTaxaJuros(saida.getTaxaJuros());
            parcelas.add(parcela);
        }
        dados.setConsultaParcelas(parcelas);
        VerifyContentUtil.preencheDadosSaida(dados, saida);
        return SUCESS;
    }

    protected String getCodigoTransacao(IProcessConsultaFinanciamentoCredito dado) throws IllegalStateException {
        if ("OPERACAO CREDITO".equals(dado.getTipoOperacao()) && dado.getTipoFinanciamento() instanceof PlanoAdministradora) {
            if (dado.getCartao() instanceof CartaoDigitado) {
                return "7C";
            }
            if (dado.getCartao() instanceof CartaoChip || dado.getCartao() instanceof CartaoMagnetico) {
                return "4F";
            }
        }
        throw new IllegalStateException("Codigo da transa\u00e7\u00e3o n\u00e3o encotrada");
    }

    private Date formataData(String value) {
        Date data;
        if (value.length() != 6) {
            throw new IllegalArgumentException("Data Invalida " + value);
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("MMyyyy");
        dateFormat.setLenient(false);
        try {
            data = dateFormat.parse(value);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Data Invalida " + value);
        }
        return data;
    }
}

