/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.IdentApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.ControladorBaixaTecnica;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.IConvenioCombustivelShell;
import com.csi.ctfclient.operacoes.model.AbstractCartao;
import com.csi.ctfclient.operacoes.model.CartaoChip;
import com.csi.ctfclient.operacoes.model.CartaoDigitado;
import com.csi.ctfclient.operacoes.model.CartaoMagnetico;
import com.csi.ctfclient.operacoes.model.GetInfo;
import com.csi.ctfclient.operacoes.model.PinInfo;
import com.csi.ctfclient.operacoes.model.TabelaCriptografia;
import com.csi.ctfclient.operacoes.model.controller.ProdutoConvenioCombustivel;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.devices.emvfull.ProtocoloBibliotecaCompartilhada;
import com.csi.ctfclient.tools.util.VerifyContentUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class MicSolicitacaoConvenioCombustivel {
    public static final String SUCCESS = "SUCCESS";
    public static final String ERROR = "ERROR";
    public static final String REFAZER_PERGUNTAS = "REFAZER_PERGUNTAS";
    public static final String REFAZER_TRANSACAO = "REFAZER_TRANSACAO";
    public static final String CAPTURAR_SENHA = "CAPTURAR_SENHA";
    private Logger logger = CTFClientLogger.getCTFClient();
    private InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();

    public String execute(IConvenioCombustivelShell dados) throws ExcecaoApiAc {
        TabelaCriptografia tabelaCriptografia;
        EntradaCTFClientCtrl entradaIntegracao;
        ControladorPerifericos periferico = dados.getPerifericos();
        ControladorBaixaTecnica conBaixaTecnica = ControladorBaixaTecnica.getInstance();
        ConfCTFClient conf = ControladorConfCTFClient.getInstance().getConfig();
        EntradaApiTefC entrada = dados.getEntradaApiTef() != null ? dados.getEntradaApiTef() : new EntradaApiTefC();
        SaidaApiTefC saida = dados.getSaidaApiTef();
        if ("OPE_CONVENIO_COMBUSTIVEL_PRE_VALIDACAO".equals(dados.getTipoOperacao())) {
            entrada.setNumeroTransacao(0);
        } else {
            entrada.setNumeroTransacao(dados.getNumeroTransacao());
        }
        entrada.setOperacao(this.getCodigoTransacao(dados));
        if (dados.getValorTransacao() != null) {
            entrada.setValorTransacao(dados.getValorTransacao());
        }
        if ((entradaIntegracao = dados.getEntradaIntegracao()) != null) {
            entrada.setDataCliente(entradaIntegracao.getDataAbertura());
        } else {
            entrada.setDataCliente(dados.getStartProcess());
        }
        if (periferico.getPin() != null) {
            if (periferico.getPin().isBibliotecaEMV()) {
                if (dados.getDadosGetInfo() != null) {
                    GetInfo dadoGetInfo = dados.getDadosGetInfo();
                    entrada.setNumeroSeriePin(dadoGetInfo.getNumeroSerie());
                    entrada.setVersaoBibliotecaCompartilhada(dadoGetInfo.getVersaoBibliotecaCompartilhada());
                    entrada.setVersaoEspecificacao(dadoGetInfo.getVersaoEspecificao());
                    entrada.setVersaoAplicacaoBasica(dadoGetInfo.getVersaoAplicacao());
                    entrada.setVersaoBibliotecaRedeEMV(dadoGetInfo.getVersaoBibRede4());
                    entrada.setFabricantePinpad(dadoGetInfo.getFabricante());
                    entrada.setModeloHardware(dadoGetInfo.getModeloHardware());
                    entrada.setVersaoRedeAdquirente(dadoGetInfo.getVersaoRedeAdquirente());
                    entrada.setVersaoKernelEMV(dadoGetInfo.getVersaoKernelEMV());
                }
                entrada.setTipoPin("16");
            } else {
                entrada.setTipoPin("14");
            }
        } else {
            entrada.setTipoPin("**");
        }
        if (saida != null) {
            entrada.setTimeoutCtf(saida.getTimeOutCTF());
        }
        if (dados.getListInformacoesAdicionais() != null) {
            entrada.setInformacoesAdicionais(dados.getListInformacoesAdicionais());
        }
        if (saida != null && saida.isPedeCVV2()) {
            entrada.setCvv2(dados.getCodigoSeguranca().getCodigo());
            if (dados.getCodigoSeguranca().getCodigo().length() == 0) {
                if (dados.getCodigoSeguranca().getMotivo() == 0) {
                    entrada.setMotivoCVV2('2');
                } else {
                    entrada.setMotivoCVV2('9');
                }
            } else {
                entrada.setCvv2(dados.getCodigoSeguranca().getCodigo());
            }
        }
        if (!(dados.getCartao() instanceof CartaoDigitado)) {
            AbstractCartao cartao = (AbstractCartao)dados.getCartao();
            if (cartao.getNomePortador() != null && !cartao.getNomePortador().equals("")) {
                entrada.setNomeCliente(cartao.getNomePortador());
            }
            entrada.setStatusChip(cartao.getStatusUltimaLeitura());
            entrada.setTipoCartao(cartao.getTipoCartao());
            entrada.setIssuerCountryCode(cartao.getIssuerCountry());
            entrada.setWFlags(cartao.getFlags());
            if (cartao.getTrilha1() != null) {
                entrada.setTrilha1(cartao.getTrilha1());
            }
            if (cartao.getTrilha2() != null) {
                entrada.setInfo(cartao.getTrilha2());
            }
            if (cartao.getTrilha1Criptografado() != null) {
                entrada.setTrilha1Criptografada(cartao.getTrilha1Criptografado());
            }
            if (cartao.getTrilha2Criptografado() != null) {
                entrada.setTrilha2Criptografada(cartao.getTrilha2Criptografado());
            }
            entrada.setPAN(cartao.getNumero());
            if (cartao.getNumeroCriptografado() != null) {
                entrada.setCartaoCriptografado(cartao.getNumeroCriptografado());
            }
        }
        if (dados.getCartao() instanceof CartaoMagnetico) {
            entrada.setModoEntrada(2);
        } else if (dados.getCartao() instanceof CartaoChip) {
            CartaoChip cartaoChip = (CartaoChip)dados.getCartao();
            entrada.setModoEntrada(5);
            entrada.setNumeroAplicacao(cartaoChip.getNumero());
            entrada.setIndiceAid(cartaoChip.getIndiceRegistroAID());
            entrada.setCodigoRedeAdquirenteChip(cartaoChip.getTipoRedeAdquirente());
            entrada.setCardSequenceNumber(cartaoChip.getPanSequenceNumber());
            entrada.setTipoAplicacaoChip(cartaoChip.getTipoAplicacao());
            entrada.setApplicationExpirationDate(cartaoChip.getApplicationExpirationDate());
        } else if (dados.getCartao() instanceof CartaoDigitado) {
            CartaoDigitado cartaoDigitado = (CartaoDigitado)dados.getCartao();
            entrada.setModoEntrada(1);
            entrada.setInfo(cartaoDigitado.getNumero());
            entrada.setPAN(cartaoDigitado.getNumero());
            if (cartaoDigitado.getNumeroCriptografado() != null) {
                entrada.setCartaoCriptografado(cartaoDigitado.getNumeroCriptografado());
            }
        }
        PinInfo pinInfo = dados.getPinInfo();
        if (pinInfo != null) {
            entrada.setSenhaOfflineChip(pinInfo.isVerificadoOffline());
            entrada.setAssinaturaChip(pinInfo.isRequerAssinatura());
            entrada.setDecisaoChip(pinInfo.getDecisaoTomada());
            if (!(dados.getCartao() instanceof CartaoChip) || dados.getCartao() instanceof CartaoChip && pinInfo.isCapturadoVerificacaoOnline() || !ProtocoloBibliotecaCompartilhada.isBibliotecaEMV()) {
                entrada.setSenha(pinInfo.getPinCriptografado());
                if (dados.getNumeroSerieChaveDUKPTSenha() != null) {
                    entrada.setNumeroSerieChaveSenha(dados.getNumeroSerieChaveDUKPTSenha());
                }
            }
        }
        if ((tabelaCriptografia = dados.getTabelaCriptografia()) != null) {
            entrada.setMetodoCriptografiaSenha(tabelaCriptografia.getCriptografiaSenhaPrincipal().getAlgoritmo());
            if (tabelaCriptografia.getCriptografiaDadosPrincipal() != null) {
                entrada.setMetodoCriptografiaDados(tabelaCriptografia.getCriptografiaDadosPrincipal().getAlgoritmo());
            }
        }
        if (dados.getListProdutoConvenioCombustivel() != null && !dados.getListProdutoConvenioCombustivel().isEmpty()) {
            Iterator iteLista = dados.getListProdutoConvenioCombustivel().iterator();
            String codigos = "";
            while (iteLista.hasNext()) {
                ProdutoConvenioCombustivel produto = (ProdutoConvenioCombustivel)iteLista.next();
                codigos = codigos + produto.getCodigo();
            }
            this.logger.log((Priority)Level.INFO, (Object)("C\u00f3digos dos produtos/servi\u00e7os selecionados: (" + codigos + ")"));
            entrada.setProdutoConvenioCombustivel(dados.getListProdutoConvenioCombustivel());
        }
        if (dados.getBombaCombustivel() != null) {
            entrada.setBombaCombustivel(dados.getBombaCombustivel().getId());
            entrada.setNumeroCasasDecimais(dados.getBombaCombustivel().getCasasDecimais());
        }
        if (dados.getLitros() != null) {
            entrada.setLitros(dados.getLitros());
        }
        if (dados.getPrecoUnitarioLitroCombustivel() != null) {
            entrada.setPrecoUnitarioLitroCombustivel(dados.getPrecoUnitarioLitroCombustivel());
        } else {
            entrada.setPrecoUnitarioLitroCombustivel(new BigDecimal(0));
        }
        if (dados.getValorTransacao() != null) {
            entrada.setValorTransacao(dados.getValorTransacao());
        }
        if (dados.getCodigoAutorizacaoFusion() != null) {
            entrada.setCodigoAutorizacaoFusion(dados.getCodigoAutorizacaoFusion());
        }
        if (saida != null && saida.getCodigoPreAutorizacao() != null && saida.getCodigoPreAutorizacao().length() > 0) {
            entrada.setCodigoPreAutorizacao(saida.getCodigoPreAutorizacao());
        }
        if (periferico.getPin() != null && conBaixaTecnica.isBaixaTecnicaSolicitada()) {
            entrada.setFlagBaixaTecnicaVisanet('1');
            entrada.setDadosGeraisPin(conBaixaTecnica.montaDadosGeraisPin());
            entrada.setVersaoAc(ControladorConfCTFClient.getInstance().getConfig().getVersaoAC());
            conBaixaTecnica.persisteBaixaTecnica();
        }
        LayoutDisplay layoutDisplay = new LayoutDisplay();
        Iterator iteMensagens = this.getListMensagensSolicitacao().iterator();
        while (iteMensagens.hasNext()) {
            layoutDisplay.addLinha(new Linha((String)iteMensagens.next()));
        }
        periferico.imprimeDisplay(layoutDisplay);
        IdentApiTefC ident = new IdentApiTefC();
        ident.setNumeroEstabelecimento(conf.getEstabelecimento());
        ident.setNumeroLoja(conf.getLoja());
        ident.setNumeroPdv(conf.getTerminal());
        ident.setNumeroSites(String.valueOf(conf.getNumeroSites()));
        ident.setListaIP(conf.getIps());
        ident.setQuantidadeVias(conf.getQuantidadeVias());
        entrada.setNumeroCupom(dados.getNumeroCupom());
        if (saida != null) {
            entrada.setIndiceMasterKey(dados.getSaidaApiTef().getIndiceMasterKey());
        }
        dados.setEntradaApiTef(entrada);
        saida = dados.getApitef().solicitacao(ident, entrada);
        dados.setSaidaApiTef(saida);
        if (saida.getRetorno() == 0) {
            VerifyContentUtil.preencheDadosSaida(dados, saida);
            return SUCCESS;
        }
        if (saida.getCodigoRespostaAutorizadora().equals("001")) {
            dados.setListInformacoesAdicionais(null);
            entrada.setFlagPerguntasAdicionais('1');
            return REFAZER_PERGUNTAS;
        }
        if (saida.getCodigoRespostaAutorizadora().equals("0XA")) {
            entrada.setFlagPerguntasAdicionais('2');
            if (saida.getValorTransacao() != null) {
                dados.setValorTransacao(saida.getValorTransacao());
            }
            if (entrada.isSenhaCapturada()) {
                return REFAZER_TRANSACAO;
            }
            return CAPTURAR_SENHA;
        }
        this.logger.log((Priority)Level.INFO, (Object)("Resposta autorizadora: " + saida.getCodigoRespostaAutorizadora()));
        return ERROR;
    }

    protected String getCodigoTransacao(IConvenioCombustivelShell dados) throws IllegalStateException {
        if ("OPE_CONVENIO_COMBUSTIVEL_PRE_VALIDACAO".equals(dados.getTipoOperacao())) {
            return "6N";
        }
        if ("OPE_CONVENIO_COMBUSTIVEL_AUTORIZACAO".equals(dados.getTipoOperacao())) {
            if (dados.isPosAutorizado()) {
                return "6P";
            }
            return "6O";
        }
        throw new IllegalStateException("Codigo da transa\u00e7\u00e3o n\u00e3o encotrada");
    }

    protected List getListMensagensSolicitacao() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.inter.getMessage("ENVTRA_SOLICITACAO1"));
        list.add(this.inter.getMessage("ENVTRA_SOLICITACAO2"));
        list.add(this.inter.getMessage("ENVTRA_SOLICITACAO3"));
        return list;
    }
}

