/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.IdentApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.IDadosTransacaoCorrespondenteBancario;
import com.csi.ctfclient.operacoes.model.CorrespondenteBancario;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.util.VerifyContentUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import java.math.BigDecimal;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class MicSolicitacaoCorrespondenteBancario {
    public static final String SUCESS = "SUCESS";
    public static final String ERRO_TRANS_JA_EFETUADA = "ERRO_TRANS_JA_EFETUADA";
    public static final String CREDITO_REFERIDO = "CREDITO_REFERIDO";
    public static final String ERRO_NAO_AUT_CARTAO = "ERRO_NAO_AUT_CARTAO";
    public static final String ERROR = "ERROR";
    private Logger logger = CTFClientLogger.getCTFClient();

    public String execute(IDadosTransacaoCorrespondenteBancario dados) throws ExcecaoApiAc {
        boolean connectedPin;
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        EntradaApiTefC entrada = new EntradaApiTefC();
        SaidaApiTefC saida = dados.getSaidaApiTef();
        ControladorPerifericos periferico = dados.getPerifericos();
        String codigoTransacao = this.getCodigoTransacao(dados);
        int modoEntrada = dados.getModoEntradaCodigoBarras();
        String entradaCorrespondenteBancario = CorrespondenteBancario.montaEntrada(modoEntrada, dados.getCodigoBarras(), dados.getTipoPagamento());
        if (dados.getDataVencimentoCorBan() != null) {
            entrada.setDataVencimento(dados.getDataVencimentoCorBan());
        }
        entrada.setInfo(entradaCorrespondenteBancario);
        int timeout = dados.getSaidaApiTef() != null ? dados.getSaidaApiTef().getTimeOutCTF() : 15;
        entrada.setTimeoutCtf(timeout);
        if (dados.getCmc7() != null) {
            entrada.setAdicionais(dados.getCmc7());
        }
        if (dados.getEntradaIntegracao() != null) {
            entrada.setDataCliente(dados.getEntradaIntegracao().getDataAbertura());
        } else {
            entrada.setDataCliente(dados.getStartProcess());
        }
        boolean bl = connectedPin = periferico.getPin() != null;
        if (connectedPin) {
            if (periferico.getPin().isBibliotecaEMV()) {
                entrada.setTipoPin("16");
            } else {
                entrada.setTipoPin("14");
            }
        } else {
            entrada.setTipoPin("**");
        }
        if (dados.getDataVencimentoCorBan() != null) {
            entrada.setDataVencimentoCorrespondenteBancario(dados.getDataVencimentoCorBan());
        }
        if (dados.getValorAcrescimo() != null) {
            entrada.setValorAcrescimo(dados.getValorAcrescimo());
        } else {
            entrada.setValorAcrescimo(new BigDecimal(0));
        }
        if (dados.getValorDesconto() != null) {
            entrada.setValorDesconto(dados.getValorDesconto());
        } else {
            entrada.setValorDesconto(new BigDecimal(0));
        }
        entrada.setValorTransacao(dados.getValorTransacao());
        entrada.setNumeroTransacao(dados.getNumeroTransacao());
        entrada.setOperacao(codigoTransacao);
        String msg1 = null;
        String msg2 = null;
        String msg3 = null;
        if ("OPERACAO CORRESPONDENTE BANCARIO CONSULTA CONVENIO".equals(dados.getTipoOperacao()) || "OPERACAO CORRESPONDENTE BANCARIO CONSULTA TITULO".equals(dados.getTipoOperacao())) {
            msg1 = inter.getMessage("SOLCORBAN_SOLICITACAO_CONSULTA1");
            msg2 = inter.getMessage("SOLCORBAN_SOLICITACAO_CONSULTA2");
            msg3 = inter.getMessage("SOLCORBAN_SOLICITACAO_CONSULTA3");
        } else {
            msg1 = inter.getMessage("ENVTRA_SOLICITACAO1");
            msg2 = inter.getMessage("ENVTRA_SOLICITACAO2");
            msg3 = inter.getMessage("ENVTRA_SOLICITACAO3");
        }
        LayoutDisplay displayModel = new LayoutDisplay();
        displayModel.addLinha(new Linha(msg1));
        displayModel.addLinha(new Linha(msg2));
        displayModel.addLinha(new Linha(msg3));
        periferico.imprimeDisplay(displayModel);
        ConfCTFClient conf = ControladorConfCTFClient.getInstance().getConfig();
        IdentApiTefC ident = new IdentApiTefC();
        ident.setNumeroEstabelecimento(conf.getEstabelecimento());
        ident.setNumeroLoja(conf.getLoja());
        ident.setNumeroPdv(conf.getTerminal());
        ident.setNumeroSites(String.valueOf(conf.getNumeroSites()));
        ident.setListaIP(conf.getIps());
        ident.setQuantidadeVias(conf.getQuantidadeVias());
        dados.setEntradaApiTef(entrada);
        saida = dados.getApitef().solicitacao(ident, entrada);
        dados.setSaidaApiTef(saida);
        if (saida.getRetorno() != 0) {
            this.logger.log((Priority)Level.INFO, (Object)("Resposta autorizadora: " + saida.getCodigoRespostaAutorizadora()));
            if (saida.getCodigoRespostaAutorizadora().equals("0ER")) {
                return ERRO_TRANS_JA_EFETUADA;
            }
            if (saida.getCodigoRespostaAutorizadora().equals("077") && saida.isConfirnacaoPositiva()) {
                return CREDITO_REFERIDO;
            }
            if (saida.getCodigoRespostaAutorizadora().equals("0F5")) {
                return ERRO_NAO_AUT_CARTAO;
            }
            return ERROR;
        }
        VerifyContentUtil.preencheDadosSaida(dados, saida);
        dados.setCorrespondenteBancario(CorrespondenteBancario.createCorrespondenteBancario(saida.getAdicionais()));
        if (dados.getTipoOperacao().equals("OPERACAO CORRESPONDENTE BANCARIO CONSULTA TITULO") || dados.getTipoOperacao().equals("OPERACAO CORRESPONDENTE BANCARIO CONSULTA CONVENIO")) {
            if (saida.getValorDesconto() != null) {
                dados.setValorDesconto(saida.getValorDesconto());
            }
            if (saida.getValorAcrescimo() != null) {
                dados.setValorAcrescimo(saida.getValorAcrescimo());
            }
        }
        return SUCESS;
    }

    private String getCodigoTransacao(IDadosTransacaoCorrespondenteBancario dados) {
        if (dados.getTipoOperacao().equals("OPERACAO CORRESPONDENTE BANCARIO CONSULTA TITULO")) {
            return "E4";
        }
        if (dados.getTipoOperacao().equals("OPERACAO CORRESPONDENTE BANCARIO CONSULTA CONVENIO")) {
            return "E5";
        }
        if (dados.getTipoOperacao().equals("OPERACAO CORRESPONDENTE BANCARIO PAGAMENTO TITULO")) {
            return "E6";
        }
        if (dados.getTipoOperacao().equals("OPERACAO CORRESPONDENTE BANCARIO PAGAMENTO CONVENIO")) {
            return "E7";
        }
        if (dados.getTipoOperacao().equals("OPERACAO CORRESPONDENTE BANCARIO CONSULTA E PAGAMENTO TITULO")) {
            return "E6";
        }
        if (dados.getTipoOperacao().equals("OPERACAO CORRESPONDENTE BANCARIO CONSULTA E PAGAMENTO CONVENIO")) {
            return "E7";
        }
        throw new IllegalStateException("Codigo da transa\u00e7\u00e3o n\u00e3o encotrada");
    }
}

