/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.IdentApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.ControladorBaixaTecnica;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.IProcessCrediario;
import com.csi.ctfclient.operacoes.model.AbstractCartao;
import com.csi.ctfclient.operacoes.model.CartaoChip;
import com.csi.ctfclient.operacoes.model.CartaoDigitado;
import com.csi.ctfclient.operacoes.model.CartaoMagnetico;
import com.csi.ctfclient.operacoes.model.GetInfo;
import com.csi.ctfclient.operacoes.model.PinInfo;
import com.csi.ctfclient.operacoes.model.PlanoCrediario;
import com.csi.ctfclient.operacoes.model.Produto;
import com.csi.ctfclient.operacoes.model.TabelaCriptografia;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.emvfull.ProtocoloBibliotecaCompartilhada;
import com.csi.ctfclient.tools.util.VerifyContentUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;

public class MicSolicitacaoCrediario {
    public static final String SUCESS = "SUCESS";
    public static final String ERRO = "ERRO";
    public static final String ERRO_REJEITADO_AUTORIZADORA = "ERRO_REJEITADO_AUTORIZADORA";
    public static final String ERRO_NAO_AUT_CARTAO = "ERRO_NAO_AUT_CARTAO";

    public String execute(IProcessCrediario dados) throws ExcecaoApiAc {
        TabelaCriptografia tabelaCriptografia;
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ControladorPerifericos periferico = dados.getPerifericos();
        ControladorBaixaTecnica conBaixaTecnica = ControladorBaixaTecnica.getInstance();
        EntradaApiTefC entrada = new EntradaApiTefC();
        SaidaApiTefC saida = dados.getSaidaApiTef();
        entrada.setNumeroTransacao(dados.getNumeroTransacao());
        entrada.setOperacao(this.getCodigoTransacao(dados));
        if (dados.getProdutoDinamico() != null) {
            Produto produto = dados.getProdutoDinamico();
            entrada.setCodigoProduto(produto.getCodigo());
            entrada.setCodigoBandeira(produto.getCodigoBandeira());
            entrada.setFluxoTef(produto.getKeyFluxo());
        } else {
            entrada.setCodigoProduto(0);
        }
        entrada.setValorTransacao(dados.getValorTransacao());
        entrada.setDataCliente(dados.getStartProcess());
        if (periferico.getPin() != null) {
            if (periferico.getPin().isBibliotecaEMV()) {
                if (dados.getDadosGetInfo() != null) {
                    GetInfo dadoGetInfo = dados.getDadosGetInfo();
                    entrada.setNumeroSeriePin(dadoGetInfo.getNumeroSerie());
                    entrada.setRetornoGetInfo(dadoGetInfo.getCodigoRetorno());
                    entrada.setVersaoBibliotecaCompartilhada(dadoGetInfo.getVersaoBibliotecaCompartilhada());
                    entrada.setVersaoEspecificacao(dadoGetInfo.getVersaoEspecificao());
                    entrada.setVersaoAplicacaoBasica(dadoGetInfo.getVersaoAplicacao());
                    entrada.setVersaoBibliotecaRedeEMV(dadoGetInfo.getVersaoBibRede4());
                    entrada.setFabricantePinpad(dadoGetInfo.getFabricante());
                    entrada.setModeloHardware(dadoGetInfo.getModeloHardware());
                    entrada.setVersaoRedeAdquirente(dadoGetInfo.getVersaoRedeAdquirente());
                    entrada.setVersaoKernelEMV(dadoGetInfo.getVersaoKernelEMV());
                }
                entrada.setDadosVisanetPin(conBaixaTecnica.montaDadosVisaNetPin());
                entrada.setTipoPin("16");
            } else {
                entrada.setTipoPin("14");
            }
        } else {
            entrada.setTipoPin("**");
        }
        entrada.setTimeoutCtf(saida.getTimeOutCTF());
        if (dados.getTaxaEmbarque() != null) {
            entrada.setValorTaxaEmbarque(dados.getTaxaEmbarque().getValorEmbarque());
        }
        if (dados.getServico() != null) {
            entrada.setValorTaxaServico(dados.getServico().getValorServico());
        }
        if (dados.getCodigoSeguranca() != null) {
            entrada.setCvv2(dados.getCodigoSeguranca().getCodigo());
            if (dados.getCodigoSeguranca().getCodigo().length() == 0) {
                if (dados.getCodigoSeguranca().getMotivo() == 0) {
                    entrada.setMotivoCVV2('2');
                } else {
                    entrada.setMotivoCVV2('9');
                }
            } else {
                entrada.setCvv2(dados.getCodigoSeguranca().getCodigo());
            }
        }
        if (dados.getTipoFinanciamento() instanceof PlanoCrediario) {
            PlanoCrediario planoCrediario = (PlanoCrediario)dados.getTipoFinanciamento();
            entrada.setNumeroParcelas(planoCrediario.getNumeroParcela());
            if (planoCrediario.getData1parcela() != null) {
                entrada.setDataVencimento(planoCrediario.getData1parcela());
            }
            if (planoCrediario.getValorEntrada() != null) {
                entrada.setValorEntrada(planoCrediario.getValorEntrada());
            }
            if (planoCrediario.getValorParcela() != null) {
                entrada.setValorParcela(planoCrediario.getValorParcela());
            }
        }
        entrada.setRetornoBibliotecaCompartilhada(dados.getLastErrorCode());
        if (!(dados.getCartao() instanceof CartaoDigitado)) {
            AbstractCartao cartao = (AbstractCartao)dados.getCartao();
            if (cartao.getNomePortador() != null && !cartao.getNomePortador().equals("")) {
                entrada.setNomeCliente(cartao.getNomePortador());
            }
            entrada.setStatusChip(cartao.getStatusUltimaLeitura());
            entrada.setTipoCartao(cartao.getTipoCartao());
            entrada.setIssuerCountryCode(cartao.getIssuerCountry());
            entrada.setWFlags(cartao.getFlags());
            if (cartao.getTrilha1() != null) {
                entrada.setTrilha1(cartao.getTrilha1());
            }
            if (cartao.getTrilha2() != null) {
                entrada.setInfo(cartao.getTrilha2());
            }
            if (dados.getSaidaApiTef().isCriptografiaCartao()) {
                if (cartao.getTrilha1Criptografado() != null) {
                    entrada.setTrilha1Criptografada(cartao.getTrilha1Criptografado());
                }
                if (cartao.getTrilha2Criptografado() != null) {
                    entrada.setTrilha2Criptografada(cartao.getTrilha2Criptografado());
                }
            }
            entrada.setPAN(cartao.getNumero());
            if (cartao.getNumeroCriptografado() != null) {
                entrada.setCartaoCriptografado(cartao.getNumeroCriptografado());
            }
        }
        if (dados.getCartao() instanceof CartaoMagnetico) {
            entrada.setModoEntrada(2);
        } else if (dados.getCartao() instanceof CartaoChip) {
            CartaoChip cartaoChip = (CartaoChip)dados.getCartao();
            entrada.setModoEntrada(5);
            entrada.setNumeroAplicacao(cartaoChip.getNumero());
            entrada.setIndiceAid(cartaoChip.getIndiceRegistroAID());
            entrada.setCodigoRedeAdquirenteChip(cartaoChip.getTipoRedeAdquirente());
            entrada.setCardSequenceNumber(cartaoChip.getPanSequenceNumber());
            entrada.setTipoAplicacaoChip(cartaoChip.getTipoAplicacao());
        } else if (dados.getCartao() instanceof CartaoDigitado) {
            CartaoDigitado cartaoDigitado = (CartaoDigitado)dados.getCartao();
            entrada.setModoEntrada(1);
            entrada.setInfo(cartaoDigitado.getNumero());
            if (dados.getSaidaApiTef().isCriptografiaCartao()) {
                entrada.setCartaoCriptografado(cartaoDigitado.getNumeroCriptografado());
            }
            entrada.setPAN(cartaoDigitado.getNumero());
            if (cartaoDigitado.getNumeroCriptografado() != null) {
                entrada.setCartaoCriptografado(cartaoDigitado.getNumeroCriptografado());
            }
        }
        PinInfo pinInfo = dados.getPinInfo();
        if (pinInfo != null) {
            entrada.setSenhaOfflineChip(pinInfo.isVerificadoOffline());
            entrada.setAssinaturaChip(pinInfo.isRequerAssinatura());
            entrada.setDecisaoChip(pinInfo.getDecisaoTomada());
            if (!(dados.getCartao() instanceof CartaoChip) || dados.getCartao() instanceof CartaoChip && pinInfo.isCapturadoVerificacaoOnline() || !ProtocoloBibliotecaCompartilhada.isBibliotecaEMV()) {
                entrada.setSenha(pinInfo.getPinCriptografado());
                if (dados.getNumeroSerieChaveDUKPTSenha() != null) {
                    entrada.setNumeroSerieChaveSenha(dados.getNumeroSerieChaveDUKPTSenha());
                }
            }
            if (dados.getStatusComunicacaoHost() != null && dados.getStatusComunicacaoHost() == 1) {
                EntradaApiTefC entradaFinishChip = dados.getEntradaApiTef();
                entrada.setDadosFinaisChip(entradaFinishChip.getDadosFinaisChip());
            } else if (pinInfo.getDadosCampo55() != null) {
                entrada.setDadosChip(pinInfo.getDadosCampo55());
            }
        }
        if ((tabelaCriptografia = dados.getTabelaCriptografia()) != null) {
            entrada.setMetodoCriptografiaSenha(tabelaCriptografia.getCriptografiaSenhaPrincipal().getAlgoritmo());
            if (tabelaCriptografia.getCriptografiaDadosPrincipal() != null) {
                entrada.setMetodoCriptografiaDados(tabelaCriptografia.getCriptografiaDadosPrincipal().getAlgoritmo());
            }
        }
        if (periferico.getPin() != null && conBaixaTecnica.isBaixaTecnicaSolicitada()) {
            entrada.setFlagBaixaTecnicaVisanet('1');
            entrada.setDadosGeraisPin(conBaixaTecnica.montaDadosGeraisPin());
            entrada.setVersaoAc(ControladorConfCTFClient.getInstance().getConfig().getVersaoAC());
            conBaixaTecnica.persisteBaixaTecnica();
        }
        if (dados.getSaidaApiTef().isReenvioNegadaHost()) {
            if (dados.getEntradaApiTef().getDadosFinaisChip() != null) {
                entrada.setDadosFinaisChip(dados.getEntradaApiTef().getDadosFinaisChip());
            }
            if (dados.getEntradaApiTef().getIssuerScriptResult() != null) {
                entrada.setIssuerScriptResult(dados.getEntradaApiTef().getIssuerScriptResult());
            }
        } else {
            LayoutDisplay displayModel = new LayoutDisplay(inter.getMessage("SOLCONCDC_SOLICITACAO"));
            periferico.imprimeDisplay(displayModel);
        }
        ConfCTFClient conf = ControladorConfCTFClient.getInstance().getConfig();
        IdentApiTefC ident = new IdentApiTefC();
        ident.setNumeroEstabelecimento(conf.getEstabelecimento());
        ident.setNumeroLoja(conf.getLoja());
        ident.setNumeroPdv(conf.getTerminal());
        ident.setNumeroSites(String.valueOf(conf.getNumeroSites()));
        ident.setListaIP(conf.getIps());
        ident.setQuantidadeVias(conf.getQuantidadeVias());
        entrada.setIndiceMasterKey(dados.getSaidaApiTef().getIndiceMasterKey());
        saida = dados.getApitef().solicitacao(ident, entrada);
        if (!dados.getSaidaApiTef().isReenvioNegadaHost()) {
            dados.setEntradaApiTef(entrada);
            dados.setSaidaApiTef(saida);
            if (saida.getRetorno() != 0) {
                if (saida.getCodigoRespostaAutorizadora().equals("0F5")) {
                    return ERRO_NAO_AUT_CARTAO;
                }
                return ERRO;
            }
            VerifyContentUtil.preencheDadosSaida(dados, saida);
            if (saida.getFlagBaixaTecnica() == '1' || saida.getFlagBaixaTecnica() == '2') {
                conBaixaTecnica.persisteBaixaTecnica();
            }
            return SUCESS;
        }
        return SUCESS;
    }

    protected String getCodigoTransacao(IProcessCrediario dado) throws IllegalStateException {
        if ("OPE_DEBITO_CREDIARIO".equals(dado.getTipoOperacao())) {
            return "GB";
        }
        if ("OPE_CREDITO_CREDIARIO".equals(dado.getTipoOperacao())) {
            return "1S";
        }
        throw new IllegalStateException("Codigo da transa\u00e7\u00e3o n\u00e3o encotrada");
    }
}

