/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.IdentApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.IDadosCreditoCelular;
import com.csi.ctfclient.operacoes.model.DadosSolicitacaoCreditoDigital;
import com.csi.ctfclient.operacoes.model.Plano;
import com.csi.ctfclient.operacoes.model.PlanoAPrazo;
import com.csi.ctfclient.operacoes.model.PlanoAVista;
import com.csi.ctfclient.operacoes.model.PlanoAdministradora;
import com.csi.ctfclient.operacoes.model.PlanoFinanciadoLojista;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.devices.emv.SaidaGetInfoEMV;
import com.csi.ctfclient.tools.util.VerifyContentUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class MicSolicitacaoCreditoCelular {
    public static final String SUCESS = "SUCESS";
    public static final String ERROR = "ERROR";
    private Logger logger = CTFClientLogger.getCTFClient();

    public String execute(IDadosCreditoCelular dados) throws ExcecaoApiAc {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ConfCTFClient conf = ControladorConfCTFClient.getInstance().getConfig();
        ControladorPerifericos periferico = dados.getPerifericos();
        EntradaApiTefC entrada = new EntradaApiTefC();
        DadosSolicitacaoCreditoDigital creditoDigital = new DadosSolicitacaoCreditoDigital();
        if (dados.getOperadoraTelefonia() != null) {
            String operadoraTelefonia = dados.getOperadoraTelefonia().getAutorizadora();
            creditoDigital.setCodigoAutorizadora(operadoraTelefonia);
            entrada.setCodigoAutorizadora(operadoraTelefonia);
        }
        creditoDigital.setDdd(dados.getDDD());
        creditoDigital.setTelefone(dados.getTelefone());
        if (dados.getOperadoraTelefonia() != null && dados.getOperadoraTelefonia().isDigito()) {
            creditoDigital.setDigitoVerificadortelefone(dados.getDigitoVerificadorTelefone());
        }
        creditoDigital.setCodigoUsuarioPdv(dados.getCodigoUsuarioPdv());
        creditoDigital.setTipoCreditoCompra(dados.getTipoCreditoCompra());
        creditoDigital.setVersaoLayout(conf.getVersaoLayoutCD());
        entrada.setDadosCreditoDigital(creditoDigital);
        entrada.setNumeroTransacao(dados.getNumeroTransacao());
        entrada.setOperacao(this.getCodigoTransacao(dados));
        entrada.setValorTransacao(dados.getValorTransacao());
        if (dados.getEntradaIntegracao() != null) {
            entrada.setDataCliente(dados.getEntradaIntegracao().getDataAbertura());
        } else {
            entrada.setDataCliente(dados.getStartProcess());
        }
        if (periferico.getPin() != null) {
            if (periferico.getPin().isBibliotecaEMV()) {
                SaidaGetInfoEMV getInfo = periferico.getPin().getInfo();
                if (getInfo != null) {
                    entrada.setNumeroSeriePin(getInfo.getNumSeriePinpad());
                    entrada.setRetornoGetInfo(getInfo.getRetorno());
                }
                entrada.setTipoPin("16");
            } else {
                entrada.setTipoPin("14");
            }
        } else {
            entrada.setTipoPin("**");
        }
        if (dados.getTipoFinanciamento() instanceof PlanoAPrazo) {
            PlanoAPrazo planoAPrazo = (PlanoAPrazo)dados.getTipoFinanciamento();
            entrada.setNumeroParcelas(planoAPrazo.getNumeroParcela());
        } else if (dados.getTipoFinanciamento() instanceof PlanoAVista) {
            entrada.setNumeroParcelas(1);
        } else {
            entrada.setNumeroParcelas(0);
        }
        entrada.setTimeoutCtf(200);
        LayoutDisplay displayModel = new LayoutDisplay();
        displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO1")));
        displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO2")));
        displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO3")));
        periferico.imprimeDisplay(displayModel);
        IdentApiTefC ident = new IdentApiTefC();
        ident.setNumeroEstabelecimento(conf.getEstabelecimento());
        ident.setNumeroLoja(conf.getLoja());
        ident.setNumeroPdv(conf.getTerminal());
        ident.setNumeroSites(String.valueOf(conf.getNumeroSites()));
        ident.setListaIP(conf.getIps());
        ident.setQuantidadeVias(conf.getQuantidadeVias());
        dados.setEntradaApiTef(entrada);
        SaidaApiTefC saida = dados.getApitef().solicitacao(ident, entrada);
        dados.setSaidaApiTef(saida);
        saida.setDDD(dados.getDDD());
        saida.setTelefone(dados.getTelefone());
        if (saida.getRetorno() != 0) {
            this.logger.log((Priority)Level.INFO, (Object)("Resposta autorizadora: " + saida.getCodigoRespostaAutorizadora()));
            return ERROR;
        }
        VerifyContentUtil.preencheDadosSaida(dados, saida);
        return SUCESS;
    }

    private String getCodigoTransacao(IDadosCreditoCelular dados) {
        Plano plano = dados.getTipoFinanciamento();
        if (plano instanceof PlanoAVista) {
            return "4J";
        }
        if (plano instanceof PlanoFinanciadoLojista) {
            return "4K";
        }
        if (plano instanceof PlanoAdministradora) {
            return "4L";
        }
        throw new IllegalStateException("Codigo da transa\u00e7\u00e3o n\u00e3o encotrada");
    }
}

