/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.IdentApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.IDadosTransacaoCreditoDigital;
import com.csi.ctfclient.operacoes.model.DadosSolicitacaoCreditoDigital;
import com.csi.ctfclient.servicos.IdentTerminal;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.devices.emv.SaidaGetInfoEMV;
import com.csi.ctfclient.tools.util.VerifyContentUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class MicSolicitacaoCreditoDigital {
    public static final String SUCESS = "SUCESS";
    public static final String ERROR = "ERROR";
    private Logger logger = CTFClientLogger.getCTFClient();

    public String execute(IDadosTransacaoCreditoDigital dados) throws ExcecaoApiAc {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ConfCTFClient conf = ControladorConfCTFClient.getInstance().getConfig();
        ControladorPerifericos periferico = dados.getPerifericos();
        boolean multiTerminal = dados.getEntradaIntegracao() != null && dados.getEntradaIntegracao().isMultiTerminal();
        EntradaApiTefC entrada = new EntradaApiTefC();
        DadosSolicitacaoCreditoDigital creditoDigital = new DadosSolicitacaoCreditoDigital();
        creditoDigital.setCodigoAutorizadora(dados.getOperadoraTelefonia().getAutorizadora());
        creditoDigital.setDdd(dados.getDDD());
        creditoDigital.setTelefone(dados.getTelefone());
        if ("COMPRA DE CREDITO DIGITAL".equals(dados.getTipoOperacao())) {
            if (dados.getOperadoraTelefonia().isDigito()) {
                creditoDigital.setDigitoVerificadortelefone(dados.getDigitoVerificadorTelefone());
            }
            entrada.setValorTransacao(dados.getValorTransacao());
        } else {
            creditoDigital.setDigitoVerificadortelefone(0);
        }
        creditoDigital.setCodigoUsuarioPdv(dados.getCodigoUsuarioPdv());
        creditoDigital.setTipoCreditoCompra(dados.getTipoCreditoCompra());
        creditoDigital.setVersaoLayout(conf.getVersaoLayoutCD());
        entrada.setDadosCreditoDigital(creditoDigital);
        if (dados.getOperadoraTelefonia().getCodigo() != null) {
            entrada.setOperadora(dados.getOperadoraTelefonia().getCodigo());
        }
        entrada.setNumeroTransacao(dados.getNumeroTransacao());
        entrada.setOperacao(this.getCodigoTransacao(dados));
        if (dados.getEntradaIntegracao() != null) {
            entrada.setDataCliente(dados.getEntradaIntegracao().getDataAbertura());
        } else {
            entrada.setDataCliente(dados.getStartProcess());
        }
        if (!multiTerminal) {
            if (periferico.getPin() != null) {
                if (periferico.getPin().isBibliotecaEMV()) {
                    SaidaGetInfoEMV getInfo = periferico.getPin().getInfo();
                    if (getInfo != null) {
                        entrada.setNumeroSeriePin(getInfo.getNumSeriePinpad());
                        entrada.setRetornoGetInfo(getInfo.getRetorno());
                    }
                    entrada.setTipoPin("16");
                } else {
                    entrada.setTipoPin("14");
                }
            } else {
                entrada.setTipoPin("**");
            }
            entrada.setTimeoutCtf(35);
            String msg1 = null;
            String msg2 = null;
            String msg3 = null;
            if ("CONSULTA DE CREDITO DIGITAL".equals(dados.getTipoOperacao())) {
                msg1 = "SOLCREDIG_SOLICITACAO_CONSULTA1";
                msg2 = "SOLCREDIG_SOLICITACAO_CONSULTA2";
                msg3 = "SOLCREDIG_SOLICITACAO_CONSULTA3";
            } else if ("COMPRA DE CREDITO DIGITAL".equals(dados.getTipoOperacao())) {
                msg1 = "ENVTRA_SOLICITACAO1";
                msg2 = "ENVTRA_SOLICITACAO2";
                msg3 = "ENVTRA_SOLICITACAO3";
            }
            LayoutDisplay displayModel = new LayoutDisplay();
            displayModel.addLinha(new Linha(inter.getMessage(msg1)));
            displayModel.addLinha(new Linha(inter.getMessage(msg2)));
            displayModel.addLinha(new Linha(inter.getMessage(msg3)));
            periferico.imprimeDisplay(displayModel);
        }
        IdentApiTefC ident = new IdentApiTefC();
        IdentTerminal identTerminal = null;
        identTerminal = multiTerminal ? dados.getEntradaIntegracao().getIdentTerminal() : new IdentTerminal(conf.getEstabelecimento(), conf.getLoja(), conf.getTerminal());
        ident.setNumeroEstabelecimento(identTerminal.getEstabelecimento());
        ident.setNumeroLoja(identTerminal.getLoja());
        ident.setNumeroPdv(identTerminal.getTerminal());
        ident.setNumeroSites(String.valueOf(conf.getNumeroSites()));
        ident.setListaIP(conf.getIps());
        ident.setQuantidadeVias(conf.getQuantidadeVias());
        dados.setEntradaApiTef(entrada);
        SaidaApiTefC saida = dados.getApitef().solicitacao(ident, entrada);
        dados.setSaidaApiTef(saida);
        saida.setOperadoraTelefonia(dados.getOperadoraTelefonia().getAutorizadora());
        saida.setDDD(dados.getDDD());
        saida.setTelefone(dados.getTelefone());
        entrada.setNumeroCupom(dados.getNumeroCupom());
        if (saida.getRetorno() != 0) {
            this.logger.log((Priority)Level.INFO, (Object)("Resposta autorizadora: " + saida.getCodigoRespostaAutorizadora()));
            return ERROR;
        }
        VerifyContentUtil.preencheDadosSaida(dados, saida);
        return SUCESS;
    }

    private String getCodigoTransacao(IDadosTransacaoCreditoDigital dados) {
        if ("CONSULTA DE CREDITO DIGITAL".equals(dados.getTipoOperacao())) {
            return "F4";
        }
        if ("COMPRA DE CREDITO DIGITAL".equals(dados.getTipoOperacao())) {
            return "F5";
        }
        throw new IllegalStateException("Codigo da transa\u00e7\u00e3o n\u00e3o encotrada");
    }
}

