/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.IdentApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.ControladorBaixaTecnica;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.IProcessDebito;
import com.csi.ctfclient.operacoes.model.AbstractCartao;
import com.csi.ctfclient.operacoes.model.CartaoChip;
import com.csi.ctfclient.operacoes.model.CartaoDigitado;
import com.csi.ctfclient.operacoes.model.CartaoMagnetico;
import com.csi.ctfclient.operacoes.model.GetInfo;
import com.csi.ctfclient.operacoes.model.PinInfo;
import com.csi.ctfclient.operacoes.model.PlanoAVista;
import com.csi.ctfclient.operacoes.model.PlanoCDC;
import com.csi.ctfclient.operacoes.model.PlanoParcelado;
import com.csi.ctfclient.operacoes.model.PlanoPreDatado;
import com.csi.ctfclient.operacoes.model.Produto;
import com.csi.ctfclient.operacoes.model.TabelaCriptografia;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.devices.emv.PinEMV;
import com.csi.ctfclient.tools.devices.emvfull.ProtocoloBibliotecaCompartilhada;
import com.csi.ctfclient.tools.util.DateUtil;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.VerifyContentUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class MicSolicitacaoDebito {
    public static final String SUCESS = "SUCESS";
    public static final String ERRO = "ERRO";
    public static final String ERRO_REJEITADO_AUTORIZADORA = "ERRO_REJEITADO_AUTORIZADORA";
    public static final String ERRO_TRANS_JA_EFETUADA = "ERRO_TRANS_JA_EFETUADA";
    public static final String ERRO_NAO_AUT_CARTAO = "ERRO_NAO_AUT_CARTAO";
    private Logger logger = CTFClientLogger.getCTFClient();

    public String execute(IProcessDebito dados) throws ExcecaoApiAc {
        PinEMV pinEMV;
        boolean connectedPin;
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ControladorPerifericos periferico = dados.getPerifericos();
        ControladorBaixaTecnica conBaixaTecnica = ControladorBaixaTecnica.getInstance();
        EntradaApiTefC entrada = new EntradaApiTefC();
        SaidaApiTefC saida = dados.getSaidaApiTef();
        entrada.setNumeroTransacao(dados.getNumeroTransacao());
        entrada.setOperacao(this.getCodigoTransacao(dados));
        if (dados.getProdutoDinamico() != null) {
            Produto produto = dados.getProdutoDinamico();
            entrada.setCodigoProduto(produto.getCodigo());
            entrada.setCodigoBandeira(produto.getCodigoBandeira());
            entrada.setFluxoTef(produto.getKeyFluxo());
        } else {
            entrada.setCodigoProduto(0);
        }
        entrada.setValorTransacao(dados.getValorTransacao());
        if (dados.getEntradaIntegracao() != null) {
            entrada.setDataCliente(dados.getEntradaIntegracao().getDataAbertura());
            if (dados.getEntradaIntegracao().getTipoProduto() != null) {
                entrada.setTipoProduto(dados.getEntradaIntegracao().getTipoProduto());
            }
        } else {
            entrada.setDataCliente(dados.getStartProcess());
        }
        boolean bl = connectedPin = (pinEMV = periferico.getPin()) != null;
        if (connectedPin) {
            if (pinEMV.isBibliotecaEMV()) {
                if (dados.getDadosGetInfo() != null) {
                    GetInfo dadoGetInfo = dados.getDadosGetInfo();
                    entrada.setNumeroSeriePin(dadoGetInfo.getNumeroSerie());
                    entrada.setRetornoGetInfo(dadoGetInfo.getCodigoRetorno());
                    entrada.setVersaoBibliotecaCompartilhada(dadoGetInfo.getVersaoBibliotecaCompartilhada());
                    entrada.setVersaoEspecificacao(dadoGetInfo.getVersaoEspecificao());
                    entrada.setVersaoAplicacaoBasica(dadoGetInfo.getVersaoAplicacao());
                    entrada.setVersaoBibliotecaRedeEMV(dadoGetInfo.getVersaoBibRede4());
                    entrada.setFabricantePinpad(dadoGetInfo.getFabricante());
                    entrada.setModeloHardware(dadoGetInfo.getModeloHardware());
                    entrada.setVersaoRedeAdquirente(dadoGetInfo.getVersaoRedeAdquirente());
                    entrada.setVersaoKernelEMV(dadoGetInfo.getVersaoKernelEMV());
                }
                entrada.setDadosVisanetPin(conBaixaTecnica.montaDadosVisaNetPin());
                entrada.setTipoPin("16");
            } else {
                entrada.setTipoPin("14");
            }
        } else {
            entrada.setTipoPin("**");
        }
        entrada.setTimeoutCtf(saida.getTimeOutCTF());
        if (dados.getTaxaEmbarque() != null) {
            entrada.setValorTaxaEmbarque(dados.getTaxaEmbarque().getValorEmbarque());
        }
        if (dados.getServico() != null) {
            entrada.setValorTaxaServico(dados.getServico().getValorServico());
        }
        if (dados.getCodigoSeguranca() != null) {
            entrada.setCvv2(dados.getCodigoSeguranca().getCodigo());
            if (dados.getCodigoSeguranca().getCodigo().length() == 0) {
                if (dados.getCodigoSeguranca().getMotivo() == 0) {
                    entrada.setMotivoCVV2('2');
                } else {
                    entrada.setMotivoCVV2('9');
                }
            } else {
                entrada.setCvv2(dados.getCodigoSeguranca().getCodigo());
            }
        }
        if (dados.getTipoFinanciamento() instanceof PlanoCDC) {
            PlanoCDC planoCDC = (PlanoCDC)dados.getTipoFinanciamento();
            entrada.setNumeroParcelas(planoCDC.getNumeroParcela());
            if (planoCDC.getData1parcela() != null) {
                entrada.setDataVencimento(planoCDC.getData1parcela());
            }
            if (planoCDC.getValorEntrada() != null) {
                entrada.setValorEntrada(planoCDC.getValorEntrada());
            }
            if (planoCDC.getValorParcela() != null) {
                entrada.setValorParcela(planoCDC.getValorParcela());
            }
        } else if (dados.getTipoFinanciamento() instanceof PlanoParcelado) {
            PlanoParcelado planoParcelado = (PlanoParcelado)dados.getTipoFinanciamento();
            int numeroParcelas = planoParcelado.getNumeroParcela();
            entrada.setNumeroParcelas(numeroParcelas);
            BigDecimal valorTransacao = dados.getValorTransacao();
            BigDecimal valorParcela = valorTransacao.divide(new BigDecimal(numeroParcelas), 2, 6);
            BigDecimal totalTruncado = valorParcela.multiply(new BigDecimal(numeroParcelas));
            BigDecimal valor1Parcela = valorParcela.add(valorTransacao.subtract(totalTruncado));
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
            StringBuffer bit62Formatado = new StringBuffer();
            if (planoParcelado.getData1parcela() != null) {
                entrada.setDataVencimento(planoParcelado.getData1parcela());
                Calendar calendar = GregorianCalendar.getInstance();
                calendar.setTime(planoParcelado.getData1parcela());
                String dataFormatada = simpleDateFormat.format(calendar.getTime());
                String valorFormatado = valor1Parcela.movePointRight(2).toString();
                bit62Formatado.append(StringUtil.completaString(valorFormatado + dataFormatada, 20, '0', 3));
                for (int i = 0; i < numeroParcelas - 1; ++i) {
                    calendar.add(5, 30);
                    dataFormatada = simpleDateFormat.format(calendar.getTime());
                    valorFormatado = valorParcela.movePointRight(2).toString();
                    bit62Formatado.append(StringUtil.completaString(valorFormatado + dataFormatada, 20, '0', 3));
                }
                entrada.setAdicionais(bit62Formatado.toString());
            }
        } else if (dados.getTipoFinanciamento() instanceof PlanoPreDatado) {
            PlanoPreDatado planoPreDatado = (PlanoPreDatado)dados.getTipoFinanciamento();
            if (planoPreDatado.getDataAgendamento() != null) {
                String dataFormatada = new SimpleDateFormat("yyyyMMdd").format(planoPreDatado.getDataAgendamento());
                String valorFormatado = dados.getValorTransacao().movePointRight(2).toString();
                String bit62Formatado = StringUtil.completaString(valorFormatado + dataFormatada, 20, '0', 3);
                entrada.setAdicionais(bit62Formatado);
                entrada.setDataVencimento(planoPreDatado.getDataAgendamento());
            }
            if (planoPreDatado.getTipoGarantia() != -1) {
                entrada.setTipoGarantia(planoPreDatado.getTipoGarantia());
            }
        } else if (dados.getTipoFinanciamento() instanceof PlanoAVista) {
            PlanoAVista planoAVista = (PlanoAVista)dados.getTipoFinanciamento();
            if (planoAVista.getValorSaque() != null) {
                entrada.setValorCashBack(planoAVista.getValorSaque());
            }
            entrada.setNumeroParcelas(1);
        }
        entrada.setRetornoBibliotecaCompartilhada(dados.getLastErrorCode());
        if (!(dados.getCartao() instanceof CartaoDigitado)) {
            AbstractCartao cartao = (AbstractCartao)dados.getCartao();
            if (cartao.getNomePortador() != null && !cartao.getNomePortador().equals("")) {
                entrada.setNomeCliente(cartao.getNomePortador());
            }
            entrada.setStatusChip(cartao.getStatusUltimaLeitura());
            entrada.setTipoCartao(cartao.getTipoCartao());
            entrada.setIssuerCountryCode(cartao.getIssuerCountry());
            entrada.setWFlags(cartao.getFlags());
            if (cartao.getTrilha1() != null) {
                entrada.setTrilha1(cartao.getTrilha1());
            }
            if (cartao.getTrilha2() != null) {
                entrada.setInfo(cartao.getTrilha2());
            }
            if (cartao.getTrilha1Criptografado() != null) {
                entrada.setTrilha1Criptografada(cartao.getTrilha1Criptografado());
            }
            if (cartao.getTrilha2Criptografado() != null) {
                entrada.setTrilha2Criptografada(cartao.getTrilha2Criptografado());
            }
            entrada.setPAN(cartao.getNumero());
            if (cartao.getNumeroCriptografado() != null) {
                entrada.setCartaoCriptografado(cartao.getNumeroCriptografado());
            }
        }
        if (dados.getCartao() instanceof CartaoMagnetico) {
            entrada.setModoEntrada(2);
        } else if (dados.getCartao() instanceof CartaoChip) {
            CartaoChip cartaoChip = (CartaoChip)dados.getCartao();
            entrada.setModoEntrada(5);
            entrada.setNumeroAplicacao(cartaoChip.getNumero());
            entrada.setIndiceAid(cartaoChip.getIndiceRegistroAID());
            entrada.setCodigoRedeAdquirenteChip(cartaoChip.getTipoRedeAdquirente());
            entrada.setCardSequenceNumber(cartaoChip.getPanSequenceNumber());
            entrada.setTipoAplicacaoChip(cartaoChip.getTipoAplicacao());
            entrada.setApplicationExpirationDate(cartaoChip.getApplicationExpirationDate());
            entrada.setApplicationLabel(cartaoChip.getApplicationLabel());
        } else if (dados.getCartao() instanceof CartaoDigitado) {
            CartaoDigitado cartaoDigitado = (CartaoDigitado)dados.getCartao();
            entrada.setModoEntrada(1);
            entrada.setInfo(cartaoDigitado.getNumero());
            entrada.setPAN(cartaoDigitado.getNumero());
            if (cartaoDigitado.getNumeroCriptografado() != null) {
                entrada.setCartaoCriptografado(cartaoDigitado.getNumeroCriptografado());
            }
        }
        PinInfo pinInfo = dados.getPinInfo();
        if (pinInfo != null) {
            entrada.setSenhaOfflineChip(pinInfo.isVerificadoOffline());
            entrada.setAssinaturaChip(pinInfo.isRequerAssinatura());
            entrada.setChipBloqueadoOffline(pinInfo.isOfflineBloqueado());
            this.logger.log((Priority)Level.DEBUG, (Object)("Status comunica\u00e7\u00e3o host: " + dados.getStatusComunicacaoHost()));
            if (dados.getStatusComunicacaoHost() != null && dados.getStatusComunicacaoHost() == 1) {
                entrada.setDecisaoChip(StringUtil.completaString(pinInfo.getDecisaoFinishChip() + "", 1, ' ', 3).toCharArray()[0]);
                entrada.setStatusComunicacaoHost(dados.getStatusComunicacaoHost());
            } else {
                entrada.setDecisaoChip(pinInfo.getDecisaoTomada());
            }
            if (!(dados.getCartao() instanceof CartaoChip) || dados.getCartao() instanceof CartaoChip && pinInfo.isCapturadoVerificacaoOnline() || !ProtocoloBibliotecaCompartilhada.isBibliotecaEMV()) {
                entrada.setSenha(pinInfo.getPinCriptografado());
                if (dados.getNumeroSerieChaveDUKPTSenha() != null) {
                    entrada.setNumeroSerieChaveSenha(dados.getNumeroSerieChaveDUKPTSenha());
                }
            }
            if (dados.getStatusComunicacaoHost() != null && dados.getStatusComunicacaoHost() == 1) {
                EntradaApiTefC entradaFinishChip = dados.getEntradaApiTef();
                entrada.setDadosFinaisChip(entradaFinishChip.getDadosFinaisChip());
            } else if (pinInfo.getDadosCampo55() != null) {
                entrada.setDadosChip(pinInfo.getDadosCampo55());
            }
        }
        entrada.setInformacoesAdicionais(dados.getListInformacoesAdicionais());
        entrada.setConfirmacaoPositiva(dados.getDadosConfirmacaoPositiva());
        TabelaCriptografia tabelaCriptografia = dados.getTabelaCriptografia();
        if (tabelaCriptografia != null) {
            entrada.setMetodoCriptografiaSenha(tabelaCriptografia.getCriptografiaSenhaPrincipal().getAlgoritmo());
            if (tabelaCriptografia.getCriptografiaDadosPrincipal() != null) {
                entrada.setMetodoCriptografiaDados(tabelaCriptografia.getCriptografiaDadosPrincipal().getAlgoritmo());
            }
        }
        if (connectedPin && conBaixaTecnica.isBaixaTecnicaSolicitada()) {
            entrada.setFlagBaixaTecnicaVisanet('1');
            entrada.setDadosGeraisPin(conBaixaTecnica.montaDadosGeraisPin());
            entrada.setVersaoAc(ControladorConfCTFClient.getInstance().getConfig().getVersaoAC());
            conBaixaTecnica.persisteBaixaTecnica();
        }
        ConfCTFClient conf = ControladorConfCTFClient.getInstance().getConfig();
        entrada.setAcSuportaPlataformaPromocional(conf.isAcSuportaPlataformaPromocional());
        entrada.setClientSuportaPlataformaPromocional(true);
        if (dados.getSaidaApiTef().isReenvioNegadaHost()) {
            if (dados.getEntradaApiTef().getDadosFinaisChip() != null) {
                entrada.setDadosFinaisChip(dados.getEntradaApiTef().getDadosFinaisChip());
            }
            if (dados.getEntradaApiTef().getIssuerScriptResult() != null) {
                entrada.setIssuerScriptResult(dados.getEntradaApiTef().getIssuerScriptResult());
            }
        } else {
            LayoutDisplay displayModel = new LayoutDisplay();
            displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO1")));
            displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO2")));
            displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO3")));
            periferico.imprimeDisplay(displayModel);
        }
        IdentApiTefC ident = new IdentApiTefC();
        ident.setNumeroEstabelecimento(conf.getEstabelecimento());
        ident.setNumeroLoja(conf.getLoja());
        ident.setNumeroPdv(conf.getTerminal());
        ident.setNumeroSites(String.valueOf(conf.getNumeroSites()));
        ident.setListaIP(conf.getIps());
        ident.setQuantidadeVias(conf.getQuantidadeVias());
        entrada.setNumeroCupom(dados.getNumeroCupom());
        entrada.setIndiceMasterKey(saida.getIndiceMasterKey());
        if (connectedPin && !dados.getSaidaApiTef().isReenvioNegadaHost()) {
            pinEMV.setMsgDisplay(inter.getMessage("ENVIO_TITLE"));
        }
        saida = dados.getApitef().solicitacao(ident, entrada);
        if (!dados.getSaidaApiTef().isReenvioNegadaHost()) {
            dados.setEntradaApiTef(entrada);
            dados.setSaidaApiTef(saida);
            if (saida.getRetorno() != 0) {
                this.logger.log((Priority)Level.INFO, (Object)("Resposta autorizadora: " + saida.getCodigoRespostaAutorizadora()));
                if (saida.getCodigoRespostaAutorizadora().equals("0ER")) {
                    return ERRO_TRANS_JA_EFETUADA;
                }
                if (saida.getCodigoRespostaAutorizadora().equals("0F5")) {
                    return ERRO_NAO_AUT_CARTAO;
                }
                return ERRO;
            }
            VerifyContentUtil.preencheDadosSaida(dados, saida);
            return SUCESS;
        }
        return SUCESS;
    }

    protected String getCodigoTransacao(IProcessDebito dado) throws IllegalStateException {
        if ("OPERACAO DEBITO".equals(dado.getTipoOperacao())) {
            if (dado.getTipoFinanciamento() instanceof PlanoAVista) {
                return "10";
            }
            if (dado.getTipoFinanciamento() instanceof PlanoCDC) {
                PlanoCDC planoCDC = (PlanoCDC)dado.getTipoFinanciamento();
                Date now = dado.getStartProcess();
                if (DateUtil.equalsData(planoCDC.getData1parcela(), now)) {
                    return "5A";
                }
                return "5B";
            }
            if (dado.getTipoFinanciamento() instanceof PlanoParcelado) {
                PlanoParcelado planoParcelado = (PlanoParcelado)dado.getTipoFinanciamento();
                Date now = dado.getStartProcess();
                if (DateUtil.equalsData(planoParcelado.getData1parcela(), now)) {
                    return "28";
                }
                return "23";
            }
            if (dado.getTipoFinanciamento() instanceof PlanoPreDatado) {
                return "20";
            }
        }
        throw new IllegalStateException("Codigo da transa\u00e7\u00e3o n\u00e3o encotrada");
    }
}

