/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.IdentApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.ISolicitacaoDescontoProdutosPromocionais;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class MicSolicitacaoDescontoProdutosPromocionais {
    public static final String SUCCESS = "SUCCESS";
    public static final String ERROR = "ERROR";
    private Logger logger = CTFClientLogger.getCTFClient();

    public String execute(ISolicitacaoDescontoProdutosPromocionais dados) throws ExcecaoApiAc {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ControladorPerifericos periferico = dados.getPerifericos();
        EntradaApiTefC entrada = new EntradaApiTefC();
        entrada.setNumeroTransacao(dados.getNumeroTransacao());
        entrada.setOperacao(this.getCodigoTransacao(dados));
        entrada.setCodigoProduto(0);
        EntradaCTFClientCtrl entradaIntegracao = dados.getEntradaIntegracao();
        if (entradaIntegracao != null && entradaIntegracao.isMatriculaOperadorCtrl()) {
            entrada.setMatriculaOperador(entradaIntegracao.getMatriculaOperador());
        }
        entrada.setCpf(dados.getCpf());
        entrada.setDadosProdutosPromocionais(dados.getListProdutosPromocionais());
        if (entradaIntegracao != null) {
            entrada.setDataCliente(entradaIntegracao.getDataAbertura());
        } else {
            entrada.setDataCliente(dados.getStartProcess());
        }
        ConfCTFClient conf = ControladorConfCTFClient.getInstance().getConfig();
        if (conf.getTimeOutDefault() > 0) {
            entrada.setTimeoutCtf(conf.getTimeOutDefault());
        } else {
            entrada.setTimeoutCtf(15);
        }
        LayoutDisplay displayModel = new LayoutDisplay();
        displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO1")));
        displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO2")));
        displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO3")));
        periferico.imprimeDisplay(displayModel);
        IdentApiTefC ident = new IdentApiTefC();
        ident.setNumeroEstabelecimento(conf.getEstabelecimento());
        ident.setNumeroLoja(conf.getLoja());
        ident.setNumeroPdv(conf.getTerminal());
        ident.setNumeroSites(String.valueOf(conf.getNumeroSites()));
        ident.setListaIP(conf.getIps());
        ident.setQuantidadeVias(conf.getQuantidadeVias());
        entrada.setNumeroCupom(dados.getNumeroCupom());
        SaidaApiTefC saida = dados.getApitef().solicitacao(ident, entrada);
        dados.setEntradaApiTef(entrada);
        dados.setSaidaApiTef(saida);
        if (saida.getRetorno() != 0) {
            this.logger.log((Priority)Level.INFO, (Object)("Resposta autorizadora: " + saida.getCodigoRespostaAutorizadora()));
            return ERROR;
        }
        return SUCCESS;
    }

    protected String getCodigoTransacao(ISolicitacaoDescontoProdutosPromocionais dados) throws IllegalStateException {
        return "AG";
    }
}

