/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.IdentApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.IDadosTransacaoEstatistica;
import com.csi.ctfclient.operacoes.model.ControladorEstatistica;
import com.csi.ctfclient.operacoes.model.DadosEstatistica;
import com.csi.ctfclient.operacoes.model.ResumoEstatistica;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.servicos.IdentTerminal;
import com.csi.ctfclient.tools.devices.emv.SaidaGetInfoEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaGetInfoRedecardEMV;
import com.csi.ctfclient.tools.util.VerifyContentUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import org.apache.log4j.Logger;

public class MicSolicitacaoEstatistica {
    private static Logger logger = CTFClientLogger.getCTFClient();
    public static final String SUCESS = "SUCESS";
    public static final String ERROR_CTF = "ERROR_CTF";
    public static final String ERROR = "ERROR";
    private static final String OPERACAO = "2O";

    public String execute(IDadosTransacaoEstatistica dados) {
        EntradaApiTefC entrada = new EntradaApiTefC();
        ControladorPerifericos perifericos = dados.getPerifericos();
        try {
            boolean connectedPin;
            entrada.setOperacao(OPERACAO);
            ControladorEstatistica controladorEstatistica = ControladorEstatistica.getInstance();
            DadosEstatistica dadosEstatistica = controladorEstatistica.getDadosEstatistica();
            ResumoEstatistica resumoEstatistica = new ResumoEstatistica();
            boolean bl = connectedPin = perifericos.getPin() != null;
            if (connectedPin) {
                if (perifericos.getPin().isBibliotecaEMV()) {
                    SaidaGetInfoEMV pinInfo = perifericos.getPin().getInfo();
                    if (pinInfo != null) {
                        resumoEstatistica.setFabricantePinpad(pinInfo.getFabricante());
                        resumoEstatistica.setNumeroSeriePinpad(pinInfo.getNumSeriePinpad());
                        resumoEstatistica.setVersaoHardwarePinpad(pinInfo.getModeloHardware());
                        resumoEstatistica.setVersaoEspecificacao(pinInfo.getVersaoEspecificacao());
                        resumoEstatistica.setVersaoFirmwarePinpad(pinInfo.getVersaoFirmware());
                        resumoEstatistica.setVersaoAplBasica(pinInfo.getVersaoAplBasica());
                        SaidaGetInfoRedecardEMV infoRedecardEMV = perifericos.getPin().getInfoRedecard();
                        entrada.setVersaoBibliotecaCompartilhada(infoRedecardEMV.getInformacaoProprietaria());
                        resumoEstatistica.setVersaoKernelEMV(infoRedecardEMV.getVersaoKernelEMV());
                        entrada.setNumeroSeriePin(pinInfo.getNumSeriePinpad());
                        entrada.setRetornoGetInfo(pinInfo.getRetorno());
                    }
                    entrada.setTipoPin("16");
                } else {
                    entrada.setTipoPin("14");
                }
            } else {
                entrada.setTipoPin("**");
            }
            resumoEstatistica.setNomeFabricanteTef("AUTTAR PROCESSAMENTO DE DADOS");
            resumoEstatistica.setVersaoAplTef("C020607");
            if (dados.getEntradaIntegracao() != null) {
                EntradaCTFClientCtrl entradaIntegracao = dados.getEntradaIntegracao();
                resumoEstatistica.setNomeFabricanteAc(entradaIntegracao.getNomeAc());
                resumoEstatistica.setVersaoAplAc(entradaIntegracao.getVersaoAc());
            }
            resumoEstatistica.setQtdeLeituraMagnetico(dadosEstatistica.getQtdeLeituraMagnetico());
            resumoEstatistica.setQtdeErroLeituraMagnetico(dadosEstatistica.getQtdeErroLeituraMagnetico());
            resumoEstatistica.setQtdeSenhaPinMagnetico(dadosEstatistica.getQtdeSenhaPinMagnetico());
            resumoEstatistica.setQtdeErroSenhaPinMagnetico(dadosEstatistica.getQtdeErroSenhaPinMagnetico());
            resumoEstatistica.setQtdeSenhaOnlineChip(dadosEstatistica.getQtdeSenhaOnlineChip());
            resumoEstatistica.setQtdeErroSenhaOnlineChip(dadosEstatistica.getQtdeErroSenhaOnlineChip());
            resumoEstatistica.setQtdeSenhaOfflineChip(dadosEstatistica.getQtdeSenhaOfflineChip());
            resumoEstatistica.setQtdeErroSenhaOfflineChip(dadosEstatistica.getQtdeErroSenhaOfflineChip());
            resumoEstatistica.setQtdeCartoesBloqErroSenhaChip(dadosEstatistica.getQtdeCartoesBloqErroSenhaChip());
            resumoEstatistica.setQtdeLeituraSmart(dadosEstatistica.getQtdeLeituraSmart());
            resumoEstatistica.setQtdeFallbackChipCredito(dadosEstatistica.getQtdeFallbackChipCredito());
            resumoEstatistica.setQtdeFallbackChipDebito(dadosEstatistica.getQtdeFallbackChipDebito());
            entrada.setEstatistica(resumoEstatistica);
            if (dados.getSaidaApiTef() != null) {
                entrada.setTimeoutCtf(dados.getSaidaApiTef().getTimeOutCTF());
            } else {
                entrada.setTimeoutCtf(30);
            }
            entrada.setDataCliente(dados.getStartProcess());
            ConfCTFClient conf = ControladorConfCTFClient.getInstance().getConfig();
            EntradaCTFClientCtrl entradaIntegracao = dados.getEntradaIntegracao();
            IdentTerminal identTerminal = entradaIntegracao == null ? new IdentTerminal(conf.getEstabelecimento(), conf.getLoja(), conf.getTerminal()) : entradaIntegracao.getIdentTerminal();
            IdentApiTefC ident = new IdentApiTefC();
            ident.setNumeroEstabelecimento(identTerminal.getEstabelecimento());
            ident.setNumeroLoja(identTerminal.getLoja());
            ident.setNumeroPdv(identTerminal.getTerminal());
            ident.setNumeroSites(String.valueOf(conf.getNumeroSites()));
            ident.setListaIP(conf.getIps());
            ident.setQuantidadeVias(conf.getQuantidadeVias());
            dados.setEntradaApiTef(entrada);
            SaidaApiTefC saida = dados.getApitef().solicitacao(ident, entrada);
            if (dados.getTipoOperacao() != null && dados.getTipoOperacao().equals("OPERACAO ESTATISTICA MANUAL")) {
                dados.setSaidaApiTef(saida);
            }
            if (saida.getRetorno() != 0) {
                logger.info((Object)"nao foi possivel enviar a transa\u00e7\u00e3o de estat\u00edstica: ");
                logger.info((Object)("codigo retorno = " + saida.getRetorno() + " erro = " + saida.getCodigoErro()));
                return ERROR;
            }
            VerifyContentUtil.preencheDadosSaida(dados, saida);
        }
        catch (ExcecaoApiAc e) {
            logger.error((Object)("Erro ao solicitar a transa\u00e7\u00e3o de estat\u00edstica: " + e.getMessage()));
            return ERROR;
        }
        return SUCESS;
    }
}

