/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.IdentApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.ControladorBaixaTecnica;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.IProcessFuelControl;
import com.csi.ctfclient.operacoes.model.AbstractCartao;
import com.csi.ctfclient.operacoes.model.CartaoChip;
import com.csi.ctfclient.operacoes.model.CartaoDigitado;
import com.csi.ctfclient.operacoes.model.CartaoMagnetico;
import com.csi.ctfclient.operacoes.model.GetInfo;
import com.csi.ctfclient.operacoes.model.PinInfo;
import com.csi.ctfclient.operacoes.model.TabelaCriptografia;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.emvfull.ProtocoloBibliotecaCompartilhada;
import com.csi.ctfclient.tools.util.VerifyContentUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class MicSolicitacaoPreAutorizacaoShell {
    public static final String SUCCESS = "SUCCESS";
    public static final String UNECESSARY = "UNECESSARY";
    public static final String ERROR = "ERROR";
    private Logger logger = CTFClientLogger.getCTFClient();

    public String execute(IProcessFuelControl dados) throws ExcecaoApiAc {
        TabelaCriptografia tabelaCriptografia;
        SaidaApiTefC saida = dados.getSaidaApiTef();
        if (saida != null && !saida.isConsultarPerguntas()) {
            return UNECESSARY;
        }
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ControladorPerifericos periferico = dados.getPerifericos();
        ControladorBaixaTecnica conBaixaTecnica = ControladorBaixaTecnica.getInstance();
        ConfCTFClient conf = ControladorConfCTFClient.getInstance().getConfig();
        EntradaApiTefC entrada = new EntradaApiTefC();
        entrada.setNumeroTransacao(dados.getNumeroTransacao());
        entrada.setOperacao(this.getCodigoTransacao(dados));
        EntradaCTFClientCtrl entradaIntegracao = dados.getEntradaIntegracao();
        if (entradaIntegracao != null) {
            entrada.setDataCliente(entradaIntegracao.getDataAbertura());
        } else {
            entrada.setDataCliente(dados.getStartProcess());
        }
        if (dados.getServicoFuelControl() != null) {
            entrada.setServicoFuelControl(dados.getServicoFuelControl());
        }
        if (periferico.getPin() != null) {
            if (periferico.getPin().isBibliotecaEMV()) {
                if (dados.getDadosGetInfo() != null) {
                    GetInfo dadoGetInfo = dados.getDadosGetInfo();
                    entrada.setNumeroSeriePin(dadoGetInfo.getNumeroSerie());
                    entrada.setVersaoBibliotecaCompartilhada(dadoGetInfo.getVersaoBibliotecaCompartilhada());
                    entrada.setVersaoEspecificacao(dadoGetInfo.getVersaoEspecificao());
                    entrada.setVersaoAplicacaoBasica(dadoGetInfo.getVersaoAplicacao());
                    entrada.setVersaoBibliotecaRedeEMV(dadoGetInfo.getVersaoBibRede4());
                    entrada.setFabricantePinpad(dadoGetInfo.getFabricante());
                    entrada.setModeloHardware(dadoGetInfo.getModeloHardware());
                    entrada.setVersaoRedeAdquirente(dadoGetInfo.getVersaoRedeAdquirente());
                    entrada.setVersaoKernelEMV(dadoGetInfo.getVersaoKernelEMV());
                }
                entrada.setDadosVisanetPin(conBaixaTecnica.montaDadosVisaNetPin());
                entrada.setTipoPin("16");
            } else {
                entrada.setTipoPin("14");
            }
        } else {
            entrada.setTipoPin("**");
        }
        entrada.setTimeoutCtf(saida.getTimeOutCTF());
        entrada.setRetornoBibliotecaCompartilhada(dados.getLastErrorCode());
        if (!(dados.getCartao() instanceof CartaoDigitado)) {
            AbstractCartao cartao = (AbstractCartao)dados.getCartao();
            if (cartao.getNomePortador() != null && !cartao.getNomePortador().equals("")) {
                entrada.setNomeCliente(cartao.getNomePortador());
            }
            entrada.setStatusChip(cartao.getStatusUltimaLeitura());
            entrada.setTipoCartao(cartao.getTipoCartao());
            entrada.setIssuerCountryCode(cartao.getIssuerCountry());
            entrada.setWFlags(cartao.getFlags());
            if (cartao.getTrilha1() != null) {
                entrada.setTrilha1(cartao.getTrilha1());
            }
            if (cartao.getTrilha2() != null) {
                entrada.setInfo(cartao.getTrilha2());
            }
            if (cartao.getTrilha1Criptografado() != null) {
                entrada.setTrilha1Criptografada(cartao.getTrilha1Criptografado());
            }
            if (cartao.getTrilha2Criptografado() != null) {
                entrada.setTrilha2Criptografada(cartao.getTrilha2Criptografado());
            }
            entrada.setPAN(cartao.getNumero());
            if (cartao.getNumeroCriptografado() != null) {
                entrada.setCartaoCriptografado(cartao.getNumeroCriptografado());
            }
        }
        if (dados.getCartao() instanceof CartaoMagnetico) {
            entrada.setModoEntrada(2);
        } else if (dados.getCartao() instanceof CartaoChip) {
            CartaoChip cartaoChip = (CartaoChip)dados.getCartao();
            entrada.setModoEntrada(5);
            entrada.setNumeroAplicacao(cartaoChip.getNumero());
            entrada.setIndiceAid(cartaoChip.getIndiceRegistroAID());
            entrada.setCodigoRedeAdquirenteChip(cartaoChip.getTipoRedeAdquirente());
            entrada.setCardSequenceNumber(cartaoChip.getPanSequenceNumber());
            entrada.setTipoAplicacaoChip(cartaoChip.getTipoAplicacao());
            entrada.setApplicationExpirationDate(cartaoChip.getApplicationExpirationDate());
        } else if (dados.getCartao() instanceof CartaoDigitado) {
            CartaoDigitado cartaoDigitado = (CartaoDigitado)dados.getCartao();
            entrada.setModoEntrada(1);
            entrada.setInfo(cartaoDigitado.getNumero());
            entrada.setPAN(cartaoDigitado.getNumero());
            if (cartaoDigitado.getNumeroCriptografado() != null) {
                entrada.setCartaoCriptografado(cartaoDigitado.getNumeroCriptografado());
            }
        }
        PinInfo pinInfo = dados.getPinInfo();
        if (pinInfo != null) {
            entrada.setSenhaOfflineChip(pinInfo.isVerificadoOffline());
            entrada.setAssinaturaChip(pinInfo.isRequerAssinatura());
            entrada.setDecisaoChip(pinInfo.getDecisaoTomada());
            if (!(dados.getCartao() instanceof CartaoChip) || dados.getCartao() instanceof CartaoChip && pinInfo.isCapturadoVerificacaoOnline() || !ProtocoloBibliotecaCompartilhada.isBibliotecaEMV()) {
                entrada.setSenha(pinInfo.getPinCriptografado());
                if (dados.getNumeroSerieChaveDUKPTSenha() != null) {
                    entrada.setNumeroSerieChaveSenha(dados.getNumeroSerieChaveDUKPTSenha());
                }
            }
            if (dados.getStatusComunicacaoHost() != null && dados.getStatusComunicacaoHost() == 1) {
                EntradaApiTefC entradaFinishChip = dados.getEntradaApiTef();
                entrada.setDadosFinaisChip(entradaFinishChip.getDadosFinaisChip());
            } else if (pinInfo.getDadosCampo55() != null) {
                entrada.setDadosChip(pinInfo.getDadosCampo55());
            }
        }
        if ((tabelaCriptografia = dados.getTabelaCriptografia()) != null) {
            entrada.setMetodoCriptografiaSenha(tabelaCriptografia.getCriptografiaSenhaPrincipal().getAlgoritmo());
            if (tabelaCriptografia.getCriptografiaDadosPrincipal() != null) {
                entrada.setMetodoCriptografiaDados(tabelaCriptografia.getCriptografiaDadosPrincipal().getAlgoritmo());
            }
        }
        if (periferico.getPin() != null && conBaixaTecnica.isBaixaTecnicaSolicitada()) {
            entrada.setFlagBaixaTecnicaVisanet('1');
            entrada.setDadosGeraisPin(conBaixaTecnica.montaDadosGeraisPin());
            entrada.setVersaoAc(ControladorConfCTFClient.getInstance().getConfig().getVersaoAC());
            conBaixaTecnica.persisteBaixaTecnica();
        }
        LayoutDisplay displayModel = new LayoutDisplay(inter.getMessage("ENVIO1F_TITLE"));
        periferico.imprimeDisplay(displayModel);
        IdentApiTefC ident = new IdentApiTefC();
        ident.setNumeroEstabelecimento(conf.getEstabelecimento());
        ident.setNumeroLoja(conf.getLoja());
        ident.setNumeroPdv(conf.getTerminal());
        ident.setNumeroSites(String.valueOf(conf.getNumeroSites()));
        ident.setListaIP(conf.getIps());
        ident.setQuantidadeVias(conf.getQuantidadeVias());
        entrada.setNumeroCupom(dados.getNumeroCupom());
        entrada.setIndiceMasterKey(dados.getSaidaApiTef().getIndiceMasterKey());
        dados.setEntradaApiTef(entrada);
        saida = dados.getApitef().solicitacao(ident, entrada);
        if (saida.getRetorno() != 0) {
            dados.setSaidaApiTef(saida);
            this.logger.log((Priority)Level.INFO, (Object)("Resposta autorizadora: " + saida.getCodigoRespostaAutorizadora()));
            return ERROR;
        }
        SaidaApiTefC saidaProcess = dados.getSaidaApiTef();
        saidaProcess.setInformacoesAdicionaisBuffer(saida.getInformacoesAdicionaisBuffer());
        saidaProcess.setConfirmacaoPositivaBuffer(saida.getConfirmacaoPositivaBuffer());
        saidaProcess.setVersaoConfirmacaoPositiva(saida.getVersaoConfirmarcaoPositiva());
        if (saida.getFlagBaixaTecnica() == '1' || saida.getFlagBaixaTecnica() == '2') {
            conBaixaTecnica.persisteBaixaTecnica();
        }
        VerifyContentUtil.preencheDadosSaida(dados, saida);
        return SUCCESS;
    }

    protected String getCodigoTransacao(IProcessFuelControl dado) throws IllegalStateException {
        if ("OPERACAO FUEL CONTROL".equals(dado.getTipoOperacao())) {
            return "6H";
        }
        throw new IllegalStateException("Codigo da transa\u00e7\u00e3o n\u00e3o encotrada");
    }
}

