/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.IdentApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.ControladorBaixaTecnica;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.ITipoOperacao;
import com.csi.ctfclient.operacoes.entrada.ITransacoesSAA;
import com.csi.ctfclient.operacoes.model.AbstractCartao;
import com.csi.ctfclient.operacoes.model.CartaoChip;
import com.csi.ctfclient.operacoes.model.CartaoDigitado;
import com.csi.ctfclient.operacoes.model.CartaoMagnetico;
import com.csi.ctfclient.operacoes.model.PinInfo;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.devices.emv.PinEMV;
import com.csi.ctfclient.tools.devices.emvfull.ProtocoloBibliotecaCompartilhada;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import java.math.BigDecimal;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class MicSolicitacaoTransacoesSAA {
    public static final String SUCCESS = "SUCCESS";
    public static final String ERROR = "ERROR";
    private static BigDecimal valor1Centavo = new BigDecimal(1);
    private Logger logger = CTFClientLogger.getCTFClient();

    public String execute(ITransacoesSAA dados) throws ExcecaoApiAc {
        PinInfo pinInfo;
        PinEMV pinEMV;
        boolean connectedPin;
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ControladorPerifericos periferico = dados.getPerifericos();
        ControladorBaixaTecnica conBaixaTecnica = ControladorBaixaTecnica.getInstance();
        EntradaApiTefC entrada = new EntradaApiTefC();
        SaidaApiTefC saida = dados.getSaidaApiTef();
        entrada.setNumeroTransacao(dados.getNumeroTransacao());
        EntradaCTFClientCtrl entradaIntegracao = dados.getEntradaIntegracao();
        String bit62 = null;
        if (entradaIntegracao != null) {
            if (entradaIntegracao.getInfoAdicionais() != null) {
                bit62 = entradaIntegracao.getInfoAdicionais();
                entrada.setAdicionais(bit62);
            }
            if (entradaIntegracao.isModoEntradaCartaoCtrl()) {
                entrada.setModoEntrada(dados.getEntradaIntegracao().getModoEntradaCartao());
            }
        }
        entrada.setOperacao(MicSolicitacaoTransacoesSAA.getCodigoTransacao(dados));
        entrada.setCodigoProduto(0);
        this.preencheValorTransacao(dados, entrada);
        entrada.setValorEntrada(new BigDecimal(0));
        this.preencheModoEntrada(dados, entrada);
        String numeroCartaoFixo = MicSolicitacaoTransacoesSAA.formataNumeroCartao(dados, bit62);
        if (numeroCartaoFixo != null && numeroCartaoFixo.length() > 0) {
            entrada.setInfo(numeroCartaoFixo);
        }
        if (dados.getNumeroParcela() > 0) {
            entrada.setNumeroParcelas(dados.getNumeroParcela());
        }
        if (dados.getDataVencimentoCartaoPresente() != null) {
            entrada.setDataVencimento(dados.getDataVencimentoCartaoPresente());
        }
        if (entradaIntegracao != null) {
            entrada.setDataCliente(entradaIntegracao.getDataAbertura());
            if (entradaIntegracao.getTipoProduto() != null) {
                entrada.setTipoProduto(entradaIntegracao.getTipoProduto());
            }
        } else {
            entrada.setDataCliente(dados.getStartProcess());
        }
        boolean bl = connectedPin = (pinEMV = periferico.getPin()) != null;
        if (connectedPin) {
            if (pinEMV.isBibliotecaEMV()) {
                entrada.setTipoPin("16");
            } else {
                entrada.setTipoPin("14");
            }
        } else {
            entrada.setTipoPin("**");
        }
        entrada.setTimeoutCtf(30);
        entrada.setRetornoBibliotecaCompartilhada(dados.getLastErrorCode());
        if (dados.getCartao() != null) {
            if (!(dados.getCartao() instanceof CartaoDigitado)) {
                AbstractCartao cartao = (AbstractCartao)dados.getCartao();
                if (cartao.getNomePortador() != null && !cartao.getNomePortador().equals("")) {
                    entrada.setNomeCliente(cartao.getNomePortador());
                }
                entrada.setStatusChip(cartao.getStatusUltimaLeitura());
                entrada.setTipoCartao(cartao.getTipoCartao());
                entrada.setIssuerCountryCode(cartao.getIssuerCountry());
                entrada.setWFlags(cartao.getFlags());
                if (cartao.getTrilha1() != null) {
                    entrada.setTrilha1(cartao.getTrilha1());
                }
                if (cartao.getTrilha2() != null) {
                    entrada.setInfo(cartao.getTrilha2());
                }
                if (cartao.getTrilha1Criptografado() != null) {
                    entrada.setTrilha1Criptografada(cartao.getTrilha1Criptografado());
                }
                if (cartao.getTrilha2Criptografado() != null) {
                    entrada.setTrilha2Criptografada(cartao.getTrilha2Criptografado());
                }
                entrada.setPAN(cartao.getNumero());
                if (cartao.getNumeroCriptografado() != null) {
                    entrada.setCartaoCriptografado(cartao.getNumeroCriptografado());
                }
            }
            if (dados.getCartao() instanceof CartaoMagnetico) {
                entrada.setModoEntrada(2);
            } else if (dados.getCartao() instanceof CartaoChip) {
                CartaoChip cartaoChip = (CartaoChip)dados.getCartao();
                entrada.setModoEntrada(5);
                entrada.setNumeroAplicacao(cartaoChip.getNumero());
                entrada.setIndiceAid(cartaoChip.getIndiceRegistroAID());
                entrada.setCodigoRedeAdquirenteChip(cartaoChip.getTipoRedeAdquirente());
                entrada.setCardSequenceNumber(cartaoChip.getPanSequenceNumber());
                entrada.setTipoAplicacaoChip(cartaoChip.getTipoAplicacao());
                entrada.setApplicationExpirationDate(cartaoChip.getApplicationExpirationDate());
                entrada.setApplicationLabel(cartaoChip.getApplicationLabel());
            } else if (dados.getCartao() instanceof CartaoDigitado) {
                CartaoDigitado cartaoDigitado = (CartaoDigitado)dados.getCartao();
                entrada.setModoEntrada(1);
                entrada.setInfo(cartaoDigitado.getNumero());
                entrada.setPAN(cartaoDigitado.getNumero());
                if (cartaoDigitado.getNumeroCriptografado() != null) {
                    entrada.setCartaoCriptografado(cartaoDigitado.getNumeroCriptografado());
                }
            }
        }
        if ((pinInfo = dados.getPinInfo()) != null) {
            entrada.setSenhaOfflineChip(pinInfo.isVerificadoOffline());
            entrada.setAssinaturaChip(pinInfo.isRequerAssinatura());
            entrada.setChipBloqueadoOffline(pinInfo.isOfflineBloqueado());
            if (!(dados.getCartao() instanceof CartaoChip) || dados.getCartao() instanceof CartaoChip && pinInfo.isCapturadoVerificacaoOnline() || !ProtocoloBibliotecaCompartilhada.isBibliotecaEMV()) {
                entrada.setSenha(pinInfo.getPinCriptografado());
                if (dados.getNumeroSerieChaveDUKPTSenha() != null) {
                    entrada.setNumeroSerieChaveSenha(dados.getNumeroSerieChaveDUKPTSenha());
                }
            }
        }
        if (connectedPin && conBaixaTecnica.isBaixaTecnicaSolicitada()) {
            entrada.setFlagBaixaTecnicaVisanet('1');
            entrada.setDadosGeraisPin(conBaixaTecnica.montaDadosGeraisPin());
            entrada.setVersaoAc(ControladorConfCTFClient.getInstance().getConfig().getVersaoAC());
            conBaixaTecnica.persisteBaixaTecnica();
        }
        ConfCTFClient conf = ControladorConfCTFClient.getInstance().getConfig();
        entrada.setAcSuportaPlataformaPromocional(conf.isAcSuportaPlataformaPromocional());
        entrada.setClientSuportaPlataformaPromocional(true);
        LayoutDisplay displayModel = new LayoutDisplay();
        displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO1")));
        displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO2")));
        displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO3")));
        periferico.imprimeDisplay(displayModel);
        IdentApiTefC ident = new IdentApiTefC();
        ident.setNumeroEstabelecimento(conf.getEstabelecimento());
        ident.setNumeroLoja(conf.getLoja());
        ident.setNumeroPdv(conf.getTerminal());
        ident.setNumeroSites(String.valueOf(conf.getNumeroSites()));
        ident.setListaIP(conf.getIps());
        ident.setQuantidadeVias(conf.getQuantidadeVias());
        entrada.setNumeroCupom(dados.getNumeroCupom());
        if (saida != null) {
            entrada.setIndiceMasterKey(saida.getIndiceMasterKey());
        }
        if (connectedPin) {
            pinEMV.setMsgDisplay(inter.getMessage("ENVIO_TITLE"));
        }
        saida = dados.getApitef().solicitacao(ident, entrada);
        dados.setEntradaApiTef(entrada);
        dados.setSaidaApiTef(saida);
        if (saida.getRetorno() != 0) {
            this.logger.log((Priority)Level.INFO, (Object)("Resposta autorizadora: " + saida.getCodigoRespostaAutorizadora()));
            return ERROR;
        }
        return SUCCESS;
    }

    protected static String getCodigoTransacao(ITipoOperacao dados) throws IllegalStateException {
        if ("OPE_EMISSAO_VALE_TROCA".equals(dados.getTipoOperacao())) {
            return "Y1";
        }
        if ("OPE_RESGATE_VALE_TROCA".equals(dados.getTipoOperacao())) {
            return "Y2";
        }
        if ("OPE_CONSULTA_REIMPRESSAO_VALE_TROCA".equals(dados.getTipoOperacao())) {
            return "9B";
        }
        if ("OPE_REIMPRESSAO_VALE_TROCA".equals(dados.getTipoOperacao())) {
            return "96";
        }
        if ("OPE_CONSULTA_GARANTIA_ESTENDIDA".equals(dados.getTipoOperacao())) {
            return "7C";
        }
        if ("OPE_CONSULTA_GARANTIA_ROUBO_FURTO".equals(dados.getTipoOperacao())) {
            return "7C";
        }
        if ("OPE_PAGAMENTO_GARANTIA_EXTENDIDA".equals(dados.getTipoOperacao())) {
            return "9C";
        }
        if ("OPE_PAGAMENTO_GARANTIA_ROUBO_FURTO".equals(dados.getTipoOperacao())) {
            return "9C";
        }
        if ("OPE_CONSULTA_RESGATE_GARANTIA_NAO_MAGNETICA".equals(dados.getTipoOperacao())) {
            return "EE";
        }
        if ("OPE_COMPRA_RESGATE_GARANTIA_NAO_MAGNETICA".equals(dados.getTipoOperacao())) {
            return "F1";
        }
        if ("OPE_CONSULTA_ASSOCIADO".equals(dados.getTipoOperacao())) {
            return "6B";
        }
        if ("OPE_COMPRA_ASSOCIADO".equals(dados.getTipoOperacao())) {
            return "B1";
        }
        if ("OPE_CARGA_HABILITACAO_CARTAO_PRESENTE".equals(dados.getTipoOperacao())) {
            return "E8";
        }
        if ("OPE_RESGATE_CARTAO_PRESENTE_SAA".equals(dados.getTipoOperacao())) {
            return "EA";
        }
        if ("OPE_CONSULTA_CARTAO_PRESENTE_SAA".equals(dados.getTipoOperacao())) {
            return "EC";
        }
        if ("OPE_CARGA_HABILITACAO_CUPONAGEM".equals(dados.getTipoOperacao())) {
            return "E8";
        }
        if ("OPE_CONSULTA_CUPONAGEM".equals(dados.getTipoOperacao())) {
            return "EC";
        }
        if ("OPE_RESGATE_CUPONAGEM".equals(dados.getTipoOperacao())) {
            return "EA";
        }
        throw new IllegalStateException("Codigo da transa\u00e7\u00e3o n\u00e3o encotrada");
    }

    protected static String formataNumeroCartao(ITipoOperacao dados, String bit62) {
        String numeroCartao = null;
        if ("OPE_EMISSAO_VALE_TROCA".equals(dados.getTipoOperacao())) {
            numeroCartao = "7850000000000000000";
        } else if ("OPE_RESGATE_VALE_TROCA".equals(dados.getTipoOperacao())) {
            numeroCartao = "7850000000000000000";
        } else if ("OPE_CONSULTA_REIMPRESSAO_VALE_TROCA".equals(dados.getTipoOperacao())) {
            numeroCartao = "7850000000000000000";
        } else if ("OPE_REIMPRESSAO_VALE_TROCA".equals(dados.getTipoOperacao())) {
            numeroCartao = "7850000000000000000";
        } else if ("OPE_CONSULTA_GARANTIA_ESTENDIDA".equals(dados.getTipoOperacao())) {
            numeroCartao = "781";
        } else if ("OPE_CONSULTA_GARANTIA_ROUBO_FURTO".equals(dados.getTipoOperacao())) {
            numeroCartao = "781";
        } else if ("OPE_PAGAMENTO_GARANTIA_EXTENDIDA".equals(dados.getTipoOperacao())) {
            numeroCartao = "7810000000000000000";
        } else if ("OPE_PAGAMENTO_GARANTIA_ROUBO_FURTO".equals(dados.getTipoOperacao())) {
            numeroCartao = "7820000000000000000";
        } else if ("OPE_CONSULTA_RESGATE_GARANTIA_NAO_MAGNETICA".equals(dados.getTipoOperacao())) {
            numeroCartao = "7810000000000000000";
        } else if ("OPE_COMPRA_RESGATE_GARANTIA_NAO_MAGNETICA".equals(dados.getTipoOperacao())) {
            numeroCartao = "7810000000000000000";
        } else if ("OPE_CONSULTA_ASSOCIADO".equals(dados.getTipoOperacao()) || "OPE_COMPRA_ASSOCIADO".equals(dados.getTipoOperacao())) {
            int posicaoMatricula = 0;
            if ("OPE_CONSULTA_ASSOCIADO".equals(dados.getTipoOperacao())) {
                posicaoMatricula = 37;
            } else if ("OPE_COMPRA_ASSOCIADO".equals(dados.getTipoOperacao())) {
                posicaoMatricula = 82;
            }
            String matriculaAssociado = "";
            if (bit62 != null && bit62.length() >= posicaoMatricula + 10) {
                matriculaAssociado = bit62.substring(posicaoMatricula, posicaoMatricula + 10);
            }
            numeroCartao = "8888" + StringUtil.completaString(matriculaAssociado, 15, '0', 3);
        } else if ("OPE_CARGA_HABILITACAO_CARTAO_PRESENTE".equals(dados.getTipoOperacao())) {
            numeroCartao = "7770000000000000000";
        } else if (!"OPE_RESGATE_CARTAO_PRESENTE_SAA".equals(dados.getTipoOperacao()) && !"OPE_CONSULTA_CARTAO_PRESENTE_SAA".equals(dados.getTipoOperacao()) && ("OPE_CARGA_HABILITACAO_CUPONAGEM".equals(dados.getTipoOperacao()) || "OPE_CONSULTA_CUPONAGEM".equals(dados.getTipoOperacao()) || "OPE_RESGATE_CUPONAGEM".equals(dados.getTipoOperacao()))) {
            int posicaoCpf = 0;
            if ("OPE_CARGA_HABILITACAO_CUPONAGEM".equals(dados.getTipoOperacao())) {
                posicaoCpf = 12;
            } else if ("OPE_CONSULTA_CUPONAGEM".equals(dados.getTipoOperacao())) {
                posicaoCpf = 8;
            } else if ("OPE_RESGATE_CUPONAGEM".equals(dados.getTipoOperacao())) {
                posicaoCpf = 12;
            }
            String cpf = "";
            if (bit62 != null && bit62.length() >= posicaoCpf + 11) {
                cpf = bit62.substring(posicaoCpf, posicaoCpf + 11);
            }
            numeroCartao = "774" + StringUtil.completaString(cpf, 14, '0', 3);
        }
        return numeroCartao;
    }

    protected void preencheValorTransacao(ITransacoesSAA dados, EntradaApiTefC entrada) {
        if ("OPE_CONSULTA_REIMPRESSAO_VALE_TROCA".equals(dados.getTipoOperacao()) || "OPE_REIMPRESSAO_VALE_TROCA".equals(dados.getTipoOperacao()) || "OPE_CONSULTA_CARTAO_PRESENTE_SAA".equals(dados.getTipoOperacao()) || "OPE_CARGA_HABILITACAO_CUPONAGEM".equals(dados.getTipoOperacao()) || "OPE_CONSULTA_CUPONAGEM".equals(dados.getTipoOperacao()) || "OPE_RESGATE_CUPONAGEM".equals(dados.getTipoOperacao())) {
            entrada.setValorTransacao(valor1Centavo);
        } else {
            entrada.setValorTransacao(dados.getValorTransacao());
        }
    }

    protected void preencheModoEntrada(ITransacoesSAA dados, EntradaApiTefC entrada) {
    }

    static {
        valor1Centavo.movePointLeft(2);
    }
}

