/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.IdentApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.IDadosSolicitacaoValeGas;
import com.csi.ctfclient.operacoes.model.OperadoraValeGas;
import com.csi.ctfclient.operacoes.model.ProdutoValeGas;
import com.csi.ctfclient.servicos.IdentTerminal;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.util.VerifyContentUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class MicSolicitacaoValeGas {
    public static final String SUCCESS = "SUCCESS";
    public static final String ERROR = "ERROR";
    private Logger logger = CTFClientLogger.getCTFClient();

    public String execute(IDadosSolicitacaoValeGas dados) throws ExcecaoApiAc {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        boolean multiTerminal = dados.getEntradaIntegracao() != null && dados.getEntradaIntegracao().isMultiTerminal();
        EntradaApiTefC entrada = new EntradaApiTefC();
        SaidaApiTefC saida = dados.getSaidaApiTef();
        ControladorPerifericos periferico = dados.getPerifericos();
        OperadoraValeGas operadoraValeGas = dados.getOperadoraValeGas();
        ProdutoValeGas produtoValeGas = dados.getProdutoValeGas();
        if (operadoraValeGas == null) {
            throw new IllegalArgumentException("Operadora vale g\u00e1s n\u00e3o capturada.");
        }
        if (produtoValeGas == null) {
            throw new IllegalArgumentException("Produto vale g\u00e1s n\u00e3o capturado.");
        }
        String codigoTransacao = this.getCodigoTransacao(dados);
        entrada.setCodigoAutorizadora(operadoraValeGas.getAutorizadora());
        entrada.setProdutoValeGas(produtoValeGas);
        entrada.setTimeoutCtf(saida.getTimeOutCTF());
        if (dados.getEntradaIntegracao() != null) {
            entrada.setDataCliente(dados.getEntradaIntegracao().getDataAbertura());
        } else {
            entrada.setDataCliente(dados.getStartProcess());
        }
        entrada.setOperacao(codigoTransacao);
        entrada.setNumeroTransacao(dados.getNumeroTransacao());
        entrada.setValorTransacao(dados.getValorTransacao());
        LayoutDisplay displayModel = new LayoutDisplay();
        displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO1")));
        displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO2")));
        displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO3")));
        periferico.imprimeDisplay(displayModel);
        ConfCTFClient conf = ControladorConfCTFClient.getInstance().getConfig();
        IdentApiTefC ident = new IdentApiTefC();
        IdentTerminal identTerminal = null;
        identTerminal = multiTerminal ? dados.getEntradaIntegracao().getIdentTerminal() : new IdentTerminal(conf.getEstabelecimento(), conf.getLoja(), conf.getTerminal());
        ident.setNumeroEstabelecimento(identTerminal.getEstabelecimento());
        ident.setNumeroLoja(identTerminal.getLoja());
        ident.setNumeroPdv(identTerminal.getTerminal());
        ident.setNumeroSites(String.valueOf(conf.getNumeroSites()));
        ident.setListaIP(conf.getIps());
        ident.setQuantidadeVias(conf.getQuantidadeVias());
        entrada.setNumeroCupom(dados.getNumeroCupom());
        entrada.setIndiceMasterKey(dados.getSaidaApiTef().getIndiceMasterKey());
        dados.setEntradaApiTef(entrada);
        saida = dados.getApitef().solicitacao(ident, entrada);
        dados.setSaidaApiTef(saida);
        if (saida.getRetorno() != 0) {
            this.logger.log((Priority)Level.INFO, (Object)("Resposta autorizadora: " + saida.getCodigoRespostaAutorizadora()));
            return ERROR;
        }
        VerifyContentUtil.preencheDadosSaida(dados, saida);
        return SUCCESS;
    }

    protected String getCodigoTransacao(IDadosSolicitacaoValeGas dados) {
        return "4U";
    }
}

