/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.IdentApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.IDadosTransacaoPagamentoFaturaCartao;
import com.csi.ctfclient.operacoes.entrada.ITipoOperacao;
import com.csi.ctfclient.operacoes.model.AbstractCartao;
import com.csi.ctfclient.operacoes.model.CartaoChip;
import com.csi.ctfclient.operacoes.model.CartaoDigitado;
import com.csi.ctfclient.operacoes.model.CorrespondenteBancario;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class MicSolitacaoPagamentoFaturaCartao {
    public static final String SUCCESS = "SUCCESS";
    public static final String ERRO_TRANS_JA_EFETUADA = "ERRO_TRANS_JA_EFETUADA";
    public static final String ERROR = "ERROR";
    private Logger logger = CTFClientLogger.getCTFClient();

    public String execute(IDadosTransacaoPagamentoFaturaCartao dados) throws ExcecaoApiAc {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        EntradaApiTefC entrada = new EntradaApiTefC();
        SaidaApiTefC saida = dados.getSaidaApiTef();
        ControladorPerifericos periferico = dados.getPerifericos();
        String codigoTransacao = this.getCodigoTransacao(dados);
        ConfCTFClient confCTFClient = ControladorConfCTFClient.getInstance().getConfig();
        int modoEntrada = 0;
        int modoEntradaInfo = 0;
        String informacaoPagamento = "";
        if (dados.getIdentificacaoPagamento() == 1) {
            if (dados.getCartao() instanceof CartaoDigitado) {
                CartaoDigitado cartaoDigitado = (CartaoDigitado)dados.getCartao();
                if (cartaoDigitado.getVencimento() != null) {
                    entrada.setDataVencimento(cartaoDigitado.getDateVencimento());
                }
                modoEntrada = 1;
                modoEntradaInfo = 1;
                informacaoPagamento = dados.getCartao().getNumero();
            } else if (dados.getCartao() instanceof AbstractCartao) {
                AbstractCartao cartao = (AbstractCartao)dados.getCartao();
                modoEntrada = dados.getCartao() instanceof CartaoChip ? 5 : 2;
                modoEntradaInfo = 3;
                if (cartao.getTrilha2() != null) {
                    entrada.setInfo(cartao.getTrilha2());
                    informacaoPagamento = cartao.getTrilha2();
                }
            }
        } else if (dados.getIdentificacaoPagamento() == 2) {
            informacaoPagamento = dados.getCodigoBarras();
            modoEntrada = 3;
            modoEntradaInfo = dados.getModoEntradaCodigoBarras();
        }
        entrada.setModoEntrada(modoEntrada);
        String entradaCorrespondenteBancario = CorrespondenteBancario.montaEntrada(modoEntradaInfo, informacaoPagamento, dados.getTipoPagamento());
        if (dados.getDataVencimentoCorBan() != null) {
            entrada.setDataVencimento(dados.getDataVencimentoCorBan());
        }
        entrada.setInfo(entradaCorrespondenteBancario);
        entrada.setTimeoutCtf(confCTFClient.getTimeOutDefault());
        if (dados.getEntradaIntegracao() != null) {
            entrada.setDataCliente(dados.getEntradaIntegracao().getDataAbertura());
        } else {
            entrada.setDataCliente(dados.getStartProcess());
        }
        entrada.setOperacao(codigoTransacao);
        if (dados.getDataVencimentoCorBan() != null) {
            entrada.setDataVencimentoCorrespondenteBancario(dados.getDataVencimentoCorBan());
        }
        entrada.setNumeroTransacao(dados.getNumeroTransacao());
        if (dados.getDataVencimento() != null) {
            entrada.setDataVencimento(dados.getDataVencimento());
        }
        entrada.setValorTransacao(dados.getValorTransacao());
        String msg1 = null;
        String msg2 = null;
        String msg3 = null;
        if ("OPERACAO CORRESPONDENTE BANCARIO CONSULTA CONVENIO".equals(dados.getTipoOperacao()) || "OPERACAO CORRESPONDENTE BANCARIO CONSULTA TITULO".equals(dados.getTipoOperacao())) {
            msg1 = inter.getMessage("SOLCORBAN_SOLICITACAO_CONSULTA1");
            msg2 = inter.getMessage("SOLCORBAN_SOLICITACAO_CONSULTA2");
            msg3 = inter.getMessage("SOLCORBAN_SOLICITACAO_CONSULTA3");
        } else {
            msg1 = inter.getMessage("ENVTRA_SOLICITACAO1");
            msg2 = inter.getMessage("ENVTRA_SOLICITACAO2");
            msg3 = inter.getMessage("ENVTRA_SOLICITACAO3");
        }
        LayoutDisplay displayModel = new LayoutDisplay();
        displayModel.addLinha(new Linha(msg1));
        displayModel.addLinha(new Linha(msg2));
        displayModel.addLinha(new Linha(msg3));
        periferico.imprimeDisplay(displayModel);
        ConfCTFClient conf = ControladorConfCTFClient.getInstance().getConfig();
        IdentApiTefC ident = new IdentApiTefC();
        ident.setNumeroEstabelecimento(conf.getEstabelecimento());
        ident.setNumeroLoja(conf.getLoja());
        ident.setNumeroPdv(conf.getTerminal());
        ident.setNumeroSites(String.valueOf(conf.getNumeroSites()));
        ident.setListaIP(conf.getIps());
        ident.setQuantidadeVias(conf.getQuantidadeVias());
        dados.setEntradaApiTef(entrada);
        saida = dados.getApitef().solicitacao(ident, entrada);
        dados.setSaidaApiTef(saida);
        if (saida.getRetorno() != 0) {
            this.logger.log((Priority)Level.INFO, (Object)("Resposta autorizadora: " + saida.getCodigoRespostaAutorizadora()));
            if (saida.getCodigoRespostaAutorizadora().equals("0ER")) {
                return ERRO_TRANS_JA_EFETUADA;
            }
            return ERROR;
        }
        CorrespondenteBancario correspondenteBancario = CorrespondenteBancario.createCorrespondenteBancario(saida.getAdicionais());
        if (correspondenteBancario != null) {
            dados.setCorrespondenteBancario(correspondenteBancario);
        }
        return SUCCESS;
    }

    private String getCodigoTransacao(ITipoOperacao dados) {
        if (dados.getTipoOperacao().equals("OPERACAO CONSULTA FATURA CARTAO")) {
            return "FA";
        }
        if (dados.getTipoOperacao().equals("OPERACAO PAGAMENTO FATURA CARTAO")) {
            return "FB";
        }
        throw new IllegalStateException("Codigo da transa\u00e7\u00e3o n\u00e3o encotrada");
    }
}

