/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.operacoes.ProcessManager;
import com.csi.ctfclient.operacoes.action.ProcessCorrespondenteBancario;
import com.csi.ctfclient.operacoes.entrada.ISubProcessConsultaCorrespondenteBancario;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MicSubProcessConsultaCorrespondenteBancario {
    public static final String SUCESS = "SUCESS";
    public static final String FILLED = "FILLED";
    public static final String ERROR = "ERROR";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String USER_CANCEL_INTERNAL = "USER_CANCEL_INTERNAL";
    private Logger logger = Logger.getLogger("com.csi.ctfclient.operacoes.microoperacoes.MicSubProcessConsultaCreditoDigital");

    public String execute(ISubProcessConsultaCorrespondenteBancario dados) {
        String tipoOperacao;
        if (dados.getCorrespondenteBancario() != null) {
            return FILLED;
        }
        this.logger.log(Level.INFO, "Executando o subprocesso para consulta Correspondente Banc\u00e1rio");
        ProcessManager processManager = ProcessManager.getInstance();
        ProcessCorrespondenteBancario processCorrespondenteBancario = null;
        if (dados.getTipoOperacao().equals("OPERACAO CORRESPONDENTE BANCARIO CONSULTA E PAGAMENTO CONVENIO")) {
            tipoOperacao = "OPERACAO CORRESPONDENTE BANCARIO CONSULTA CONVENIO";
        } else if (dados.getTipoOperacao().equals("OPERACAO CORRESPONDENTE BANCARIO CONSULTA E PAGAMENTO TITULO")) {
            tipoOperacao = "OPERACAO CORRESPONDENTE BANCARIO CONSULTA TITULO";
        } else {
            this.logger.log(Level.SEVERE, "Opera\u00e7\u00e3o n\u00e3o suportada na execu\u00e7\u00e3o do subprocesso de consulta CORBAN");
            throw new IllegalArgumentException("Opera\u00e7\u00e3o n\u00e3o suportada");
        }
        processCorrespondenteBancario = new ProcessCorrespondenteBancario(dados.getEntradaIntegracao(), null, tipoOperacao);
        processCorrespondenteBancario.setActiveDialogUserCancel(false);
        processCorrespondenteBancario.setCodigoBarras(dados.getCodigoBarras());
        processCorrespondenteBancario.setCodigoBarrasParcial("");
        if (dados.getTipoConta() == 2) {
            processCorrespondenteBancario.setNumeroBloco(4);
        } else if (dados.getTipoConta() == 1) {
            processCorrespondenteBancario.setNumeroBloco(5);
        }
        processCorrespondenteBancario.setModoEntradaCodigoBarras(dados.getModoEntradaCodigoBarras());
        processCorrespondenteBancario.setTipoConta(dados.getTipoConta());
        processCorrespondenteBancario.setDataVencimentoCorBan(dados.getDataVencimentoCorBan());
        processCorrespondenteBancario.setConfirmacaoDataVencimento(false);
        processCorrespondenteBancario.setValorDocumento(dados.getValorDocumento());
        processCorrespondenteBancario.setConfirmacaoValorDocumento(false);
        processCorrespondenteBancario.setNaoConfirmaValorDocumento(true);
        processCorrespondenteBancario.setValorDesconto(dados.getValorDesconto());
        processCorrespondenteBancario.setValorAcrescimo(dados.getValorAcrescimo());
        try {
            processManager.subProcess(dados.getIdProcess(), processCorrespondenteBancario);
            dados.setErroIntegracao(processCorrespondenteBancario.getErroIntegracao());
            dados.setSaidaApiTef(processCorrespondenteBancario.getSaidaApiTef());
            if (processCorrespondenteBancario.getState() == 3) {
                return USER_CANCEL;
            }
            if (processCorrespondenteBancario.getState() == 1) {
                return ERROR;
            }
            if (processCorrespondenteBancario.getState() == 5) {
                return USER_CANCEL_INTERNAL;
            }
            SaidaApiTefC saida = processCorrespondenteBancario.getSaidaApiTef();
            dados.setSaidaApiTef(saida);
            dados.setCorrespondenteBancario(processCorrespondenteBancario.getCorrespondenteBancario());
            return SUCESS;
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
            return ERROR;
        }
    }
}

