/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.operacoes.ProcessManager;
import com.csi.ctfclient.operacoes.action.ProcessCreditoDigital;
import com.csi.ctfclient.operacoes.entrada.ISubProcessConsultaCreditoDigital;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class MicSubProcessConsultaCreditoDigital {
    public static final String SUCESS = "SUCESS";
    public static final String FILLED = "FILLED";
    public static final String FILLED_AC = "FILLED_AC";
    public static final String ERROR = "ERROR";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String USER_CANCEL_INTERNAL = "USER_CANCEL_INTERNAL";
    private Logger logger = CTFClientLogger.getCTFClient();

    public String execute(ISubProcessConsultaCreditoDigital dados) {
        if (dados.getValorTransacao() != null) {
            return FILLED;
        }
        if (dados.getEntradaIntegracao() != null && dados.getEntradaIntegracao().isValorTransacaoCtrl()) {
            return FILLED_AC;
        }
        this.logger.log((Priority)Level.INFO, (Object)"Executando o subprocesso para consulta de cr\u00e9dito digital");
        ProcessManager processManager = ProcessManager.getInstance();
        ProcessCreditoDigital processCreditoDigital = null;
        int numeroTransacao = dados.getEntradaIntegracao() != null ? dados.getEntradaIntegracao().getNumeroTransacao() : 1;
        processCreditoDigital = new ProcessCreditoDigital(dados.getEntradaIntegracao(), numeroTransacao, "CONSULTA DE CREDITO DIGITAL");
        processCreditoDigital.setActiveDialogUserCancel(false);
        processCreditoDigital.setOperadoraTelefonia(dados.getOperadoraTelefonia());
        processCreditoDigital.setDDD(dados.getDDD());
        processCreditoDigital.setTelefone(dados.getTelefone());
        processCreditoDigital.setDigitoVerificadorTelefone(dados.getDigitoVerificadorTelefone());
        processCreditoDigital.setCodigoUsuarioPdv(dados.getCodigoUsuarioPdv());
        processCreditoDigital.setTipoCreditoCompra(dados.getTipoCreditoCompra());
        processCreditoDigital.setTelefoneJaConfirmado(true);
        try {
            processManager.subProcess(dados.getIdProcess(), processCreditoDigital);
            dados.setErroIntegracao(processCreditoDigital.getErroIntegracao());
            SaidaApiTefC saida = processCreditoDigital.getSaidaApiTef();
            dados.setSaidaApiTef(saida);
            if (processCreditoDigital.getState() == 3) {
                return USER_CANCEL;
            }
            if (processCreditoDigital.getState() == 1) {
                return ERROR;
            }
            if (processCreditoDigital.getState() == 5) {
                return USER_CANCEL_INTERNAL;
            }
            dados.setConsultaValoresCreditoDigital(saida.getValoresRecarga());
            return SUCESS;
        }
        catch (Exception e) {
            this.logger.log((Priority)Level.ERROR, (Object)e.getMessage(), (Throwable)e);
            return ERROR;
        }
    }
}

