/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.operacoes.ProcessManager;
import com.csi.ctfclient.operacoes.action.ProcessCreditoCelular;
import com.csi.ctfclient.operacoes.entrada.ISubProcessCreditoCelular;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;

public class MicSubProcessCreditoCelular {
    public static final String SUCCESS = "SUCCESS";
    public static final String ERROR = "ERROR";
    public static final String USER_CANCEL = "USER_CANCEL";

    public String execute(ISubProcessCreditoCelular dados) throws Exception {
        ProcessManager processManager = ProcessManager.getInstance();
        ProcessCreditoCelular processCelular = null;
        if (dados.getEntradaIntegracao() != null) {
            EntradaCTFClientCtrl entradaIntegracao = dados.getEntradaIntegracao();
            if (entradaIntegracao.getOperacao() == 112) {
                entradaIntegracao.setOperacao(232);
            } else if (entradaIntegracao.getOperacao() == 113) {
                entradaIntegracao.setOperacao(233);
            } else if (entradaIntegracao.getOperacao() == 114) {
                entradaIntegracao.setOperacao(234);
            }
            processCelular = new ProcessCreditoCelular(dados.getEntradaIntegracao(), dados.getNumeroTransacao());
        } else {
            processCelular = new ProcessCreditoCelular(dados.getNumeroTransacao(), dados.getValorTransacao());
        }
        processManager.subProcess(dados.getIdProcess(), processCelular);
        dados.setSaidaApiTef(processCelular.getSaidaApiTef());
        dados.setEntradaApiTef(processCelular.getEntradaApiTef());
        dados.setSubFluxoCredito(processCelular);
        switch (processCelular.getState()) {
            case 1: {
                return ERROR;
            }
            case 3: {
                return USER_CANCEL;
            }
            case 0: {
                return SUCCESS;
            }
            case 2: {
                return SUCCESS;
            }
        }
        dados.setEntradaApiTef(processCelular.getEntradaApiTef());
        dados.setSaidaApiTef(processCelular.getSaidaApiTef());
        dados.setErroIntegracao(processCelular.getErroIntegracao());
        return SUCCESS;
    }
}

