/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.ProcessManager;
import com.csi.ctfclient.operacoes.action.processleituracartao.ProcessGoOnChip;
import com.csi.ctfclient.operacoes.entrada.IDadoPlano;
import com.csi.ctfclient.operacoes.entrada.IProcessGoOnChip;
import com.csi.ctfclient.operacoes.model.Criptografia;
import com.csi.ctfclient.operacoes.model.PinInfo;
import com.csi.ctfclient.operacoes.model.PlanoAVista;
import com.csi.ctfclient.operacoes.model.RegistroCriptografia;
import com.csi.ctfclient.operacoes.model.TabelaCriptografia;
import com.csi.ctfclient.tools.util.CriptografiaUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import java.math.BigDecimal;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class MicSubProcessGoOnChip {
    private Logger logger = CTFClientLogger.getCTFClient();
    public static final String SUCESS = "SUCESS";
    public static final String ERRO = "ERRO";
    public static final String ERROR_FALLBACK = "ERROR_FALLBACK";
    public static final String USERCANCEL = "USERCANCEL";
    public static final String USERCANCEL_INTERNAL = "USERCANCEL_INTERNAL";
    public static final String NOTREQUIRED = "NOTREQUIRED";

    public String execute(IProcessGoOnChip dados) throws ExcecaoApiAc {
        PlanoAVista planoAvista;
        SaidaApiTefC saida = dados.getSaidaApiTef();
        if (!saida.isCapturaDadosChip()) {
            return NOTREQUIRED;
        }
        TabelaCriptografia tabelaCriptografia = dados.getTabelaCriptografia();
        RegistroCriptografia registroCriptografia = tabelaCriptografia.getCriptografiaSenhaPrincipal();
        int modoCriptografia = registroCriptografia.getAlgoritmo();
        String workingKey = registroCriptografia.getWorkingKey();
        int indiceCriptografia = registroCriptografia.getIndiceMasterKey() == 42 ? 0 : registroCriptografia.getIndiceMasterKey();
        Criptografia criptografia = new Criptografia(modoCriptografia, indiceCriptografia, workingKey);
        dados.setCriptografia(criptografia);
        BigDecimal valorTotal = dados.getValorTransacao();
        BigDecimal valorSaque = new BigDecimal(0);
        if (dados.getServico() != null) {
            valorTotal = valorTotal.add(dados.getServico().getValorServico());
        }
        if (dados.getTaxaEmbarque() != null) {
            valorTotal = valorTotal.add(dados.getTaxaEmbarque().getValorEmbarque());
        }
        if (dados.getTipoFinanciamento() != null && dados.getTipoFinanciamento() instanceof PlanoAVista && (planoAvista = (PlanoAVista)dados.getTipoFinanciamento()).getValorSaque() != null) {
            valorTotal = valorTotal.add(planoAvista.getValorSaque());
            valorSaque = planoAvista.getValorSaque();
        }
        boolean possuiChaveContingencia = CriptografiaUtil.possuiChaveContingencia(registroCriptografia, tabelaCriptografia.getCriptografiaSenhaContingencia());
        possuiChaveContingencia = false;
        ProcessGoOnChip processGoOnChip = new ProcessGoOnChip(saida, criptografia, valorTotal, valorSaque, dados.getEntradaIntegracao(), possuiChaveContingencia);
        processGoOnChip.setActiveDialogUserCancel(false);
        ProcessManager manager = ProcessManager.getInstance();
        try {
            manager.subProcess(dados.getIdProcess(), processGoOnChip);
            PinInfo pinInfo = processGoOnChip.getPinInfo();
            dados.setPinInfo(pinInfo);
            if (pinInfo != null) {
                dados.setNumeroSerieChaveDUKPTSenha(pinInfo.getNumeroSerieChaveDUKPT());
            }
            dados.setErrorCode(processGoOnChip.getErrorCode());
            dados.setErroIntegracao(processGoOnChip.getErroIntegracao());
            if (processGoOnChip.getState() == 3) {
                dados.setRemoveCardMessage("OPERACAO        CANCELADA");
                return USERCANCEL;
            }
            if (processGoOnChip.getState() == 1) {
                if (saida != null && saida.isPermiteFallbackGoonchip() && (processGoOnChip.getErrorCode() == 50 || processGoOnChip.getErrorCode() == 60 || processGoOnChip.getErrorCode() == 61 || processGoOnChip.getErrorCode() == 70 || processGoOnChip.getErrorCode() == 76)) {
                    dados.setCartaoAnterior(dados.getCartao());
                    dados.setCartao(null);
                    dados.setSaidaApiTef(null);
                    dados.setLastErrorCode(processGoOnChip.getErrorCode());
                    if (dados instanceof IDadoPlano) {
                        dados.setTipoFinanciamento(null);
                    }
                    return ERROR_FALLBACK;
                }
                if (processGoOnChip.getErrorCode() == 42 && possuiChaveContingencia) {
                    CriptografiaUtil.utilizaCriptografiaContingenciaSenha(tabelaCriptografia, this.logger);
                    return "RERUN";
                }
                return ERRO;
            }
            if (processGoOnChip.getState() == 5) {
                dados.setRemoveCardMessage("OPERACAO        CANCELADA");
                return USERCANCEL_INTERNAL;
            }
            dados.setTagsMandatorias(saida.getTagsMandatorias());
            return SUCESS;
        }
        catch (Exception e) {
            this.logger.log((Priority)Level.ERROR, (Object)e.getMessage(), (Throwable)e);
            return ERRO;
        }
    }
}

