/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.ProcessManager;
import com.csi.ctfclient.operacoes.action.processleituracartao.ProcessLeituraCartao;
import com.csi.ctfclient.operacoes.entrada.IListAID;
import com.csi.ctfclient.operacoes.entrada.IProcessLeituraCartao;
import com.csi.ctfclient.operacoes.entrada.ISaida1G;
import com.csi.ctfclient.operacoes.entrada.ISaidaApiTef;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class MicSubProcessLeituraCartao {
    private Logger logger = CTFClientLogger.getCTFClient();
    public static final String SUCESS = "SUCESS";
    public static final String SUBPROCESS_CREDITO_CELULAR = "SUBPROCESS_CREDITO_CELULAR";
    public static final String ERRO = "ERRO";
    public static final String USERCANCEL = "USERCANCEL";
    public static final String USERCANCEL_INTERNAL = "USERCANCEL_INTERNAL";
    public static final String FILLED = "FILLED";

    public String execute(IProcessLeituraCartao dados) throws ExcecaoApiAc {
        EntradaCTFClientCtrl entradaIntegracao;
        if (dados.isNovaLeituraCartao()) {
            dados.setNovaLeituraCartao(false);
            dados.setCartao(null);
        }
        if (dados.isCartaoTransacaoGenerica() && dados.getCartao() != null) {
            return FILLED;
        }
        if (dados.getEntradaIntegracao() != null && !dados.getEntradaIntegracao().isConsulta() && dados.getCartao() != null) {
            return SUCESS;
        }
        if (dados.getEntradaIntegracao() != null && !dados.getEntradaIntegracao().isConsulta() && dados.isTransacaoSemCartao() && ((entradaIntegracao = dados.getEntradaIntegracao()).getOperacao() == 232 || entradaIntegracao.getOperacao() == 234 || entradaIntegracao.getOperacao() == 233)) {
            return SUBPROCESS_CREDITO_CELULAR;
        }
        ProcessManager processManager = ProcessManager.getInstance();
        ProcessLeituraCartao processLeituraCartao = null;
        SaidaApiTefC saida = null;
        if (dados instanceof ISaidaApiTef && dados.getSaidaApiTef() != null) {
            saida = dados.getSaidaApiTef();
        } else if (dados.getTipoOperacao().equals("OPERACAO CANCELAMENTO") && dados instanceof ISaida1G) {
            saida = ((ISaida1G)((Object)dados)).getSaida1G();
        }
        dados.setSaidaApiTef(null);
        int numeroTransacao = 0;
        numeroTransacao = dados.getEntradaIntegracao() != null ? dados.getEntradaIntegracao().getNumeroTransacao() : dados.getNumeroTransacao();
        List listAID = null;
        if (dados instanceof IListAID) {
            listAID = ((IListAID)((Object)dados)).getListAID();
        }
        processLeituraCartao = new ProcessLeituraCartao(dados.getTipoOperacao(), dados.getValorTransacao(), dados.getEntradaIntegracao(), saida, numeroTransacao, dados.getCodigoOrigemTransacao(), listAID);
        processLeituraCartao.setActiveDialogUserCancel(false);
        processLeituraCartao.setCartao(dados.getCartao());
        processLeituraCartao.setCartaoAnterior(dados.getCartaoAnterior());
        try {
            processManager.subProcess(dados.getIdProcess(), processLeituraCartao);
            if (processLeituraCartao.isSubfluxoCreditoCelular()) {
                dados.setSaidaApiTef(processLeituraCartao.getSaidaApiTef());
                dados.setEntradaApiTef(processLeituraCartao.getEntradaApiTef());
            }
            dados.setCartao(processLeituraCartao.getCartao());
            dados.setErroIntegracao(processLeituraCartao.getErroIntegracao());
            dados.setErrorCode(processLeituraCartao.getErrorCode());
            if (processLeituraCartao.getLastErrorCode() != 0) {
                dados.setLastErrorCode(processLeituraCartao.getLastErrorCode());
            }
            if (processLeituraCartao.isNovaLeituraCartao()) {
                dados.setNovaLeituraCartao(true);
                return "RERUN";
            }
            if (processLeituraCartao.getState() == 3) {
                return USERCANCEL;
            }
            if (processLeituraCartao.getState() == 1) {
                return ERRO;
            }
            if (processLeituraCartao.getState() == 5) {
                return USERCANCEL_INTERNAL;
            }
            if (processLeituraCartao.isSubfluxoCreditoCelular()) {
                dados.setTransacaoSemCartao(true);
                return SUBPROCESS_CREDITO_CELULAR;
            }
            return SUCESS;
        }
        catch (Exception e) {
            this.logger.log((Priority)Level.ERROR, (Object)e.getMessage(), (Throwable)e);
            return ERRO;
        }
    }
}

