/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.ProcessManager;
import com.csi.ctfclient.operacoes.action.processleituracartao.ProcessLeituraPin;
import com.csi.ctfclient.operacoes.entrada.ILeituraPin;
import com.csi.ctfclient.operacoes.model.ControladorModeloPinPad;
import com.csi.ctfclient.operacoes.model.Criptografia;
import com.csi.ctfclient.operacoes.model.PinInfo;
import com.csi.ctfclient.operacoes.model.PlanoAVista;
import com.csi.ctfclient.operacoes.model.RegistroCriptografia;
import com.csi.ctfclient.operacoes.model.TabelaCriptografia;
import com.csi.ctfclient.operacoes.model.controller.PinpadUtil;
import com.csi.ctfclient.tools.devices.emv.DadoSolicitaPin;
import com.csi.ctfclient.tools.util.CriptografiaUtil;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import java.math.BigDecimal;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class MicSubProcessLeituraPin {
    private Logger logger = CTFClientLogger.getCTFClient();
    public static final String SUCESS = "SUCESS";
    public static final String ERRO = "ERRO";
    public static final String USERCANCEL = "USERCANCEL";
    public static final String USERCANCEL_INTERNAL = "USERCANCEL_INTERNAL";
    public static final String NOTREQUIRED = "NOTREQUIRED";
    private static final String CVV2_ALREADY_READ = "CVV2_ALREADY_READ";

    public String execute(ILeituraPin dados) throws ExcecaoApiAc {
        PlanoAVista planoAvista;
        if (dados.getPerifericos().getPin() == null) {
            return NOTREQUIRED;
        }
        SaidaApiTefC saida = dados.getSaidaApiTef();
        if (!saida.isPedeSenha()) {
            return NOTREQUIRED;
        }
        TabelaCriptografia tabelaCriptografia = dados.getTabelaCriptografia();
        RegistroCriptografia registroCriptografia = tabelaCriptografia.getCriptografiaSenhaPrincipal();
        if (saida.isPedeSenhaOpcional() && dados.getCodigoSeguranca() != null && dados.getCodigoSeguranca().getMotivo() != 1 && dados.getCodigoSeguranca().getMotivo() != 0) {
            return CVV2_ALREADY_READ;
        }
        int modoCriptografia = registroCriptografia.getAlgoritmo();
        String workingKey = StringUtil.completaString(registroCriptografia.getWorkingKey().trim(), 32, '0', false);
        int indiceCriptografia = registroCriptografia.getIndiceMasterKey() == 42 ? 0 : registroCriptografia.getIndiceMasterKey();
        Criptografia criptografia = null;
        if (indiceCriptografia == 0 && !saida.isChaveAuttarWkAutorizadora()) {
            ControladorModeloPinPad controlador = ControladorModeloPinPad.getInstance();
            criptografia = controlador.getCriptografia(dados.getPerifericos().getPin());
        } else {
            criptografia = new Criptografia(modoCriptografia, indiceCriptografia, workingKey, saida.isChaveAuttarWkAutorizadora());
        }
        dados.setCriptografia(criptografia);
        BigDecimal valorTotal = dados.getValorTransacao();
        if (dados.getTaxaEmbarque() != null) {
            valorTotal = valorTotal.add(dados.getTaxaEmbarque().getValorEmbarque());
        }
        if (dados.getServico() != null) {
            valorTotal = valorTotal.add(dados.getServico().getValorServico());
        }
        if (dados.getTipoFinanciamento() != null && dados.getTipoFinanciamento() instanceof PlanoAVista && (planoAvista = (PlanoAVista)dados.getTipoFinanciamento()).getValorSaque() != null) {
            valorTotal = valorTotal.add(planoAvista.getValorSaque());
        }
        String msgDisplay = PinpadUtil.montaDisplaySenha(valorTotal, saida);
        DadoSolicitaPin[] dadoSolicitaPins = new DadoSolicitaPin[]{new DadoSolicitaPin(4, 12, msgDisplay)};
        ProcessManager processManager = ProcessManager.getInstance();
        boolean possuiChaveContingencia = CriptografiaUtil.possuiChaveContingencia(registroCriptografia, tabelaCriptografia.getCriptografiaSenhaContingencia());
        ProcessLeituraPin processLeituraPin = new ProcessLeituraPin(dados.getCartao(), criptografia, dadoSolicitaPins, true, saida, possuiChaveContingencia);
        processLeituraPin.setActiveDialogUserCancel(false);
        try {
            processManager.subProcess(dados.getIdProcess(), processLeituraPin);
            PinInfo pinInfo = processLeituraPin.getPinInfo();
            dados.setPinInfo(pinInfo);
            if (pinInfo != null) {
                dados.setNumeroSerieChaveDUKPTSenha(pinInfo.getNumeroSerieChaveDUKPT());
            }
            dados.setErroIntegracao(processLeituraPin.getErroIntegracao());
            dados.setErrorCode(processLeituraPin.getErrorCode());
            if (processLeituraPin.getRemoveCardMessage() != null) {
                dados.setRemoveCardMessage(processLeituraPin.getRemoveCardMessage());
            }
            if (processLeituraPin.getState() == 3) {
                return USERCANCEL;
            }
            if (processLeituraPin.getState() == 1) {
                if (processLeituraPin.getErrorCode() == 42 && possuiChaveContingencia) {
                    CriptografiaUtil.utilizaCriptografiaContingenciaSenha(tabelaCriptografia, this.logger);
                    CriptografiaUtil.atualizarUsoRestritoCriptografia(tabelaCriptografia, this.logger);
                    return "RERUN";
                }
                return ERRO;
            }
            if (processLeituraPin.getState() == 5) {
                return USERCANCEL_INTERNAL;
            }
            return SUCESS;
        }
        catch (Exception e) {
            this.logger.log((Priority)Level.ERROR, (Object)e.getMessage(), (Throwable)e);
            return ERRO;
        }
    }
}

