/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.IdentApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.ProcessManager;
import com.csi.ctfclient.operacoes.action.ProcessCancelamento;
import com.csi.ctfclient.operacoes.action.ProcessConfirmacaoPreAutorizacao;
import com.csi.ctfclient.operacoes.action.ProcessConsultaCDC;
import com.csi.ctfclient.operacoes.action.ProcessConsultaSaldo;
import com.csi.ctfclient.operacoes.action.ProcessConsultaTransferenciaDomestica;
import com.csi.ctfclient.operacoes.action.ProcessCreditoDigital;
import com.csi.ctfclient.operacoes.action.ProcessDepositoTransferenciaDomestica;
import com.csi.ctfclient.operacoes.action.ProcessPing;
import com.csi.ctfclient.operacoes.action.ProcessReimpressaoComprovante;
import com.csi.ctfclient.operacoes.action.ProcessResgatePremio;
import com.csi.ctfclient.operacoes.action.ProcessSaqueTransferenciaDomestica;
import com.csi.ctfclient.operacoes.action.ProcessTransacoesGenericas;
import com.csi.ctfclient.operacoes.action.ProcessValeGas;
import com.csi.ctfclient.operacoes.entrada.ITefDiscadoOperacaoADM;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.servicos.IdentTerminal;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.ItemMenu;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.LayoutMenu;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.devices.fusion.ControladorFusion;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class MicTefIPOperacaoADM {
    public static final String SUCCESS = "SUCCESS";
    public static final String ERROR = "ERROR";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String USER_CANCEL_INTERNAL = "USER_CANCEL_INTERNAL";
    public static final String ERROR_AC = "ERROR_AC";
    private Logger logger = CTFClientLogger.getCTFClient();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String execute(ITefDiscadoOperacaoADM dados) throws Exception {
        ControladorPerifericos perifericos = dados.getPerifericos();
        LayoutMenu layoutMenu = new LayoutMenu("OPERACOES ADMINISTRATIVAS", true);
        layoutMenu.addItem(new ItemMenu("CANCELAMENTO", "1"));
        layoutMenu.addItem(new ItemMenu("CONSULTA CDC", "2"));
        layoutMenu.addItem(new ItemMenu("VOUCHER", "3"));
        layoutMenu.addItem(new ItemMenu("CAPTURA-AUTORIZACAO", "4"));
        layoutMenu.addItem(new ItemMenu("RECARGA CELULAR", "5"));
        layoutMenu.addItem(new ItemMenu("REIMPRESSAO", "6"));
        layoutMenu.addItem(new ItemMenu("CONSULTA SALDO", "7"));
        layoutMenu.addItem(new ItemMenu("ENVIO FACIL", "8"));
        layoutMenu.addItem(new ItemMenu("RESGATE DE PREMIO", "9"));
        layoutMenu.addItem(new ItemMenu("COMUNICACAO FUSION", "10"));
        layoutMenu.addItem(new ItemMenu("VALE GAS", "11"));
        int opcao = perifericos.imprimeMenu(layoutMenu);
        if (opcao == -1) {
            return USER_CANCEL;
        }
        EntradaCTFClientCtrl entradaIntegracao = dados.getEntradaIntegracao();
        ProcessManager processManager = ProcessManager.getInstance();
        int state = 0;
        if (opcao == 1) {
            ProcessCancelamento processCancelamento = new ProcessCancelamento(entradaIntegracao);
            processCancelamento.setParent((Process)((Object)dados));
            processManager.subProcess(dados.getIdProcess(), processCancelamento);
            ((Process)((Object)dados)).setErro(processCancelamento.getErro());
            dados.setErroIntegracao(processCancelamento.getErroIntegracao());
            dados.setSaidaApiTef(processCancelamento.getSaidaApiTef());
            dados.setEntradaApiTef(processCancelamento.getEntradaApiTef());
            dados.setCodigoAutorizadora(processCancelamento.getCodigoAutorizadora());
            dados.setCodigoInstituicaoFinanceira(processCancelamento.getCodigoInstituicaoFinanceira());
            dados.setCodigoVan(processCancelamento.getCodigoVan());
            dados.setNomeAutorizadora(processCancelamento.getNomeAutorizadora());
            dados.setNomeInstituicaoFinanceira(processCancelamento.getNomeInstituicaoFinanceira());
            dados.setNomeVan(processCancelamento.getNomeVan());
            state = processCancelamento.getState();
        } else if (opcao == 2) {
            entradaIntegracao.setNumeroTransacao(0);
            ProcessConsultaCDC processConsultaCDC = new ProcessConsultaCDC(entradaIntegracao);
            processConsultaCDC.setParent((Process)((Object)dados));
            processManager.subProcess(dados.getIdProcess(), processConsultaCDC);
            ((Process)((Object)dados)).setErro(processConsultaCDC.getErro());
            dados.setErroIntegracao(processConsultaCDC.getErroIntegracao());
            dados.setSaidaApiTef(processConsultaCDC.getSaidaApiTef());
            dados.setEntradaApiTef(processConsultaCDC.getEntradaApiTef());
            dados.setCodigoAutorizadora(processConsultaCDC.getCodigoAutorizadora());
            dados.setCodigoInstituicaoFinanceira(processConsultaCDC.getCodigoInstituicaoFinanceira());
            dados.setCodigoVan(processConsultaCDC.getCodigoVan());
            dados.setNomeAutorizadora(processConsultaCDC.getNomeAutorizadora());
            dados.setNomeInstituicaoFinanceira(processConsultaCDC.getNomeInstituicaoFinanceira());
            dados.setNomeVan(processConsultaCDC.getNomeVan());
            state = processConsultaCDC.getState();
        } else if (opcao == 3) {
            ProcessTransacoesGenericas processGenerico = new ProcessTransacoesGenericas(entradaIntegracao.getNumeroTransacao(), entradaIntegracao, "VOUCHER GENERICO");
            processGenerico.setParent((Process)((Object)dados));
            processManager.subProcess(dados.getIdProcess(), processGenerico);
            ((Process)((Object)dados)).setErro(processGenerico.getErro());
            dados.setErroIntegracao(processGenerico.getErroIntegracao());
            dados.setSaidaApiTef(processGenerico.getSaidaApiTef());
            dados.setEntradaApiTef(processGenerico.getEntradaApiTef());
            dados.setCodigoAutorizadora(processGenerico.getCodigoAutorizadora());
            dados.setCodigoInstituicaoFinanceira(processGenerico.getCodigoInstituicaoFinanceira());
            dados.setCodigoVan(processGenerico.getCodigoVan());
            dados.setNomeAutorizadora(processGenerico.getNomeAutorizadora());
            dados.setNomeInstituicaoFinanceira(processGenerico.getNomeInstituicaoFinanceira());
            dados.setNomeVan(processGenerico.getNomeVan());
            state = processGenerico.getState();
        } else if (opcao == 4) {
            ProcessConfirmacaoPreAutorizacao processConfirmacaoPreAutorizacao = new ProcessConfirmacaoPreAutorizacao(entradaIntegracao);
            processConfirmacaoPreAutorizacao.setParent((Process)((Object)dados));
            processManager.subProcess(dados.getIdProcess(), processConfirmacaoPreAutorizacao);
            ((Process)((Object)dados)).setErro(processConfirmacaoPreAutorizacao.getErro());
            dados.setErroIntegracao(processConfirmacaoPreAutorizacao.getErroIntegracao());
            dados.setSaidaApiTef(processConfirmacaoPreAutorizacao.getSaidaApiTef());
            dados.setEntradaApiTef(processConfirmacaoPreAutorizacao.getEntradaApiTef());
            dados.setCodigoAutorizadora(processConfirmacaoPreAutorizacao.getCodigoAutorizadora());
            dados.setCodigoInstituicaoFinanceira(processConfirmacaoPreAutorizacao.getCodigoInstituicaoFinanceira());
            dados.setCodigoVan(processConfirmacaoPreAutorizacao.getCodigoVan());
            dados.setNomeAutorizadora(processConfirmacaoPreAutorizacao.getNomeAutorizadora());
            dados.setNomeInstituicaoFinanceira(processConfirmacaoPreAutorizacao.getNomeInstituicaoFinanceira());
            dados.setNomeVan(processConfirmacaoPreAutorizacao.getNomeVan());
            state = processConfirmacaoPreAutorizacao.getState();
        } else if (opcao == 5) {
            ProcessCreditoDigital processCreditoDigital = new ProcessCreditoDigital(entradaIntegracao, entradaIntegracao.getNumeroTransacao(), "COMPRA DE CREDITO DIGITAL");
            processCreditoDigital.setParent((Process)((Object)dados));
            processManager.subProcess(dados.getIdProcess(), processCreditoDigital);
            ((Process)((Object)dados)).setErro(processCreditoDigital.getErro());
            dados.setEntradaIntegracao(processCreditoDigital.getEntradaIntegracao());
            dados.setSaidaApiTef(processCreditoDigital.getSaidaApiTef());
            dados.setEntradaApiTef(processCreditoDigital.getEntradaApiTef());
            dados.setCodigoAutorizadora(processCreditoDigital.getCodigoAutorizadora());
            dados.setCodigoInstituicaoFinanceira(processCreditoDigital.getCodigoInstituicaoFinanceira());
            dados.setCodigoVan(processCreditoDigital.getCodigoVan());
            dados.setNomeAutorizadora(processCreditoDigital.getNomeAutorizadora());
            dados.setNomeInstituicaoFinanceira(processCreditoDigital.getNomeInstituicaoFinanceira());
            dados.setNomeVan(processCreditoDigital.getNomeVan());
            state = processCreditoDigital.getState();
        } else if (opcao == 6) {
            LayoutMenu layoutMenuReimpressao = new LayoutMenu("OPERACOES DE REIMPRESSAO", true);
            layoutMenuReimpressao.addItem(new ItemMenu("ULTIMO COMPROVANTE", "1"));
            layoutMenuReimpressao.addItem(new ItemMenu("OUTROS COMPROVANTES", "2"));
            int opcaoReimpressao = perifericos.imprimeMenu(layoutMenuReimpressao);
            if (opcaoReimpressao == -1) {
                return USER_CANCEL;
            }
            if (opcaoReimpressao == 1) {
                ControladorConfCTFClient controladorConf = ControladorConfCTFClient.getInstance();
                ConfCTFClient confCTFClient = controladorConf.getConfig();
                IdentTerminal identTerminal = new IdentTerminal(confCTFClient.getEstabelecimento(), confCTFClient.getLoja(), confCTFClient.getTerminal());
                int idxEmpresa = confCTFClient.getVersaoPathTerminal() == 1 ? 0 : 1;
                String path = identTerminal.getEstabelecimento().substring(idxEmpresa) + identTerminal.getLoja() + "." + identTerminal.getTerminal() + "/";
                if (ControladorConfCTFClient.getDiretorioTrabalho() != null) {
                    path = ControladorConfCTFClient.getDiretorioTrabalho() + path;
                }
                boolean ultimoCupom = false;
                int numTrans = 1;
                while (!ultimoCupom) {
                    String cupom3Atual = path + "CUPOMCTF.3" + StringUtil.completaString(numTrans + "", 2, '0', 3);
                    File fileCupom3Atual = new File(cupom3Atual);
                    if (fileCupom3Atual.exists()) {
                        String cupom3Proximo = path + "CUPOMCTF.3" + StringUtil.completaString(numTrans + 1 + "", 2, '0', 3);
                        File fileCupom3Proximo = new File(cupom3Proximo);
                        if (fileCupom3Proximo.exists()) {
                            ++numTrans;
                            continue;
                        }
                        if (numTrans > 1) {
                            String cupom = path + "CUPOMCTF.3" + StringUtil.completaString("1", 2, '0', 3);
                            File fileCupom = new File(cupom);
                            this.copiaCupom(fileCupom3Atual, fileCupom);
                            String cupom4Atual = path + "CUPOMCTF.4" + StringUtil.completaString(numTrans + "", 2, '0', 3);
                            File fileCupom4Atual = new File(cupom4Atual);
                            String cupom4 = path + "CUPOMCTF.4" + StringUtil.completaString("1", 2, '0', 3);
                            File fileCupom4 = new File(cupom4);
                            if (fileCupom4Atual.exists()) {
                                this.copiaCupom(fileCupom4Atual, fileCupom4);
                            }
                        }
                        SaidaApiTefC saidaApiTefC = new SaidaApiTefC();
                        saidaApiTefC.setRetorno(0);
                        dados.setSaidaApiTef(saidaApiTefC);
                        EntradaApiTefC entradaApiTefC = new EntradaApiTefC();
                        entradaApiTefC.setOperacao("F7");
                        dados.setEntradaApiTef(entradaApiTefC);
                        return SUCCESS;
                    }
                    state = this.executaReimpressaoOutrosComprovantes(dados, entradaIntegracao);
                    ultimoCupom = true;
                }
            } else {
                state = this.executaReimpressaoOutrosComprovantes(dados, entradaIntegracao);
            }
        } else if (opcao == 7) {
            entradaIntegracao.setNumeroTransacao(0);
            ProcessConsultaSaldo processConsultaSaldo = new ProcessConsultaSaldo(entradaIntegracao, "OPE_CONSULTA_SALDO_CREDITO");
            processConsultaSaldo.setParent((Process)((Object)dados));
            processManager.subProcess(dados.getIdProcess(), processConsultaSaldo);
            ((Process)((Object)dados)).setErro(processConsultaSaldo.getErro());
            dados.setErroIntegracao(processConsultaSaldo.getErroIntegracao());
            dados.setSaidaApiTef(processConsultaSaldo.getSaidaApiTef());
            dados.setEntradaApiTef(processConsultaSaldo.getEntradaApiTef());
            dados.setCodigoAutorizadora(processConsultaSaldo.getCodigoAutorizadora());
            dados.setCodigoInstituicaoFinanceira(processConsultaSaldo.getCodigoInstituicaoFinanceira());
            dados.setCodigoVan(processConsultaSaldo.getCodigoVan());
            dados.setNomeAutorizadora(processConsultaSaldo.getNomeAutorizadora());
            dados.setNomeInstituicaoFinanceira(processConsultaSaldo.getNomeInstituicaoFinanceira());
            dados.setNomeVan(processConsultaSaldo.getNomeVan());
            state = processConsultaSaldo.getState();
        } else if (opcao == 8) {
            LayoutMenu layoutMenuEnvioFacil = new LayoutMenu("ENVIO FACIL", true);
            layoutMenuEnvioFacil.addItem(new ItemMenu("CONSULTA", "1"));
            layoutMenuEnvioFacil.addItem(new ItemMenu("DEPOSITO", "2"));
            layoutMenuEnvioFacil.addItem(new ItemMenu("SAQUE", "3"));
            int opcaoEnvioFacil = perifericos.imprimeMenu(layoutMenuEnvioFacil);
            if (opcaoEnvioFacil == -1) {
                return USER_CANCEL;
            }
            if (opcaoEnvioFacil == 1) {
                ProcessConsultaTransferenciaDomestica processConsulta = new ProcessConsultaTransferenciaDomestica(entradaIntegracao);
                processConsulta.setParent((Process)((Object)dados));
                processManager.subProcess(dados.getIdProcess(), processConsulta);
                ((Process)((Object)dados)).setErro(processConsulta.getErro());
                dados.setEntradaIntegracao(processConsulta.getEntradaIntegracao());
                dados.setSaidaApiTef(processConsulta.getSaidaApiTef());
                dados.setEntradaApiTef(processConsulta.getEntradaApiTef());
                dados.setCodigoAutorizadora(processConsulta.getCodigoAutorizadora());
                dados.setCodigoInstituicaoFinanceira(processConsulta.getCodigoInstituicaoFinanceira());
                dados.setCodigoVan(processConsulta.getCodigoVan());
                dados.setNomeAutorizadora(processConsulta.getNomeAutorizadora());
                dados.setNomeInstituicaoFinanceira(processConsulta.getNomeInstituicaoFinanceira());
                dados.setNomeVan(processConsulta.getNomeVan());
                state = processConsulta.getState();
            } else if (opcaoEnvioFacil == 2) {
                ProcessDepositoTransferenciaDomestica processDeposito = new ProcessDepositoTransferenciaDomestica(entradaIntegracao);
                processDeposito.setParent((Process)((Object)dados));
                processManager.subProcess(dados.getIdProcess(), processDeposito);
                ((Process)((Object)dados)).setErro(processDeposito.getErro());
                dados.setEntradaIntegracao(processDeposito.getEntradaIntegracao());
                dados.setSaidaApiTef(processDeposito.getSaidaApiTef());
                dados.setEntradaApiTef(processDeposito.getEntradaApiTef());
                dados.setCodigoAutorizadora(processDeposito.getCodigoAutorizadora());
                dados.setCodigoInstituicaoFinanceira(processDeposito.getCodigoInstituicaoFinanceira());
                dados.setCodigoVan(processDeposito.getCodigoVan());
                dados.setNomeAutorizadora(processDeposito.getNomeAutorizadora());
                dados.setNomeInstituicaoFinanceira(processDeposito.getNomeInstituicaoFinanceira());
                dados.setNomeVan(processDeposito.getNomeVan());
                state = processDeposito.getState();
            } else if (opcaoEnvioFacil == 3) {
                ProcessSaqueTransferenciaDomestica processSaque = new ProcessSaqueTransferenciaDomestica(entradaIntegracao);
                processSaque.setParent((Process)((Object)dados));
                processManager.subProcess(dados.getIdProcess(), processSaque);
                ((Process)((Object)dados)).setErro(processSaque.getErro());
                dados.setEntradaIntegracao(processSaque.getEntradaIntegracao());
                dados.setSaidaApiTef(processSaque.getSaidaApiTef());
                dados.setEntradaApiTef(processSaque.getEntradaApiTef());
                dados.setCodigoAutorizadora(processSaque.getCodigoAutorizadora());
                dados.setCodigoInstituicaoFinanceira(processSaque.getCodigoInstituicaoFinanceira());
                dados.setCodigoVan(processSaque.getCodigoVan());
                dados.setNomeAutorizadora(processSaque.getNomeAutorizadora());
                dados.setNomeInstituicaoFinanceira(processSaque.getNomeInstituicaoFinanceira());
                dados.setNomeVan(processSaque.getNomeVan());
                state = processSaque.getState();
            }
        } else if (opcao == 9) {
            ProcessResgatePremio processResgate = new ProcessResgatePremio(entradaIntegracao, 1);
            processResgate.setParent((Process)((Object)dados));
            processManager.subProcess(dados.getIdProcess(), processResgate);
            ((Process)((Object)dados)).setErro(processResgate.getErro());
            dados.setEntradaIntegracao(processResgate.getEntradaIntegracao());
            dados.setSaidaApiTef(processResgate.getSaidaApiTef());
            dados.setEntradaApiTef(processResgate.getEntradaApiTef());
            dados.setCodigoAutorizadora(processResgate.getCodigoAutorizadora());
            dados.setCodigoInstituicaoFinanceira(processResgate.getCodigoInstituicaoFinanceira());
            dados.setCodigoVan(processResgate.getCodigoVan());
            dados.setNomeAutorizadora(processResgate.getNomeAutorizadora());
            dados.setNomeInstituicaoFinanceira(processResgate.getNomeInstituicaoFinanceira());
            dados.setNomeVan(processResgate.getNomeVan());
            state = processResgate.getState();
        } else {
            if (opcao == 10) {
                ConfCTFClient conf = ControladorConfCTFClient.getInstance().getConfig();
                if (conf.getIpFusion() != null && conf.getPortaFusion() != 0) {
                    LayoutDisplay displayModel = new LayoutDisplay();
                    displayModel.addLinha(new Linha("VERIFICANDO STATUS CTF..."));
                    perifericos.imprimeDisplay(displayModel);
                    boolean ctfOk = this.testaComunicacaoCTF(dados);
                    displayModel.addLinha(new Linha("VERIFICANDO STATUS CONEXAO"));
                    displayModel.addLinha(new Linha("CONCENTRADOR DE BOMBAS..."));
                    perifericos.imprimeDisplay(displayModel);
                    ControladorFusion.setParametrosInicializacao(conf.getIpFusion(), conf.getPortaFusion());
                    ControladorFusion fusion = ControladorFusion.getInstancia();
                    boolean fusionOk = fusion.eco();
                    this.logger.log((Priority)Level.INFO, (Object)("Comunica\u00e7\u00e3o com o Fusion: " + fusionOk));
                    displayModel = new LayoutDisplay();
                    displayModel.addLinha(new Linha("COMUNICACAO COM O CTF:      " + (ctfOk ? "SIM" : "NAO")));
                    displayModel.addLinha(new Linha("COMUNICACAO COM O FUSION:   " + (fusionOk ? "SIM" : "NAO")));
                    displayModel.addLinha(new Linha("UTILIZANDO CONTINGENCIA:    " + (ControladorFusion.isModoContingencia() ? "SIM" : "NAO")));
                    displayModel.addLinha(new Linha(""));
                    displayModel.addLinha(new Linha(""));
                    displayModel.addLinha(new Linha("SELECIONE A CONFIGURACAO DESEJADA"));
                    displayModel.addLinha(new Linha(""));
                    displayModel.addLinha(new Linha("[1] - UTILIZAR FUSION " + (!ControladorFusion.isModoContingencia() ? "(ATUAL)" : "")));
                    displayModel.addLinha(new Linha("[2] - UTILIZAR CONTINGENCIA " + (ControladorFusion.isModoContingencia() ? "(ATUAL)" : "")));
                    EventoTeclado eventoTeclado = (EventoTeclado)perifericos.capturaDado(displayModel, true, ConstantesApiAc.CAP_QUESTIONAMENTO_CONTINGENCIA_FUSION);
                    if (eventoTeclado.getTeclaFinalizadora().equals("VOLTA")) {
                        this.logger.log((Priority)Level.INFO, (Object)"Tecla volta pressionada");
                    } else {
                        String value = eventoTeclado.getStringLida();
                        if (value.equals("1")) {
                            ControladorFusion.setModoContingencia(false);
                            displayModel = new LayoutDisplay();
                            displayModel.addLinha(new Linha("APLICATIVO UTILIZARA"));
                            displayModel.addLinha(new Linha("INTEGRACAO FUSION"));
                            displayModel.setDelay(1500L);
                            perifericos.imprimeDisplay(displayModel);
                        } else {
                            if (!value.equals("2")) throw new IllegalArgumentException("op\u00e7\u00e3o inv\u00e1lida");
                            ControladorFusion.setModoContingencia(true);
                            displayModel = new LayoutDisplay();
                            displayModel.addLinha(new Linha("APLICATIVO ENTROU EM"));
                            displayModel.addLinha(new Linha("MODO DE CONTINGENCIA"));
                            displayModel.setDelay(1500L);
                            perifericos.imprimeDisplay(displayModel);
                        }
                    }
                } else {
                    this.logger.log((Priority)Level.INFO, (Object)"Fusion n\u00e3o configurado");
                    LayoutDisplay displayModel = new LayoutDisplay();
                    displayModel.addLinha(new Linha("FUSION NAO CONFIGURADO"));
                    displayModel.setDelay(1500L);
                    perifericos.imprimeDisplay(displayModel);
                }
                SaidaApiTefC saidaApiTefC = new SaidaApiTefC();
                saidaApiTefC.setRetorno(0);
                dados.setSaidaApiTef(saidaApiTefC);
                EntradaApiTefC entradaApiTefC = new EntradaApiTefC();
                entradaApiTefC.setOperacao("6N");
                dados.setEntradaApiTef(entradaApiTefC);
                return SUCCESS;
            }
            if (opcao == 11) {
                ProcessValeGas processValeGas = new ProcessValeGas(entradaIntegracao, 1, entradaIntegracao.getNumeroCupom());
                processValeGas.setParent((Process)((Object)dados));
                processManager.subProcess(dados.getIdProcess(), processValeGas);
                ((Process)((Object)dados)).setErro(processValeGas.getErro());
                dados.setEntradaIntegracao(processValeGas.getEntradaIntegracao());
                dados.setSaidaApiTef(processValeGas.getSaidaApiTef());
                dados.setEntradaApiTef(processValeGas.getEntradaApiTef());
                dados.setCodigoAutorizadora(processValeGas.getCodigoAutorizadora());
                dados.setCodigoInstituicaoFinanceira(processValeGas.getCodigoInstituicaoFinanceira());
                dados.setCodigoVan(processValeGas.getCodigoVan());
                dados.setNomeAutorizadora(processValeGas.getNomeAutorizadora());
                dados.setNomeInstituicaoFinanceira(processValeGas.getNomeInstituicaoFinanceira());
                dados.setNomeVan(processValeGas.getNomeVan());
                state = processValeGas.getState();
            }
        }
        if (state == 1) {
            return ERROR;
        }
        if (state == 0) {
            return SUCCESS;
        }
        if (state == 3) {
            return USER_CANCEL_INTERNAL;
        }
        if (state != 6) return SUCCESS;
        return ERROR_AC;
    }

    private int executaReimpressaoOutrosComprovantes(ITefDiscadoOperacaoADM dados, EntradaCTFClientCtrl entradaIntegracao) throws Exception {
        ProcessManager processManager = ProcessManager.getInstance();
        ProcessReimpressaoComprovante processReimpressao = new ProcessReimpressaoComprovante(entradaIntegracao);
        processReimpressao.setParent((Process)((Object)dados));
        processManager.subProcess(dados.getIdProcess(), processReimpressao);
        ((Process)((Object)dados)).setErro(processReimpressao.getErro());
        dados.setErroIntegracao(processReimpressao.getErroIntegracao());
        dados.setSaidaApiTef(processReimpressao.getSaidaApiTef());
        dados.setEntradaApiTef(processReimpressao.getEntradaApiTef());
        if (processReimpressao.getSaidaApiTef().getRetorno() == 0) {
            String cupom2;
            File fileCupom2;
            ConfCTFClient conf = ControladorConfCTFClient.getInstance().getConfig();
            IdentApiTefC identApiTefC = new IdentApiTefC();
            identApiTefC.setNumeroEstabelecimento(conf.getEstabelecimento());
            identApiTefC.setNumeroLoja(conf.getLoja());
            identApiTefC.setNumeroPdv(conf.getTerminal());
            identApiTefC.setNumeroSites(String.valueOf(conf.getNumeroSites()));
            identApiTefC.setListaIP(conf.getIps());
            identApiTefC.setQuantidadeVias(conf.getQuantidadeVias());
            processReimpressao.getApitef().getCupom(identApiTefC, processReimpressao.getEntradaApiTef(), processReimpressao.getSaidaApiTef());
            processReimpressao.getEntradaApiTef().setNumeroTransacao(0);
            ControladorConfCTFClient controladorConf = ControladorConfCTFClient.getInstance();
            ConfCTFClient confCTFClient = controladorConf.getConfig();
            IdentTerminal identTerminal = new IdentTerminal(confCTFClient.getEstabelecimento(), confCTFClient.getLoja(), confCTFClient.getTerminal());
            int idxEmpresa = confCTFClient.getVersaoPathTerminal() == 1 ? 0 : 1;
            String path = identTerminal.getEstabelecimento().substring(idxEmpresa) + identTerminal.getLoja() + "." + identTerminal.getTerminal() + File.separator;
            if (ControladorConfCTFClient.getDiretorioTrabalho() != null) {
                path = ControladorConfCTFClient.getDiretorioTrabalho() + path;
            }
            String cupom3 = path + "CUPOMCTF.3" + StringUtil.completaString(entradaIntegracao.getNumeroTransacao() + "", 2, '0', 3);
            File fileCupom3 = new File(cupom3);
            String cupom1 = path + "CUPOMCTF.1" + StringUtil.completaString(entradaIntegracao.getNumeroTransacao() + "", 2, '0', 3);
            File fileCupom1 = new File(cupom1);
            if (fileCupom1.exists()) {
                this.copiaCupom(fileCupom1, fileCupom3);
            }
            if ((fileCupom2 = new File(cupom2 = path + "CUPOMCTF.2" + StringUtil.completaString(entradaIntegracao.getNumeroTransacao() + "", 2, '0', 3))).exists()) {
                String cupom4 = path + "CUPOMCTF.4" + StringUtil.completaString(entradaIntegracao.getNumeroTransacao() + "", 2, '0', 3);
                File fileCupom4 = new File(cupom4);
                this.copiaCupom(fileCupom2, fileCupom4);
            }
        }
        return processReimpressao.getState();
    }

    private boolean copiaCupom(File cupom, File novoCupom) {
        try {
            int c;
            FileReader in = new FileReader(cupom);
            if (cupom.exists()) {
                cupom.delete();
            }
            FileWriter out = new FileWriter(novoCupom);
            while ((c = in.read()) != -1) {
                out.write(c);
            }
            in.close();
            out.close();
            return true;
        }
        catch (IOException e) {
            System.out.println(e);
            return false;
        }
    }

    private boolean testaComunicacaoCTF(ITefDiscadoOperacaoADM dados) {
        String terminalOriginal = dados.getEntradaIntegracao().getIdentTerminal().getTerminal();
        dados.getEntradaIntegracao().getIdentTerminal().setTerminal("ZZZ");
        dados.getEntradaIntegracao().setMultiTerminal(true);
        ProcessManager processManager = ProcessManager.getInstance();
        boolean retorno = false;
        ProcessPing processPing = new ProcessPing(dados.getEntradaIntegracao());
        processPing.setParent((Process)((Object)dados));
        try {
            processManager.subProcess(dados.getIdProcess(), processPing);
            if (processPing.getSaidaApiTef().getRetorno() != 1 && processPing.getSaidaApiTef().getRetorno() != 10) {
                retorno = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        dados.getEntradaIntegracao().setMultiTerminal(false);
        dados.getEntradaIntegracao().getIdentTerminal().setTerminal(terminalOriginal);
        return retorno;
    }
}

