/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.ProcessManager;
import com.csi.ctfclient.operacoes.action.ProcessConfirmacao;
import com.csi.ctfclient.operacoes.action.ProcessDesfazimento;
import com.csi.ctfclient.operacoes.entrada.IIntegracao;
import com.csi.ctfclient.operacoes.model.DadosConfirmacaoDesfazimento;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.servicos.IdentTerminal;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.util.PersistService;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import org.apache.log4j.Logger;

public class MicTefIPVerificaPendencia {
    public static final String SUCCESS = "SUCCESS";
    public static final String ERROR = "ERROR";
    public static final String CONFIRMED = "CONFIRMED";
    public static final String NOT_CONFIRMED = "NOT_CONFIRMED";
    public static final String USER_CANCEL = "USER_CANCEL";
    private Logger logger = CTFClientLogger.getCTFClient();

    public String execute(IIntegracao dados) throws Exception {
        ConfCTFClient conf = ControladorConfCTFClient.getInstance().getConfig();
        if (!conf.isConfirmarDesfazimento()) {
            return SUCCESS;
        }
        IdentTerminal identTerminal = new IdentTerminal(conf.getEstabelecimento(), conf.getLoja(), conf.getTerminal());
        Collection dadosEntrada = PersistService.getInstance().loadAll(identTerminal, conf.getVersaoPathTerminal());
        if (dadosEntrada != null && !dadosEntrada.isEmpty()) {
            EntradaCTFClientCtrl entradaIntegracao = dados.getEntradaIntegracao();
            if (entradaIntegracao != null && (entradaIntegracao.getNumeroTransacao() > 1 || entradaIntegracao.getOperacao() == 6 || entradaIntegracao.getOperacao() == 279 || entradaIntegracao.getOperacao() == 280 || entradaIntegracao.getOperacao() == 7 || entradaIntegracao.getOperacao() == 191 || entradaIntegracao.getOperacao() == 281 || entradaIntegracao.getOperacao() == 225 || entradaIntegracao.getOperacao() == 239 || entradaIntegracao.getOperacao() == 12 || entradaIntegracao.getOperacao() == 800 || entradaIntegracao.getOperacao() == 908 || entradaIntegracao.isConsulta())) {
                this.logger.warn((Object)("verifica\u00e7\u00e3o de pendencias desabilitada. transa\u00e7\u00f5es pendentes = " + dadosEntrada.size()));
                return SUCCESS;
            }
            DadosConfirmacaoDesfazimento dadosTransacao = (DadosConfirmacaoDesfazimento)dadosEntrada.iterator().next();
            ControladorPerifericos perifericos = dados.getPerifericos();
            LayoutDisplay displayModel = new LayoutDisplay("TRANSACAO PENDENTE DE CONFIRMACAO");
            displayModel.addLinha(new Linha(""));
            displayModel.addLinha(new Linha("NSU: " + StringUtil.completaString(dadosTransacao.getNsu() + "", 6, '0', 3), 0));
            SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yy");
            displayModel.addLinha(new Linha("DATA DA VENDA: " + dateFormat.format(dadosTransacao.getDataCliente()), 0));
            if (dadosTransacao.getValorTransacao() != null) {
                DecimalFormat decimalFormat = new DecimalFormat("#,##0.00");
                displayModel.addLinha(new Linha("VALOR DA VENDA: " + decimalFormat.format(dadosTransacao.getValorTransacao()), 0));
            }
            displayModel.addLinha(new Linha("DESEJA CONFIRMAR?", 0, 2));
            displayModel.addLinha(new Linha("[1] - SIM"));
            displayModel.addLinha(new Linha("[2] - NAO"));
            boolean valorValido = false;
            while (!valorValido) {
                boolean decisao;
                EventoTeclado eventoTeclado = (EventoTeclado)perifericos.capturaDado(displayModel, true, ConstantesApiAc.CAP_QUESTIONAMENTO_TRANS_PENDENTE);
                if (eventoTeclado.getTeclaFinalizadora().equals("VOLTA")) {
                    return USER_CANCEL;
                }
                String value = eventoTeclado.getStringLida();
                if (value.equals("1")) {
                    ProcessManager processManager = ProcessManager.getInstance();
                    ProcessConfirmacao processConfirmacao = new ProcessConfirmacao(entradaIntegracao);
                    processConfirmacao.setParent((Process)((Object)dados));
                    processManager.subProcess(dados.getIdProcess(), processConfirmacao);
                    if (processConfirmacao.getSaidaApiTef().getRetorno() == 0 || processConfirmacao.getSaidaApiTef().getRetorno() == 13) {
                        if (entradaIntegracao.getNumeroTransacao() > 0) {
                            String key = String.valueOf(entradaIntegracao.getNumeroTransacao());
                            PersistService.getInstance().remove(key, identTerminal, conf.getVersaoPathTerminal());
                        }
                        LayoutDisplay layoutDisplay = new LayoutDisplay("TRANSACAO CONFIRMADA", 1500L);
                        perifericos.imprimeDisplay(layoutDisplay);
                        return CONFIRMED;
                    }
                    ((Process)((Object)dados)).setErro(processConfirmacao.getErro());
                    return ERROR;
                }
                if (!value.equals("2") || (decisao = false)) continue;
                LayoutDisplay layoutDisplay = new LayoutDisplay();
                layoutDisplay.addLinha(new Linha("ESSA DECISAO IRA DESFAZER"));
                layoutDisplay.addLinha(new Linha("A TRANSACAO NA AUTORIZADORA"));
                layoutDisplay.addLinha(new Linha("E O CLIENTE NAO SERA COBRADO."));
                layoutDisplay.addLinha(new Linha("CONFIRMAR DECISAO?", 0, 2));
                layoutDisplay.addLinha(new Linha("[1] - SIM"));
                layoutDisplay.addLinha(new Linha("[2] - NAO"));
                eventoTeclado = (EventoTeclado)perifericos.capturaDado(layoutDisplay, true, ConstantesApiAc.CAP_QUESTIONAMENTO_TRANS_PENDENTE);
                if (eventoTeclado.getTeclaFinalizadora().equals("VOLTA")) {
                    return USER_CANCEL;
                }
                String confirmar = eventoTeclado.getStringLida();
                if (confirmar.equals("1")) {
                    ProcessManager processManager = ProcessManager.getInstance();
                    ProcessDesfazimento processDesfazimento = new ProcessDesfazimento(dados.getEntradaIntegracao(), dados.getEntradaIntegracao().getNumeroTransacao());
                    processDesfazimento.setParent((Process)((Object)dados));
                    processManager.subProcess(dados.getIdProcess(), processDesfazimento);
                    if (processDesfazimento.getSaidaApiTef().getRetorno() == 0 || processDesfazimento.getSaidaApiTef().getRetorno() == 13) {
                        if (dados.getEntradaIntegracao().getNumeroTransacao() > 0) {
                            String key = String.valueOf(dados.getEntradaIntegracao().getNumeroTransacao());
                            PersistService.getInstance().remove(key, identTerminal, conf.getVersaoPathTerminal());
                        }
                        layoutDisplay = new LayoutDisplay("TRANSACAO DESFEITA", 1500L);
                        perifericos.imprimeDisplay(layoutDisplay);
                        return NOT_CONFIRMED;
                    }
                    ((Process)((Object)dados)).setErro(processDesfazimento.getErro());
                    return ERROR;
                }
                return USER_CANCEL;
            }
        }
        return SUCCESS;
    }
}

