/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.excecoes.ExcecaoCodigoInvalido;
import com.csi.ctfclient.excecoes.ExcecaoDigitoInvalido;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.tiposgerais.CodigoFebraban;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.IValidaCodigoBarras;
import com.csi.ctfclient.operacoes.model.AbstractCodigoPagamento;
import com.csi.ctfclient.operacoes.model.CodigoBarrasConvenio;
import com.csi.ctfclient.operacoes.model.CodigoBarrasTitulo;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.operacoes.model.CodigoPagamentoTitulo;
import com.csi.ctfclient.operacoes.model.LinhaDigitavelTitulo;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.codigobarras.CalculadorDigito;
import com.csi.ctfclient.tools.util.codigobarras.CodigoBarrasUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import java.math.BigDecimal;

public class MicValidaCodigoBarras {
    public static final String SUCESS = "SUCESS";
    public static final String INVALID_CODE = "INVALID_CODE";
    public static final String DOCUMENT_ALREADY_READ = "DOCUMENT_ALREADY_READ";
    public static final String CONTINUE_READING = "CONTINUE_READING";
    public static final String ERROR_AC = "ERROR_AC";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String execute(IValidaCodigoBarras dados) throws ExcecaoApiAc {
        int tipoConta;
        String numeroDocumentoComDigitos;
        String numeroDocumento;
        ConfCTFClient confCTFClient;
        block54: {
            String numeroDocumentoUltimoDigitado;
            InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
            ControladorPerifericos perifericos = dados.getPerifericos();
            confCTFClient = ControladorConfCTFClient.getInstance().getConfig();
            if (dados.getCodigoBarras() == null && dados.getLinhaDigitavel() == null) {
                throw new IllegalArgumentException("C\u00f3digo para pagamento n\u00e3o informado!");
            }
            numeroDocumento = numeroDocumentoUltimoDigitado = dados.getCodigoBarras() != null ? dados.getCodigoBarras() : dados.getLinhaDigitavel();
            numeroDocumentoComDigitos = null;
            int numeroBloco = dados.getNumeroBloco();
            tipoConta = 0;
            if (numeroBloco > 1) {
                numeroDocumento = dados.getCodigoBarrasParcial() + numeroDocumentoUltimoDigitado;
            }
            if (numeroBloco == 1) {
                int primeirosDigitos;
                tipoConta = 2;
                if (numeroDocumento.length() < 3) {
                    this.exibeMensagemErro(perifericos, inter.getMessage("VALCODBAR_ERRO_COD_INVALIDO"));
                    dados.setCodigoBarras(null);
                    return INVALID_CODE;
                }
                try {
                    primeirosDigitos = Integer.parseInt(numeroDocumento.substring(0, 3));
                }
                catch (NumberFormatException e) {
                    this.exibeMensagemErro(perifericos, inter.getMessage("VALCODBAR_ERRO_COD_INVALIDO"));
                    dados.setCodigoBarras(null);
                    return INVALID_CODE;
                }
                if (primeirosDigitos < 810) {
                    if (dados.getEntradaIntegracao() != null && dados.getEntradaIntegracao().getOperacao() != 230 && dados.getEntradaIntegracao().getOperacao() != 180 && dados.getEntradaIntegracao().getOperacao() != 153 && dados.getEntradaIntegracao().getOperacao() != 152 && dados.getEntradaIntegracao().getOperacao() != 182 && dados.getEntradaIntegracao().getOperacao() != 183) {
                        dados.setErroIntegracao(new CodigoErroIntegracao(5306, inter.getMessage("VALCODBAR_OPERACAO_NAO_PERMITIDA")));
                        return ERROR_AC;
                    }
                    tipoConta = 1;
                } else if (dados.getEntradaIntegracao() != null && dados.getEntradaIntegracao().getOperacao() != 231 && dados.getEntradaIntegracao().getOperacao() != 181 && dados.getEntradaIntegracao().getOperacao() != 155 && dados.getEntradaIntegracao().getOperacao() != 154) {
                    dados.setErroIntegracao(new CodigoErroIntegracao(5306, inter.getMessage("VALCODBAR_OPERACAO_NAO_PERMITIDA")));
                    return ERROR_AC;
                }
                dados.setTipoConta(tipoConta);
            }
            if ((tipoConta = dados.getTipoConta()) == 1 && dados.getModoEntradaCodigoBarras() == 1 && numeroBloco == 5 && numeroDocumentoUltimoDigitado.length() >= 0 && numeroDocumentoUltimoDigitado.length() <= 10) {
                numeroDocumento = dados.getCodigoBarrasParcial() + StringUtil.completaString(numeroDocumentoUltimoDigitado, 14, '0', 3);
            }
            if (numeroDocumento.length() < 44) {
                if (tipoConta == 2 && numeroBloco == 4) {
                    if (numeroDocumento.length() != 12) {
                        this.exibeMensagemErro(perifericos, inter.getMessage("VALCODBAR_ERRO_COD_INVALIDO"));
                        dados.setCodigoBarras(null);
                        return INVALID_CODE;
                    }
                    try {
                        CodigoFebraban.validaDigitoGrupo(numeroDocumento);
                    }
                    catch (ExcecaoDigitoInvalido e) {
                        this.exibeMensagemErro(perifericos, inter.getMessage("VALCODBAR_ERRO_COD_INVALIDO"));
                        dados.setCodigoBarras(null);
                        return INVALID_CODE;
                    }
                }
                if (tipoConta == 1 && numeroBloco == 5) {
                    if (numeroDocumento.length() != 10) {
                        this.exibeMensagemErro(perifericos, inter.getMessage("VALCODBAR_ERRO_COD_INVALIDO"));
                        dados.setCodigoBarras(null);
                        return INVALID_CODE;
                    }
                    try {
                        CodigoFebraban.validaDigitoGrupo("00" + numeroDocumento);
                    }
                    catch (ExcecaoDigitoInvalido e) {
                        this.exibeMensagemErro(perifericos, inter.getMessage("VALCODBAR_ERRO_COD_INVALIDO"));
                        dados.setCodigoBarras(null);
                        return INVALID_CODE;
                    }
                }
            }
            boolean capturaCodigoCompleta = false;
            try {
                int i;
                if (dados.getModoEntradaCodigoBarras() == 1 && tipoConta == 2) {
                    if (confCTFClient.isCapturaApenasLinhaDigitavel() && numeroBloco == 1 && numeroDocumento.length() == 48) {
                        for (i = 1; i < 5; ++i) {
                            CodigoBarrasUtil.validaBlocoParcialConvenio(numeroDocumento, i);
                        }
                        numeroBloco = 4;
                    } else {
                        if (numeroBloco == 1 && numeroDocumento.length() != 12) {
                            this.exibeMensagemErro(perifericos, inter.getMessage("VALCODBAR_ERRO_COD_INVALIDO"));
                            dados.setCodigoBarras(null);
                            dados.setTipoConta(0);
                            return INVALID_CODE;
                        }
                        CodigoBarrasUtil.validaBlocoParcialConvenio(numeroDocumento, numeroBloco);
                    }
                    if (dados.getCodigoBarrasParcial() == null) {
                        dados.setCodigoBarrasParcial("");
                    }
                    dados.setCodigoBarrasParcial(dados.getCodigoBarrasParcial() + numeroDocumentoUltimoDigitado);
                    dados.setNumeroBloco(++numeroBloco);
                    if (dados.getNumeroBloco() <= 4) {
                        return CONTINUE_READING;
                    }
                    capturaCodigoCompleta = true;
                    numeroDocumentoComDigitos = numeroDocumento;
                    numeroDocumento = AbstractCodigoPagamento.retiraDigitos(numeroDocumento);
                } else if (dados.getModoEntradaCodigoBarras() != 1 || tipoConta == 2) {
                    // empty if block
                }
                if (tipoConta == 2) {
                    CodigoFebraban.validaDigitoGeral(numeroDocumento);
                    break block54;
                }
                if (dados.getModoEntradaCodigoBarras() == 3 || dados.getModoEntradaCodigoBarras() == 3) {
                    CalculadorDigito.validaDigitoModulo11(numeroDocumento, 5, 1);
                    break block54;
                }
                if (dados.getModoEntradaCodigoBarras() == 1) {
                    if (confCTFClient.isCapturaApenasLinhaDigitavel() && numeroBloco == 1 && numeroDocumento.length() >= 33) {
                        numeroDocumento = CodigoBarrasUtil.formataLinhaDigitavelTitulo(numeroDocumento);
                        for (i = 1; i < 6; ++i) {
                            CodigoBarrasUtil.validaBlocoParcialTituloDigitavel(numeroDocumento, i);
                        }
                        numeroBloco = 5;
                    } else {
                        if (confCTFClient.isCapturaApenasLinhaDigitavel() && numeroBloco == 1 && numeroDocumento.length() != 10) {
                            this.exibeMensagemErro(perifericos, inter.getMessage("VALCODBAR_ERRO_COD_INVALIDO"));
                            dados.setCodigoBarras(null);
                            dados.setTipoConta(0);
                            return INVALID_CODE;
                        }
                        CodigoBarrasUtil.validaBlocoParcialTituloDigitavel(numeroDocumento, numeroBloco);
                    }
                    if (dados.getCodigoBarrasParcial() == null) {
                        dados.setCodigoBarrasParcial("");
                    }
                    dados.setCodigoBarrasParcial(dados.getCodigoBarrasParcial() + numeroDocumentoUltimoDigitado);
                    dados.setNumeroBloco(++numeroBloco);
                    if (dados.getNumeroBloco() <= 5) {
                        return CONTINUE_READING;
                    }
                }
            }
            catch (ExcecaoDigitoInvalido e) {
                if (numeroBloco > 4 && capturaCodigoCompleta) {
                    dados.setNumeroBloco(1);
                    dados.setCodigoBarrasParcial(null);
                }
                this.exibeMensagemErro(perifericos, inter.getMessage("VALCODBAR_ERRO_COD_INVALIDO"));
                dados.setCodigoBarras(null);
                return INVALID_CODE;
            }
            catch (ExcecaoCodigoInvalido e) {
                if (tipoConta == 1 && numeroBloco == 5) {
                    dados.setNumeroBloco(1);
                    dados.setCodigoBarras(null);
                    dados.setCodigoBarrasParcial(null);
                    dados.setTipoConta(0);
                } else if (confCTFClient.isCapturaApenasLinhaDigitavel() && numeroBloco == 1) {
                    dados.setTipoConta(0);
                }
                this.exibeMensagemErro(perifericos, inter.getMessage("VALCODBAR_ERRO_COD_INVALIDO"));
                dados.setCodigoBarras(null);
                return INVALID_CODE;
            }
        }
        AbstractCodigoPagamento codigoPagamento = null;
        if (tipoConta == 1) {
            codigoPagamento = dados.getModoEntradaCodigoBarras() == 3 || dados.getModoEntradaCodigoBarras() == 3 ? new CodigoBarrasTitulo(numeroDocumento) : new LinhaDigitavelTitulo(numeroDocumento);
        } else if (tipoConta == 2) {
            codigoPagamento = new CodigoBarrasConvenio(numeroDocumento);
        }
        if (codigoPagamento.getValor() != null && !codigoPagamento.getValor().equals(new BigDecimal("0.00"))) {
            dados.setValorDocumento(codigoPagamento.getValor());
            dados.setConfirmacaoValorDocumento(true);
            dados.setValorDocumentoLido(true);
        } else {
            dados.setValorDocumentoLido(false);
        }
        if (tipoConta == 1 && dados.getDataVencimentoCorBan() == null) {
            dados.setDataVencimentoCorBan(((CodigoPagamentoTitulo)codigoPagamento).getDataVencimento());
            dados.setDataVencimentoLida(dados.getDataVencimentoCorBan() != null);
            dados.setConfirmacaoDataVencimento(true);
        }
        if (dados.getModoEntradaCodigoBarras() == 1 && tipoConta == 2) {
            numeroDocumento = numeroDocumentoComDigitos;
        }
        if (!confCTFClient.isCapturaApenasLinhaDigitavel()) {
            dados.setCodigoBarras(numeroDocumento);
            return SUCESS;
        }
        if (dados.getModoEntradaCodigoBarras() != 1) return SUCESS;
        if (tipoConta == 1) {
            String novoCodigo = CodigoBarrasUtil.converteLinhaDigitavelTitulo(numeroDocumento);
            dados.setCodigoBarras(novoCodigo);
            dados.setModoEntradaCodigoBarras(3);
            return SUCESS;
        }
        String novoCodigo = CodigoBarrasUtil.converteLinhaDigitavelConvenio(numeroDocumento);
        dados.setCodigoBarras(novoCodigo);
        dados.setModoEntradaCodigoBarras(3);
        return SUCESS;
    }

    private void exibeMensagemErro(ControladorPerifericos perifericos, String mensagem) throws ExcecaoNaoLocal {
        LayoutDisplay displayModel = new LayoutDisplay(mensagem);
        perifericos.confirmaDado(displayModel);
    }
}

