/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.IDadosCancelamento;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import java.math.BigDecimal;

public class MicValidaValorCancelamento {
    public static final String UNECESSARY = "UNECESSARY";
    public static final String SUCESS = "SUCESS";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String CANCELAMENTO_PARCIAL = "CANCELAMENTO_PARCIAL";
    public static final String VERIFICAR_FINANCIAMENTO = "VERIFICAR_FINANCIAMENTO";
    public static final String EXIBIR_DADOS_CANCELAMENTO = "EXIBIR_DADOS_CANCELAMENTO";
    public static final String ERROR = "ERROR";
    public static final String ERROR_AC = "ERROR_AC";

    public String execute(IDadosCancelamento dados) throws ExcecaoApiAc {
        BigDecimal valorTotalCancelamento;
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        boolean multiTerminal = dados.getEntradaIntegracao() != null && dados.getEntradaIntegracao().isMultiTerminal();
        ControladorPerifericos perifericos = dados.getPerifericos();
        boolean parcialHabilitado = dados.getSaidaApiTef().isCancelamentoParcial();
        BigDecimal valorTransacao = dados.getValorTransacao();
        BigDecimal valorCancelamento = dados.getValorCancelamento();
        BigDecimal valorMaxCancelamento = valorTransacao;
        BigDecimal percentualCancelamento = new BigDecimal(0);
        if (dados.getSaidaApiTef().getValorMaxCancelamento() != null) {
            valorMaxCancelamento = dados.getSaidaApiTef().getValorMaxCancelamento();
        }
        if (dados.getSaidaApiTef().getPercentualMaxCancelamento() != null) {
            percentualCancelamento = dados.getSaidaApiTef().getPercentualMaxCancelamento();
        }
        BigDecimal indice = percentualCancelamento.divide(new BigDecimal(100), 0);
        BigDecimal valorPercentual = valorTransacao.add(valorTransacao.multiply(indice));
        if (valorCancelamento.compareTo(valorMaxCancelamento) == 1) {
            if (multiTerminal) {
                dados.setErroIntegracao(new CodigoErroIntegracao(5373, "O VALOR E MAIOR QUE O VALOR PERMITIDO PARA CANCELAMENTO"));
            }
            if (this.exibeMensagem(inter.getMessage("VALVALCAN_INVALID_VALUE"), perifericos).equals("ENTRA")) {
                if (parcialHabilitado) {
                    return CANCELAMENTO_PARCIAL;
                }
                dados.setDataTransacao(null);
                dados.setNsuTransacao(0);
                dados.setValorTransacao(null);
                dados.setValorCancelamento(null);
                dados.setCartao(null);
                return ERROR;
            }
            return USER_CANCEL;
        }
        if (valorCancelamento.compareTo(valorTransacao) == 1) {
            if (!parcialHabilitado) {
                if (multiTerminal) {
                    dados.setErroIntegracao(new CodigoErroIntegracao(5374, "O VALOR DO CANCELAMENTO E MAIOR QUE O VALOR DA TRANSACAO ORIGINAL"));
                    return ERROR_AC;
                }
                if (this.exibeMensagem(inter.getMessage("VALVALCAN_INVALID_VALUE"), perifericos).equals("ENTRA")) {
                    return CANCELAMENTO_PARCIAL;
                }
                return USER_CANCEL;
            }
            if (valorCancelamento.compareTo(valorPercentual) == 1) {
                if (multiTerminal) {
                    dados.setErroIntegracao(new CodigoErroIntegracao(5375, "O VALOR E MAIOR QUE O PERCENTUAL PARA CANCELAMENTO"));
                    return ERROR_AC;
                }
                if (this.exibeMensagem(inter.getMessage("VALVALCAN_INVALID_VALUE"), perifericos).equals("ENTRA")) {
                    if (parcialHabilitado) {
                        return CANCELAMENTO_PARCIAL;
                    }
                    return ERROR;
                }
                return USER_CANCEL;
            }
            if (dados.isTransacaoSemLog()) {
                return VERIFICAR_FINANCIAMENTO;
            }
            return EXIBIR_DADOS_CANCELAMENTO;
        }
        if (dados.isTransacaoSemLog()) {
            return VERIFICAR_FINANCIAMENTO;
        }
        if (parcialHabilitado && ((valorTotalCancelamento = valorCancelamento.add(dados.getSaidaApiTef().getValorJaCancelado())).compareTo(valorPercentual) == 1 || valorTotalCancelamento.compareTo(valorMaxCancelamento) == 1)) {
            if (multiTerminal) {
                dados.setErroIntegracao(new CodigoErroIntegracao(5376, "O VALOR DO CANCELAMENTO SOMADO AO VALOR JA CANCELADO E MAIOR QUE O PERCENTUAL PARA CANCELAMENTO"));
                return ERROR_AC;
            }
            if (this.exibeMensagem(inter.getMessage("VALVALCAN_INVALID_VALUE"), perifericos).equals("ENTRA")) {
                return CANCELAMENTO_PARCIAL;
            }
            return USER_CANCEL;
        }
        return EXIBIR_DADOS_CANCELAMENTO;
    }

    private String exibeMensagem(String msg, ControladorPerifericos perifericos) throws ExcecaoNaoLocal {
        LayoutDisplay displayModel = new LayoutDisplay(msg);
        EventoTeclado eventoTeclado = (EventoTeclado)perifericos.confirmaDado(displayModel);
        return eventoTeclado.getTeclaFinalizadora();
    }
}

