/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.IDadoCartaoMutable;
import com.csi.ctfclient.operacoes.model.CartaoDigitado;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;

public class MicVencimentoCartao {
    public static final String SUCESS = "SUCESS";
    public static final String FILLED = "FILLED";
    public static final String UNECESSARY = "UNECESSARY";
    public static final String USERCANCEL = "USERCANCEL";
    public static final String ERRO_INVALID_DATA = "ERRO_INVALID_DATA";
    public static final String ERRO_INVALID_DATA_AC = "ERRO_INVALID_DATA_AC";
    public static final String ERRO_INVALID_DATA_21YEAR = "ERRO_INVALID_DATA_21YEAR";
    public static final String ERRO_INVALID_DATA_21YEAR_AC = "ERRO_INVALID_DATA_21YEAR_AC";

    public String execute(IDadoCartaoMutable dadoCartao) throws ExcecaoNaoLocal, IllegalArgumentException {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        if (dadoCartao.getSaidaApiTef() != null && !dadoCartao.getSaidaApiTef().isSolicitarDataVencimentoCartao()) {
            return UNECESSARY;
        }
        if (dadoCartao.getCartao().getVencimento() != null) {
            return UNECESSARY;
        }
        if (!(dadoCartao.getCartao() instanceof CartaoDigitado)) {
            throw new IllegalArgumentException("Argumento do parametro getCartao() n\u00e3o \u00e9 uma instancia de CartaoDigitado");
        }
        CartaoDigitado cartaoDigitado = (CartaoDigitado)dadoCartao.getCartao();
        if (dadoCartao.getEntradaIntegracao() != null) {
            if (dadoCartao.getEntradaIntegracao().isDataVencimentoCartaoCtrl()) {
                String dataVencimento = dadoCartao.getEntradaIntegracao().getDataVencimentoCartao();
                if (!CartaoDigitado.isValidaVencimento(dataVencimento)) {
                    dadoCartao.setErroIntegracao(new CodigoErroIntegracao(5302, inter.getMessage("VENCAR_CARTAO_VENCIDO")));
                    return ERRO_INVALID_DATA_AC;
                }
                if (!CartaoDigitado.isValidaVencimento21Anos(dataVencimento)) {
                    dadoCartao.setErroIntegracao(new CodigoErroIntegracao(5303, inter.getMessage("VENCAR_NOT_VALID")));
                    return ERRO_INVALID_DATA_21YEAR_AC;
                }
                cartaoDigitado = (CartaoDigitado)dadoCartao.getCartao();
                cartaoDigitado.setVencimento(dataVencimento);
                return SUCESS;
            }
            if (dadoCartao.getEntradaIntegracao().isMultiTerminal()) {
                dadoCartao.setErroIntegracao(new CodigoErroIntegracao(5303, inter.getMessage("VENCAR_NOT_VALID")));
                return ERRO_INVALID_DATA_AC;
            }
        }
        ControladorPerifericos perifericos = dadoCartao.getPerifericos();
        String digitos = null;
        int qtdDigitado = 0;
        while (qtdDigitado < 4) {
            LayoutDisplay displayModel = new LayoutDisplay(inter.getMessage("VENCAR_TITLE"));
            EventoTeclado eventoTeclado = (EventoTeclado)perifericos.capturaDado(displayModel, ConstantesApiAc.CAP_DATA_VENCIMENTO_CARTAO, 0, false, 9, false);
            if ("VOLTA".equals(eventoTeclado.getTeclaFinalizadora())) {
                return USERCANCEL;
            }
            qtdDigitado = eventoTeclado.getNumCaracteresDigitados();
            int num = eventoTeclado.getNumCaracteresDigitados();
            digitos = eventoTeclado.getStringLida().substring(0, num);
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("MMyy");
        dateFormat.setLenient(false);
        try {
            dateFormat.parse(digitos);
        }
        catch (ParseException e) {
            this.exibeMensagem(perifericos, inter.getMessage("VENCAR_NOT_VALID_DATE"));
            return ERRO_INVALID_DATA;
        }
        cartaoDigitado.setVencimento(digitos);
        return SUCESS;
    }

    private void exibeMensagem(ControladorPerifericos perifericos, String messagem) throws ExcecaoNaoLocal {
        LayoutDisplay displayModel = new LayoutDisplay(messagem);
        perifericos.confirmaDado(displayModel);
    }
}

