/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.entrada.IConsultaOperadoras;
import com.csi.ctfclient.operacoes.model.ControladorInicioDia;
import com.csi.ctfclient.operacoes.model.DadoPersistencia;
import com.csi.ctfclient.operacoes.model.DadosInicioDia;
import com.csi.ctfclient.operacoes.model.DadosPersistencia;
import com.csi.ctfclient.operacoes.model.controller.ControladorPersistencia;
import com.csi.ctfclient.servicos.IdentTerminal;
import com.csi.ctfclient.tools.util.DateUtil;
import java.util.Date;

public class MicVerificaConsultaOperadoras {
    public static final String REQUIRED = "REQUIRED";
    public static final String NOT_REQUIRED = "NOT_REQUIRED";

    public String execute(IConsultaOperadoras dados) throws ExcecaoApiAc {
        ConfCTFClient config = ControladorConfCTFClient.getInstance().getConfig();
        Date today = new Date();
        ControladorPersistencia controladorPersistencia = ControladorPersistencia.getInstance();
        DadosPersistencia persistencia = null;
        IdentTerminal identTerminal = null;
        identTerminal = dados.getEntradaIntegracao() != null && dados.getEntradaIntegracao().isMultiTerminal() ? dados.getEntradaIntegracao().getIdentTerminal() : new IdentTerminal(config.getEstabelecimento(), config.getLoja(), config.getTerminal());
        ControladorInicioDia controladorInicioDia = ControladorInicioDia.getInstance();
        DadosInicioDia dadosInicioDia = controladorInicioDia.getDadosInicioDia(identTerminal, config.getVersaoPathTerminal());
        if (dados.getTipoOperadora() == 8 && !dadosInicioDia.isConsultaOperadorasCD()) {
            return NOT_REQUIRED;
        }
        try {
            persistencia = controladorPersistencia.getDadosPersistencia(identTerminal, config.getVersaoPathTerminal());
        }
        catch (ExcecaoApiAc e) {
            // empty catch block
        }
        if (persistencia != null) {
            DadoPersistencia dadoPersistencia = null;
            switch (dados.getTipoOperadora()) {
                case 3: {
                    dadoPersistencia = persistencia.getListOperadorasValeGas();
                    break;
                }
                case 4: {
                    dadoPersistencia = persistencia.getListOperadorasTelefonia();
                    break;
                }
                case 8: {
                    dadoPersistencia = persistencia.getListaOperadorasRecarga();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Operadora a ser consultada inv\u00e1lida");
                }
            }
            if (dadoPersistencia != null && DateUtil.equalsData(dadoPersistencia.getUltimaAtualizacao(), today)) {
                return NOT_REQUIRED;
            }
            return REQUIRED;
        }
        return REQUIRED;
    }
}

