/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.entrada.IEstatistica;
import com.csi.ctfclient.operacoes.model.ControladorInicioDia;
import com.csi.ctfclient.operacoes.model.DadosInicioDia;
import com.csi.ctfclient.servicos.IdentTerminal;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import org.apache.log4j.Logger;

public class MicVerificaEstatistica {
    public static final String REQUIRED = "REQUIRED";
    public static final String NOT_REQUIRED = "NOT_REQUIRED";
    private Logger logger = CTFClientLogger.getCTFClient();

    public String execute(IEstatistica dados) {
        try {
            ControladorInicioDia controladorInicioDia = ControladorInicioDia.getInstance();
            boolean multiTerminal = dados.getEntradaIntegracao() != null && dados.getEntradaIntegracao().isMultiTerminal();
            boolean delivery = dados.getEntradaIntegracao() != null && dados.getEntradaIntegracao().getCodigoOrigemTransacao() == 1;
            IdentTerminal identTerminal = null;
            ControladorConfCTFClient controladorConfCTFClient = ControladorConfCTFClient.getInstance();
            ConfCTFClient config = controladorConfCTFClient.getConfig();
            identTerminal = multiTerminal || delivery ? dados.getEntradaIntegracao().getIdentTerminal() : new IdentTerminal(config.getEstabelecimento(), config.getLoja(), config.getTerminal());
            DadosInicioDia dadosInicioDia = controladorInicioDia.getDadosInicioDia(identTerminal, config.getVersaoPathTerminal());
            if (dadosInicioDia.isEstatisticaRedecard()) {
                return REQUIRED;
            }
            return NOT_REQUIRED;
        }
        catch (ExcecaoApiAc e) {
            this.logger.error((Object)"Estat\u00edstica n\u00e3o realizada por erro ao ler o in\u00edcio dia");
            return NOT_REQUIRED;
        }
    }
}

