/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.entrada.IDadosInicioDia;
import com.csi.ctfclient.operacoes.model.ControladorInicioDia;
import com.csi.ctfclient.operacoes.model.DadosInicioDia;
import com.csi.ctfclient.servicos.IdentTerminal;
import com.csi.ctfclient.tools.devices.emvfull.ProtocoloBibliotecaCompartilhada;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import java.util.Date;
import org.apache.log4j.Logger;

public class MicVerificaInicioDia {
    public static final String REQUIRED = "REQUIRED";
    public static final String NOT_REQUIRED = "NOT_REQUIRED";
    public static final String CONFIG_MANUAL = "CONFIG_MANUAL";
    private Logger logger = CTFClientLogger.getCTFClient();

    public String execute(IDadosInicioDia dados) {
        block15: {
            ControladorInicioDia controladorInicioDia = null;
            ControladorConfCTFClient controladorConfCTFClient = null;
            ConfCTFClient config = null;
            DadosInicioDia dadosInicioDia = null;
            IdentTerminal identTerminal = null;
            try {
                if (dados.getEntradaIntegracao() != null && (dados.getEntradaIntegracao().getOperacao() == 800 || dados.getEntradaIntegracao().getOperacao() == 908)) {
                    return NOT_REQUIRED;
                }
                controladorConfCTFClient = ControladorConfCTFClient.getInstance();
                config = controladorConfCTFClient.getConfig();
                controladorInicioDia = ControladorInicioDia.getInstance();
                boolean delivery = dados.getCodigoOrigemTransacao() == 1;
                identTerminal = dados.getEntradaIntegracao() != null && (dados.getEntradaIntegracao().isMultiTerminal() || delivery) ? dados.getEntradaIntegracao().getIdentTerminal() : new IdentTerminal(config.getEstabelecimento(), config.getLoja(), config.getTerminal());
                dadosInicioDia = controladorInicioDia.getDadosInicioDia(identTerminal, config.getVersaoPathTerminal());
                if (dados.getEntradaIntegracao() != null) {
                    boolean inicioDiaNaoRequerido = false;
                    if (dados.getEntradaIntegracao().getNumeroTransacao() != 1) {
                        inicioDiaNaoRequerido = true;
                    } else if (dados.getEntradaIntegracao().getOperacao() == 6 || dados.getEntradaIntegracao().getOperacao() == 7 || dados.getEntradaIntegracao().getOperacao() == 800) {
                        inicioDiaNaoRequerido = true;
                    }
                    if (inicioDiaNaoRequerido && !config.isIntegracaoWeb()) {
                        ProtocoloBibliotecaCompartilhada.setTipoBibliotecaPinpad(dadosInicioDia.getTipoBibliotecaPinpad());
                        return NOT_REQUIRED;
                    }
                }
                if (dadosInicioDia == null || dadosInicioDia.getDataInicioDia() == null) {
                    if (!config.isStandAlone()) {
                        this.logger.warn((Object)"##########################################################");
                        this.logger.warn((Object)"#  CTFClient configurado para Inicio dia Manual. \t\t  #");
                        this.logger.warn((Object)"#  N\u00e3o foi poss\u00edvel carregar o arquivo de inicializa\u00e7\u00e3o. #");
                        this.logger.warn((Object)"##########################################################");
                    }
                    return REQUIRED;
                }
                if (!config.isIntegracaoWeb()) {
                    ProtocoloBibliotecaCompartilhada.setTipoBibliotecaPinpad(dadosInicioDia.getTipoBibliotecaPinpad());
                }
                if (config.isStandAlone()) {
                    if (!dadosInicioDia.equalsData(new Date())) {
                        return REQUIRED;
                    }
                    break block15;
                }
                return CONFIG_MANUAL;
            }
            catch (ExcecaoApiAc e) {
                this.logger.warn((Object)("n\u00e3o foi poss\u00edvel carregar o arquivo de controle inicio dia para o terminal " + identTerminal));
                if (dados.getEntradaIntegracao() != null && dados.getEntradaIntegracao().getOperacao() == 800) {
                    return NOT_REQUIRED;
                }
                if (!config.isStandAlone()) {
                    this.logger.warn((Object)"##########################################################");
                    this.logger.warn((Object)"#  CTFClient configurado para Inicio dia Manual.         #");
                    this.logger.warn((Object)"#  N\u00e3o foi poss\u00edvel carregar o arquivo de inicializa\u00e7\u00e3o. #");
                    this.logger.warn((Object)"##########################################################");
                }
                return REQUIRED;
            }
        }
        return NOT_REQUIRED;
    }
}

