/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.entrada.IDadosCancelamento;
import com.csi.ctfclient.operacoes.model.controller.ControladorAIDsGetCard;
import com.csi.ctfclient.servicos.IdentTerminal;
import java.util.List;

public class MicVerificaLeituraCartaoCancelamento {
    public static final String CARD = "CARD";
    public static final String TELEPHONE = "TELEPHONE";
    public static final String CPF = "CPF";
    public static final String NOT_REQUIRED = "NOT_REQUIRED";
    public static final String OPERATION_NOT_ALLOWED = "OPERATION_NOT_ALLOWED";

    public String execute(IDadosCancelamento dados) throws ExcecaoApiAc {
        SaidaApiTefC saida1G = dados.getSaida1G();
        if (saida1G.isCancelamentoLeituraCartao()) {
            String codigoTransacaoCancelamento;
            if (saida1G != null && saida1G.getCodigoTransacao() != null && (codigoTransacaoCancelamento = saida1G.getCodigoTransacao()) != null && (codigoTransacaoCancelamento.equals("12") || codigoTransacaoCancelamento.equals("10"))) {
                boolean multiTerminal = false;
                boolean delivery = false;
                if (dados.getEntradaIntegracao() != null) {
                    multiTerminal = dados.getEntradaIntegracao().isMultiTerminal();
                    delivery = dados.getEntradaIntegracao().getCodigoOrigemTransacao() == 1;
                } else {
                    delivery = dados.getCodigoOrigemTransacao() == 1;
                }
                ConfCTFClient conf = ControladorConfCTFClient.getInstance().getConfig();
                IdentTerminal identTerminal = null;
                identTerminal = multiTerminal || delivery ? (dados.getEntradaIntegracao() != null ? dados.getEntradaIntegracao().getIdentTerminal() : dados.getIdentTerminal()) : new IdentTerminal(conf.getEstabelecimento(), conf.getLoja(), conf.getTerminal());
                String tipoAplicacao = null;
                if (codigoTransacaoCancelamento.equals("12")) {
                    tipoAplicacao = "01";
                } else if (codigoTransacaoCancelamento.equals("10")) {
                    tipoAplicacao = "02";
                }
                ControladorAIDsGetCard controladorAIDsGetCard = ControladorAIDsGetCard.getInstance(identTerminal, conf.getVersaoPathTerminal());
                if (controladorAIDsGetCard.getMapAid() != null) {
                    List listAIDs = (List)controladorAIDsGetCard.getMapAid().get(tipoAplicacao);
                    dados.setListAID(listAIDs);
                }
            }
            return CARD;
        }
        if (saida1G.isCancelamentoSemCartao()) {
            dados.setErrorCode(-1);
            return NOT_REQUIRED;
        }
        if (saida1G.isCancelamentoLeituraTelefone()) {
            return TELEPHONE;
        }
        if (saida1G.isCancelamentoLeituraCpf()) {
            return CPF;
        }
        throw new IllegalArgumentException("Flag de tipo de leitura de dado no cancelamento inv\u00e1lido");
    }
}

