/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.operacoes.entrada.IDadoPlano;
import com.csi.ctfclient.operacoes.model.PlanoAVista;
import com.csi.ctfclient.operacoes.model.PlanoAdministradora;
import com.csi.ctfclient.operacoes.model.PlanoCDC;
import com.csi.ctfclient.operacoes.model.PlanoFinanciadoLojista;
import com.csi.ctfclient.operacoes.model.PlanoParcelado;
import com.csi.ctfclient.operacoes.model.PlanoParceleMais;
import com.csi.ctfclient.operacoes.model.PlanoPreDatado;

public class MicVerificaTipoFinanciamento {
    public static final String PLANO_AVISTA = "PLANO_AVISTA";
    public static final String PLANO_PREDATADO = "PLANO_PREDATADO";
    public static final String PLANO_PREDATADO_SUPRIME_GARANTIA = "PLANO_PREDATADO_SUPRIME_GARANTIA";
    public static final String PLANO_PARCELADO = "PLANO_PARCELADO";
    public static final String PLANO_CDC = "PLANO_CDC";
    public static final String PLANO_PARCELEMAIS = "PLANO_PARCELEMAIS";
    public static final String PLANO_ADMINISTRADORA = "PLANO_ADMINISTRADOR";
    public static final String PLANO_FINANCIAMENTO_LOJISTA = "PLANO_FINANCIAMENTO_LOJISTA";
    public static final String ERRO = "ERRO";

    public String execute(IDadoPlano dados) {
        if (dados.getTipoFinanciamento() != null) {
            if (dados.getTipoFinanciamento() instanceof PlanoAVista) {
                return PLANO_AVISTA;
            }
            if (dados.getTipoFinanciamento() instanceof PlanoPreDatado) {
                if (dados.getSaidaApiTef() != null && dados.getSaidaApiTef().isSuprimeExibicaoGarantia()) {
                    return PLANO_PREDATADO_SUPRIME_GARANTIA;
                }
                return PLANO_PREDATADO;
            }
            if (dados.getTipoFinanciamento() instanceof PlanoCDC) {
                return PLANO_CDC;
            }
            if (dados.getTipoFinanciamento() instanceof PlanoParceleMais) {
                return PLANO_PARCELEMAIS;
            }
            if (dados.getTipoFinanciamento() instanceof PlanoParcelado) {
                return PLANO_PARCELADO;
            }
            if (dados.getTipoFinanciamento() instanceof PlanoAdministradora) {
                return PLANO_PARCELADO;
            }
            if (dados.getTipoFinanciamento() instanceof PlanoFinanciadoLojista) {
                return PLANO_PARCELADO;
            }
            return ERRO;
        }
        return ERRO;
    }
}

