/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.IVerificaTrocaPinpad;
import com.csi.ctfclient.operacoes.model.CartaoDigitado;
import com.csi.ctfclient.operacoes.model.TabelaCriptografia;

public class MicVerificaTrocaPinpad {
    public static final String VERIFY_DUKPT = "VERIFY_DUKPT";
    public static final String VERIFY_3DES = "VERIFY_3DES";
    public static final String NOT_REQUIRED = "NOT_REQUIRED";
    public static final String ERROR = "ERROR";

    public String execute(IVerificaTrocaPinpad dados) throws ExcecaoApiAc {
        boolean connectedPin;
        if (dados.getCartao() instanceof CartaoDigitado) {
            return NOT_REQUIRED;
        }
        boolean multiTerminal = false;
        boolean delivery = false;
        if (dados.getEntradaIntegracao() != null) {
            multiTerminal = dados.getEntradaIntegracao().isMultiTerminal();
            delivery = dados.getEntradaIntegracao().getCodigoOrigemTransacao() == 1;
        } else {
            boolean bl = delivery = dados.getCodigoOrigemTransacao() == 1;
        }
        if (multiTerminal || delivery) {
            return NOT_REQUIRED;
        }
        ControladorPerifericos periferico = dados.getPerifericos();
        boolean bl = connectedPin = periferico.getPin() != null;
        if (!connectedPin) {
            return NOT_REQUIRED;
        }
        TabelaCriptografia tabelaCriptografia = null;
        SaidaApiTefC saida = dados.getSaidaApiTef();
        if (saida != null) {
            tabelaCriptografia = dados.getTabelaCriptografia();
        }
        if (tabelaCriptografia != null) {
            if (tabelaCriptografia.getCriptografiaSenhaPrincipal() != null && tabelaCriptografia.getCriptografiaSenhaPrincipal().getAlgoritmo() == 3 || tabelaCriptografia.getCriptografiaDadosPrincipal() != null && tabelaCriptografia.getCriptografiaDadosPrincipal().getAlgoritmo() == 3) {
                return VERIFY_DUKPT;
            }
            if (tabelaCriptografia.getCriptografiaSenhaPrincipal() != null && tabelaCriptografia.getCriptografiaSenhaPrincipal().getAlgoritmo() == 1 || tabelaCriptografia.getCriptografiaDadosPrincipal() != null && tabelaCriptografia.getCriptografiaDadosPrincipal().getAlgoritmo() == 1) {
                return VERIFY_3DES;
            }
            return NOT_REQUIRED;
        }
        return ERROR;
    }
}

